#ifndef MOBILE

// Declare Imports

   import java.awt.*;
   import java.awt.event.*;
   import java.io.*;


/** 
 *
 * Class for the GUI key Listener required by the GUI Window.
 *
 * @author   David de Niese
 * @version  0.56f
 * @final    TRUE
 *
 */

final class GUIKeyListener implements KeyListener 
{


     /**
      *
      * <P>The current NES Machine.</P>
      *
      */

      private NES nes;


     /**
      *
      * <P>The current Graphical User Interface.</P>
      *
      */

      private GUI gui;


     /**
      *
      * <P>Create a new GUI Key Listener.</P>
      *
      * @param Nes The current NES Machine.
      * @param Gui The current Graphical User Interface.
      *
      */

      public GUIKeyListener (NES nes, GUI gui) 
      {

         this.nes = nes;
         this.gui = gui;

      }



     /**
      *
      * <P>Handler for when a key is pressed in the GUI Window.</P>
      *
      * @param keyevent The KeyEvent.
      * 
      */

      public final void keyPressed(KeyEvent keyevent) 
      {



         // Get Keypress Integer

            int userPressed = keyevent.getKeyCode();

#ifdef DEBUG

            //System.out.println(userPressed);

#endif


         // Inform JoyPads of KeyPress

            nes.joyPad1.buttonDown(userPressed);
            nes.joyPad2.buttonDown(userPressed);


#ifdef STAND

         // KEYPRESS 0-9 : Change FrameSkip

            if ((userPressed >= 49) && (userPressed <= 56)) 
            {
               gui.tvController.setFrameSkip( userPressed - 49 );
               gui.writeToScreen("Frame Skip = " + (userPressed - 49));
               return;
            }

#endif



#ifdef PUNCHOUT
#ifdef APPLET

            if (nes.applet != null && nes.applet.PunchoutCheatsEnabled)
            {
            
#endif

               if (userPressed == 112) // F1
               {
                  
                  // Set Star Increase Flag
                  
                     nes.memory.memory[0x0341] = 3;
                     gui.writeToScreen("Punch-out Cheat: 3 Stars Added!");
                     return;
                     
               }


               if (userPressed == 113) // F2
               {

                  // Set Hearts
                  
                     nes.memory.memory[0x0321] = 9;
                     nes.memory.memory[0x0322] = 9;
                     gui.writeToScreen("Punch-out Cheat: 99 Hearts Added!");
                     return;
                  
               }
               
               if (userPressed == 114) // F3
               {
                  
                  // Set New Energy for Opponent Flag
                  
                     if (nes.memory.memory[0x039A]>5)
                        nes.memory.memory[0x0398] = 5;
                     
                     gui.writeToScreen("Punch-out Cheat: Opponents Energy Lowered!");
                     return;
                     
               }


               if (userPressed == 115) // F4
               {
                  
                  // Give me more health
                  
                     nes.memory.memory[0x0391] = 0x60;
                     
                     gui.writeToScreen("Punch-out Cheat: Mac to Maximum Health!");
                     return;
                                          
               } 


               if (userPressed == 116) // F5
               {
                  
                  // Give me 1000 Points
                  
                     nes.memory.memory[0x03E3] = 1;
                     nes.memory.memory[0x03E0] = 0x80;
                     
                     gui.writeToScreen("Punch-out Cheat: You got 1000 points!");
                     return;
                     
               } 


               if (userPressed == 117) // F6
               {
                  
                  // Start the Round Counter Again
                  
                     nes.memory.memory[0x302] = 0;
                     nes.memory.memory[0x304] = 0;
                     nes.memory.memory[0x305] = 0;

                     gui.writeToScreen("Punch-out Cheat: Round Time has been Reset!");
                     return;
                     
               }
              
#ifdef APPLET

            } // endif for Punchout Cheats
            
#endif
#endif
            
            
            

   
#ifdef DEBUG


         // Dump Memory to Disk
         
            if (userPressed == 'M')
            {

               if (!nes.regdebug)
               {
                  
                  nes.memory.debugOpen();
                  nes.memory.debugDump();
                  nes.memory.debugClose();
                  
                  gui.writeToScreen("Dumped Memory to Disk");
                  return;
                  
               }
            
            }            
            
            
         // Enable Debugging for Developer
         
            if (userPressed == 'E')
            {
               nes.regdebug = !nes.regdebug;
               gui.writeToScreen("Registry Debug : " + nes.regdebug);
               
               if (nes.regdebug)
               {
                  nes.memory.debugOpen();
                  
               }
               else
               {
                  nes.memory.debugClose();
               }
               
               return;
               
            }



         // Provide Scanning of Memory
         
            if (userPressed == 'W')
            {

               try
               {

                  // Inform User
                     
                     System.out.println("Please enter value:");
                     LineNumberReader lnr = new LineNumberReader(new InputStreamReader(System.in));
   
   
                  // Grab Input
                  
                     int a = Integer.parseInt(lnr.readLine());               
                     System.out.println("finding " + a);


                  // Search Memory
                                 
                     for (int i = 0; i< nes.memory.memory.length; i++)
                     {
                        if (nes.memory.memory[i]==a)
                           System.out.println(DavOS.hex(i,4));
                     }
   
   
               }
               catch (Exception e) {}

               return;
               
            }


#endif

#ifdef DECOMPILER

            if (userPressed == 'D')
            {
               
               nes.memory.setExecuteCodeMonitor(!nes.memory.getExecuteCodeMonitor());
               
               if (nes.memory.getExecuteCodeMonitor())
               {
                  gui.writeToTopBar("Monitoring Executable Code from " + DavOS.hex(nes.cpu.getPC(),4));
                  nes.memory.clearExecutableCode();
               }
               else
               {
                  gui.writeToTopBar("");
                  nes.memory.dumpExecutableCode();
               }
             
               return;
                 
            }

#endif


         // KEYPRESS B : Black and White Toggle

            if (userPressed == 'B') 
            {

                gui.tvController.toggleBlackWhite();
                return;

            }


         // Adjust the Tint

            if (userPressed == '-') 
            {

                gui.tvController.decTint();
                return;

            }


            if (userPressed == '=') 
            {

                gui.tvController.incTint();
                return;

            }


         // Adjust the Hue

            if (userPressed == 57) 
            {

                gui.tvController.decHue();
                return;

            }


            if (userPressed == 48) 
            {

                gui.tvController.incHue();
                return;

            }


#ifdef STAND


         // KEYPRESS C : Commit Point

            if (userPressed == 67) 
            {

                  gui.saveStateRequest = true;
                  gui.loadStateRequest = false;
                  gui.writeToScreen("Attempting to Save State...");
                  return;

            }




         // Debug Enter or Exit

            if (userPressed == 116)
            {

               // Toggle State

                  nes.cpu.debugEnterToggle();


               // Toggle Menu

                  gui.cpuMenu7.setState(!gui.cpuMenu7.getState());
                  return;
               

            }


         // Debug Step

            if (userPressed == 117)
            {

               nes.cpu.debugStep(1);
               return;
               
            }


         // Debug Step x 20

            if (userPressed == 118)
            {

               nes.cpu.debugStep(20);
               return;
               
            }



         // Debug to Interrupt

            if (userPressed == 119)
            {

               nes.cpu.debugToInterrupt(true);
               return;
               
            }
            
#endif


         // KEYPRESS P : Pause the Current Cart

            if (userPressed == 80 && nes.isCartRunning()) 
            {

               boolean newState = !nes.cpu.getCPUPause();
               
               if (newState)
                  gui.writeToScreen("Pausing game...");
               else
                  gui.writeToScreen("Resuming game...");
                  
   
               nes.cpu.setCPUPause(newState);

#ifdef STAND

               if (gui.cpuMenu2 != null)
               {
                  gui.tvController.imageCounter = gui.tvController.imageLatchCounter;
                  gui.cpuMenu2.setState(nes.cpu.getCPUPause()); 
               }
               
#endif

               return;

            }


#ifdef FUTURE
#ifdef PUNCHOUT

         // KEYPRESS Y : Post Screen to Punch Out Server

            if (userPressed == 'Y' && nes.isCartRunning())
            {
               gui.tvController.punchoutPostScreen();
               return;
            }         
#endif
#endif


#ifndef PUNCHOUT

         // KEYPRESS R : Reset the Current Cart

            if (userPressed == 82 && nes.isCartRunning()) 
            {

               nes.reset();

               if (nes.cpu.getCPUPause())
               {
                  nes.cpu.setCPUPause(false);

#ifdef STAND

                  if (gui.cpuMenu2 != null) 
                  {
                     gui.cpuMenu2.setState(false); 
                  }
                  
#endif


               }


               return;

            }

#endif


         // KEYPRESS L : Rollback to Commit Point

#ifdef PUNCHOUT

            if (userPressed == 'R')
            
#else


            if (userPressed == 'L') 
            
#endif

            {

                  gui.saveStateRequest = false;
                  gui.loadStateRequest = true;
                  
#ifndef PUNCHOUT

                  gui.writeToScreen("Attempting to Load State...");

#endif


                  return;

            }



#ifdef SOUND


         // KEYPRESS S : Toggle Sound Off/On

            if (userPressed == 83) 
            {

               // Check Sound is Available

                  if (nes.sound == null) return; 



#ifdef STAND

               // Toggle Sound Manually

                  gui.soundMenu1.setState(!gui.soundMenu1.getState());

      
               // Change Cursor
 
                  gui.setCursor(new Cursor(Cursor.WAIT_CURSOR)); 

#endif

      
      
           
               // Determine the Toggled State of Sound

                  boolean soundState = nes.sound.enableAllSound;
                  
                  if (soundState) 
                  {

                     gui.writeToScreen("Sound has been disabled..."); 
  
                  } 
                  else 
                  {

                     gui.writeToScreen("Sound has been enabled..."); 
                     
                  }


#ifdef STAND

               // Configure the Menus

                  if (nes.isCartRunning()) 
                  {
                     gui.soundMenu2.setEnabled(!soundState); 
                  }

                  gui.soundMenu3.setEnabled(!soundState); 
                  gui.soundMenu4.setEnabled(!soundState); 
                  gui.soundMenu5.setEnabled(!soundState); 
                  gui.soundMenu6.setEnabled(!soundState); 
                  gui.soundMenu7.setEnabled(!soundState); 
                   
#endif

               // Set Sound State

                  nes.sound.enableSound(!soundState);                   
                  gui.setCursor(new Cursor(Cursor.DEFAULT_CURSOR)); 
                  return;

            }


#endif


      }



     /**
      *
      * <P>Handler for when a key is released in the GUI Window.</P>
      *
      * @param keyevent The KeyEvent.
      * 
      */

      public final void keyReleased(KeyEvent keyevent) 
      {

         // Inform the JoyPad

            nes.joyPad1.buttonUp(keyevent.getKeyCode());
            nes.joyPad2.buttonUp(keyevent.getKeyCode());

      }


     /**
      *
      * <P>Handler for when a key is typed in the GUI Window.</P>
      *
      * @param keyevent The KeyEvent.
      * 
      */

      public final void keyTyped(KeyEvent keyevent) 
      {
      }


}

#endif
