#ifdef STAND

/** 
 *
 * Class for Decompiler NESCafe NES Emulator.
 *
 * @author   David de Niese
 * @version  0.56f
 * @final    TRUE
 *
 */
 
public class Decompiler
{
   
   int[] memory = null;
   
   public Decompiler(int[] memory)
   {
      this.memory = memory;
   }
   
   
   
   final int MODE_NON    = 0x00;
   final int MODE_IMD    = 0x01;
   final int MODE_ZP     = 0x02;
   final int MODE_ZPX    = 0x03;
   final int MODE_ZPY    = 0x04;
   final int MODE_ABS    = 0x05;
   final int MODE_ABSX   = 0x06;
   final int MODE_ABSY   = 0x07;
   final int MODE_INDX   = 0x08;
   final int MODE_INDY   = 0x09;
   final int MODE_BRANCH = 0x0A;
   final int MODE_INDABS = 0x0B;
   
   
   
   public String decompile(int offset)
   {

      if (memory == null || offset > memory.length)
      {
         return "";
      }
      
      int opcode = memory[offset];
      
      DebugInstruction curInstruction = instructions[opcode];

      int operand = 0;
      
         
         if (curInstruction.code==null || curInstruction.code=="")
         {
            
            return "";
            
         }
         
         
         switch (curInstruction.numOperands)
         {
         case MODE_NON:
            return curInstruction.code;
            
         case MODE_IMD:
            operand = memory[offset+1];
            return curInstruction.code + " #" + DavOS.hex(operand,2);
            
         case MODE_ZP:
            operand = memory[offset+1];
            return curInstruction.code + " $" + DavOS.hex(operand,2);
            
         case MODE_ZPX:
            operand = memory[offset+1];
            return curInstruction.code + " $" + DavOS.hex(operand,2) + ",X";
            
         case MODE_ZPY:
            operand = memory[offset+1];
            return curInstruction.code + " $" + DavOS.hex(operand,2) + ",Y";
            
         case MODE_INDABS:
            operand = memory[offset+1] | (memory[offset+2] << 8);
            return curInstruction.code + " ($" + DavOS.hex(operand,4) +")";
         
         case MODE_ABS:
            operand = memory[offset+1] | (memory[offset+2] << 8);
            return curInstruction.code + " $" + DavOS.hex(operand,4);
            
         case MODE_ABSX:
            operand = memory[offset+1] | (memory[offset+2] << 8);
            return curInstruction.code + " $" + DavOS.hex(operand,4) + ",X";
            
         case MODE_ABSY:
            operand = memory[offset+1] | (memory[offset+2] << 8);
            return curInstruction.code + " $" + DavOS.hex(operand,4) + ",Y";
            
         case MODE_INDX:
            operand = memory[offset+1];
            return curInstruction.code + " ($" + DavOS.hex(operand,2) + ",X)";
            
         case MODE_INDY:
            operand = memory[offset+1];
            return curInstruction.code + " ($" + DavOS.hex(operand,2) + "),Y";
            
         case MODE_BRANCH:
            operand = (byte)memory[offset+1];
            operand += 2;
            operand += offset;
            
            
            return curInstruction.code + " $" + DavOS.hex(operand,4);
                     
         }   
         
         
         return "";
            
  
   
   }
   
   DebugInstruction[] instructions =
   {
      new DebugInstruction(0x00, "BRK", MODE_NON),
      new DebugInstruction(0x01, "ORA", MODE_INDX),
      new DebugInstruction(0x02, "", 0),
      new DebugInstruction(0x03, "", 0),
      new DebugInstruction(0x04, "", 0),
      new DebugInstruction(0x05, "ORA", MODE_ZP),
      new DebugInstruction(0x06, "ASL", MODE_ZP),
      new DebugInstruction(0x07, "", 0),
      new DebugInstruction(0x08, "PHP", MODE_NON),
      new DebugInstruction(0x09, "ORA", MODE_IMD),
      new DebugInstruction(0x0A, "ASL", MODE_NON),
      new DebugInstruction(0x0B, "", 0),
      new DebugInstruction(0x0C, "", 0),
      new DebugInstruction(0x0D, "ORA", MODE_ABS),
      new DebugInstruction(0x0E, "ASL", MODE_ABS),
      new DebugInstruction(0x0F, "", 0),
      
      new DebugInstruction(0x10, "BPL", MODE_BRANCH),
      new DebugInstruction(0x11, "ORA", MODE_INDY),
      new DebugInstruction(0x12, "", 0),
      new DebugInstruction(0x13, "", 0),
      new DebugInstruction(0x14, "", 0),
      new DebugInstruction(0x15, "ORA", MODE_ZPX),
      new DebugInstruction(0x16, "ASL", MODE_ZPX),
      new DebugInstruction(0x17, "", 0),
      new DebugInstruction(0x18, "CLC", MODE_NON),
      new DebugInstruction(0x19, "ORA", MODE_ABSY),
      new DebugInstruction(0x1A, "", 0),
      new DebugInstruction(0x1B, "", 0),
      new DebugInstruction(0x1C, "", 0),
      new DebugInstruction(0x1D, "ORA", MODE_ABSX),
      new DebugInstruction(0x1E, "ASL", MODE_ABSX),
      new DebugInstruction(0x1F, "", 0),

      new DebugInstruction(0x20, "JSR", MODE_ABS),
      new DebugInstruction(0x21, "AND", MODE_INDX),
      new DebugInstruction(0x22, "", 0),
      new DebugInstruction(0x23, "", 0),
      new DebugInstruction(0x24, "BIT", MODE_ZP),
      new DebugInstruction(0x25, "AND", MODE_ZP),
      new DebugInstruction(0x26, "ROL", MODE_ZP),
      new DebugInstruction(0x27, "", 0),
      new DebugInstruction(0x28, "PLP", MODE_NON),
      new DebugInstruction(0x29, "AND", MODE_IMD),
      new DebugInstruction(0x2A, "ROL A", MODE_NON),
      new DebugInstruction(0x2B, "", 0),
      new DebugInstruction(0x2C, "BIT", MODE_ABS),
      new DebugInstruction(0x2D, "AND", MODE_ABS),
      new DebugInstruction(0x2E, "ROL", MODE_ABS),
      new DebugInstruction(0x2F, "", 0), 

      new DebugInstruction(0x30, "BMI", MODE_BRANCH),
      new DebugInstruction(0x31, "AND", MODE_INDY),
      new DebugInstruction(0x32, "", 0),
      new DebugInstruction(0x33, "", 0),
      new DebugInstruction(0x34, "", 0),
      new DebugInstruction(0x35, "AND", MODE_ZPX),
      new DebugInstruction(0x36, "ROL", MODE_ZPX),
      new DebugInstruction(0x37, "", 0),
      new DebugInstruction(0x38, "SEC", MODE_NON),
      new DebugInstruction(0x39, "AND", MODE_ABSY),
      new DebugInstruction(0x3A, "", 0),
      new DebugInstruction(0x3B, "", 0),
      new DebugInstruction(0x3C, "", 0),
      new DebugInstruction(0x3D, "AND", MODE_ABSX),
      new DebugInstruction(0x3E, "ROL", MODE_ABSX),
      new DebugInstruction(0x3F, "", 0),
      
      new DebugInstruction(0x40, "RTI", MODE_NON),
      new DebugInstruction(0x41, "EOR", MODE_INDX),
      new DebugInstruction(0x42, "", 0),
      new DebugInstruction(0x43, "", 0),
      new DebugInstruction(0x44, "", 0),
      new DebugInstruction(0x45, "EOR", MODE_ZP),
      new DebugInstruction(0x46, "LSR", MODE_ZP),
      new DebugInstruction(0x47, "", 0),
      new DebugInstruction(0x48, "PHA", MODE_NON),
      new DebugInstruction(0x49, "EOR", MODE_IMD),
      new DebugInstruction(0x4A, "LSR", MODE_NON),
      new DebugInstruction(0x4B, "", 0),
      new DebugInstruction(0x4C, "JMP", MODE_ABS),
      new DebugInstruction(0x4D, "EOR", MODE_ABS),
      new DebugInstruction(0x4E, "LSR", MODE_ABS),
      new DebugInstruction(0x4F, "", 0),

      new DebugInstruction(0x50, "BVC", MODE_BRANCH),
      new DebugInstruction(0x51, "EOR", MODE_INDY),
      new DebugInstruction(0x52, "", 0),
      new DebugInstruction(0x53, "", 0),
      new DebugInstruction(0x54, "", 0),
      new DebugInstruction(0x55, "EOR", MODE_ZPX),
      new DebugInstruction(0x56, "LSR", MODE_ZPX),
      new DebugInstruction(0x57, "", 0),
      new DebugInstruction(0x58, "CLI", MODE_NON),
      new DebugInstruction(0x59, "EOR", MODE_ABSY),
      new DebugInstruction(0x5A, "", 0),
      new DebugInstruction(0x5B, "", 0),
      new DebugInstruction(0x5C, "", 0),
      new DebugInstruction(0x5D, "EOR", MODE_ABSX),
      new DebugInstruction(0x5E, "LSR", MODE_ABSX),
      new DebugInstruction(0x5F, "", 0),

      new DebugInstruction(0x60, "RTS", MODE_NON),
      new DebugInstruction(0x61, "ADC", MODE_INDX),
      new DebugInstruction(0x62, "", 0),
      new DebugInstruction(0x63, "", 0),
      new DebugInstruction(0x64, "", 0),
      new DebugInstruction(0x65, "ADC", MODE_ZP),
      new DebugInstruction(0x66, "ROR", MODE_ZP),
      new DebugInstruction(0x67, "", 0),
      new DebugInstruction(0x68, "PLA", MODE_NON),
      new DebugInstruction(0x69, "ADC", MODE_IMD),
      new DebugInstruction(0x6A, "ROR A", MODE_NON),
      new DebugInstruction(0x6B, "", 0),
      new DebugInstruction(0x6C, "JMP", MODE_INDABS),
      new DebugInstruction(0x6D, "ADC", MODE_ABS),
      new DebugInstruction(0x6E, "ROR", MODE_ABS),
      new DebugInstruction(0x6F, "", 0),

      new DebugInstruction(0x70, "BVS", MODE_BRANCH),
      new DebugInstruction(0x71, "ADC", MODE_INDY),
      new DebugInstruction(0x72, "", 0),
      new DebugInstruction(0x73, "", 0),
      new DebugInstruction(0x74, "", 0),
      new DebugInstruction(0x75, "ADC", MODE_ZPX),
      new DebugInstruction(0x76, "ROR", MODE_ZPX),
      new DebugInstruction(0x77, "", 0),
      new DebugInstruction(0x78, "SEI", MODE_NON),
      new DebugInstruction(0x79, "ADC", MODE_ABSY),
      new DebugInstruction(0x7A, "", 0),
      new DebugInstruction(0x7B, "", 0),
      new DebugInstruction(0x7C, "", 0),
      new DebugInstruction(0x7D, "ADC", MODE_ABSX),
      new DebugInstruction(0x7E, "ROR", MODE_ABSX),
      new DebugInstruction(0x7F, "", 0), 

      new DebugInstruction(0x80, "", 0),
      new DebugInstruction(0x81, "STA", MODE_INDX),
      new DebugInstruction(0x82, "", 0),
      new DebugInstruction(0x83, "", 0),
      new DebugInstruction(0x84, "STY", MODE_ZP),
      new DebugInstruction(0x85, "STA", MODE_ZP),
      new DebugInstruction(0x86, "STX", MODE_ZP),
      new DebugInstruction(0x87, "", 0),
      new DebugInstruction(0x88, "DEY", MODE_NON),
      new DebugInstruction(0x89, "", 0),
      new DebugInstruction(0x8A, "TXA", MODE_NON),
      new DebugInstruction(0x8B, "", 0),
      new DebugInstruction(0x8C, "STY", MODE_ABS),
      new DebugInstruction(0x8D, "STA", MODE_ABS),
      new DebugInstruction(0x8E, "STX", MODE_ABS),
      new DebugInstruction(0x8F, "", 0),

      new DebugInstruction(0x90, "BCC", MODE_BRANCH),
      new DebugInstruction(0x91, "STA", MODE_INDY),
      new DebugInstruction(0x92, "", 0),
      new DebugInstruction(0x93, "", 0),
      new DebugInstruction(0x94, "STY", MODE_ZPX),
      new DebugInstruction(0x95, "STA", MODE_ZPX),
      new DebugInstruction(0x96, "STX", MODE_ZPY),
      new DebugInstruction(0x97, "", 0),
      new DebugInstruction(0x98, "TYA", MODE_NON),
      new DebugInstruction(0x99, "STA", MODE_ABSY),
      new DebugInstruction(0x9A, "TXS", MODE_NON),
      new DebugInstruction(0x9B, "", 0),
      new DebugInstruction(0x9C, "", 0),
      new DebugInstruction(0x9D, "STA", MODE_ABSX),
      new DebugInstruction(0x9E, "", 0),
      new DebugInstruction(0x9F, "", 0),

      new DebugInstruction(0xA0, "LDY", MODE_IMD),
      new DebugInstruction(0xA1, "LDA", MODE_INDX),
      new DebugInstruction(0xA2, "LDX", MODE_IMD),
      new DebugInstruction(0xA3, "", 0),
      new DebugInstruction(0xA4, "LDY", MODE_ZP),
      new DebugInstruction(0xA5, "LDA", MODE_ZP),
      new DebugInstruction(0xA6, "LDX", MODE_ZP),
      new DebugInstruction(0xA7, "", 0),
      new DebugInstruction(0xA8, "TAY", MODE_NON),
      new DebugInstruction(0xA9, "LDA", MODE_IMD),
      new DebugInstruction(0xAA, "TAX", MODE_NON),
      new DebugInstruction(0xAB, "", 0),
      new DebugInstruction(0xAC, "LDY", MODE_ABS),
      new DebugInstruction(0xAD, "LDA", MODE_ABS),
      new DebugInstruction(0xAE, "LDX", MODE_ABS),
      new DebugInstruction(0xAF, "", 0),

      new DebugInstruction(0xB0, "BCS", MODE_BRANCH),
      new DebugInstruction(0xB1, "LDA", MODE_INDX),
      new DebugInstruction(0xB2, "", 0),
      new DebugInstruction(0xB3, "", 0),
      new DebugInstruction(0xB4, "LDY", MODE_ZPX),
      new DebugInstruction(0xB5, "LDA", MODE_ZPX),
      new DebugInstruction(0xB6, "LDX", MODE_ZPY),
      new DebugInstruction(0xB7, "", 0),
      new DebugInstruction(0xB8, "CLV", MODE_NON),
      new DebugInstruction(0xB9, "LDA", MODE_ABSY),
      new DebugInstruction(0xBA, "TSX", MODE_NON),
      new DebugInstruction(0xBB, "", 0),
      new DebugInstruction(0xBC, "LDY", MODE_ABSX),
      new DebugInstruction(0xBD, "LDA", MODE_ABSX),
      new DebugInstruction(0xBE, "LDX", MODE_ABSY),
      new DebugInstruction(0xBF, "", 0) ,

      new DebugInstruction(0xC0, "CPY", MODE_IMD),
      new DebugInstruction(0xC1, "CMP", MODE_INDX),
      new DebugInstruction(0xC2, "", 0),
      new DebugInstruction(0xC3, "", 0),
      new DebugInstruction(0xC4, "CPY", MODE_ZP),
      new DebugInstruction(0xC5, "CMP", MODE_ZP),
      new DebugInstruction(0xC6, "DEC", MODE_ZP),
      new DebugInstruction(0xC7, "", 0),
      new DebugInstruction(0xC8, "INY", MODE_NON),
      new DebugInstruction(0xC9, "CMP", MODE_IMD),
      new DebugInstruction(0xCA, "DEX", MODE_NON),
      new DebugInstruction(0xCB, "", 0),
      new DebugInstruction(0xCC, "CPY", MODE_ABS),
      new DebugInstruction(0xCD, "CMP", MODE_ABS),
      new DebugInstruction(0xCE, "DEC", MODE_ABS),
      new DebugInstruction(0xCF, "", 0) ,

      new DebugInstruction(0xD0, "BNE", MODE_BRANCH),
      new DebugInstruction(0xD1, "CMP", MODE_INDY),
      new DebugInstruction(0xD2, "", 0),
      new DebugInstruction(0xD3, "", 0),
      new DebugInstruction(0xD4, "", 0),
      new DebugInstruction(0xD5, "CMP", MODE_ZPX),
      new DebugInstruction(0xD6, "DEC", MODE_ZPX),
      new DebugInstruction(0xD7, "", 0),
      new DebugInstruction(0xD8, "CLD", MODE_NON),
      new DebugInstruction(0xD9, "CMP", MODE_ABSY),
      new DebugInstruction(0xDA, "", 0),
      new DebugInstruction(0xDB, "", 0),
      new DebugInstruction(0xDC, "", 0),
      new DebugInstruction(0xDD, "CMP", MODE_ABSX),
      new DebugInstruction(0xDE, "DEC", MODE_ABSX),
      new DebugInstruction(0xDF, "", 0) ,

      new DebugInstruction(0xE0, "CPX", MODE_IMD),
      new DebugInstruction(0xE1, "SBC", MODE_INDX),
      new DebugInstruction(0xE2, "", 0),
      new DebugInstruction(0xE3, "", 0),
      new DebugInstruction(0xE4, "CPX", MODE_ZP),
      new DebugInstruction(0xE5, "SBC", MODE_ZP),
      new DebugInstruction(0xE6, "INC", MODE_ZP),
      new DebugInstruction(0xE7, "", 0),
      new DebugInstruction(0xE8, "INX", MODE_NON),
      new DebugInstruction(0xE9, "SBC", MODE_IMD),
      new DebugInstruction(0xEA, "", 0),
      new DebugInstruction(0xEB, "SBC", MODE_IMD),
      new DebugInstruction(0xEC, "CPX", MODE_ABS),
      new DebugInstruction(0xED, "SBC", MODE_ABS),
      new DebugInstruction(0xEE, "INC", MODE_ABS),
      new DebugInstruction(0xEF, "", 0) ,

      new DebugInstruction(0xF0, "BEQ", MODE_BRANCH),
      new DebugInstruction(0xF1, "SBC", MODE_INDY),
      new DebugInstruction(0xF2, "", 0),
      new DebugInstruction(0xF3, "", 0),
      new DebugInstruction(0xF4, "", 0),
      new DebugInstruction(0xF5, "SBC", MODE_ZPX),
      new DebugInstruction(0xF6, "INC", MODE_ZPX),
      new DebugInstruction(0xF7, "", 0),
      new DebugInstruction(0xF8, "SED", MODE_NON),
      new DebugInstruction(0xF9, "SBC", MODE_ABSY),
      new DebugInstruction(0xFA, "", 0),
      new DebugInstruction(0xFB, "", 0),
      new DebugInstruction(0xFC, "", 0),
      new DebugInstruction(0xFD, "SBC", MODE_ABSX),
      new DebugInstruction(0xFE, "INC", MODE_ABSX),
      new DebugInstruction(0xFF, "", 0)


   };
   
}

class DebugInstruction
{
   protected int opcode = 0;
   protected String code = "";
   protected int numOperands = 0;
   
   
   public DebugInstruction(int opcode, String code, int numOperands)
   {
      this.opcode = opcode;
      this.code = code;
      this.numOperands = numOperands;
      
   }
}

#endif
