#ifdef STAND


// Declare Imports

   import java.awt.event.*;


/** 
*
* Class for the Chat Window Adaptor required by the ChatWindow.
*
* @author   David de Niese
* @version  0.56f
* @final    TRUE
*
*/


final class ChatWindowAdapter implements WindowListener 
{


     /**
      *
      * <P>The current NES Machine.</P>
      *
      */

      private NES nes;


     /**
      *
      * <P>The current Graphical User Interface.</P>
      *
      */

      private GUI gui;


     /**
      *
      * <P>Create a new Chat Window Adapter.</P>
      * 
      */

      public ChatWindowAdapter(NES nes,GUI gui) 
      {

         this.nes = nes;
         this.gui = gui;

      }


     /**
      *
      * <P>Handler for closing the Chat Window.</P>
      * 
      * @param windowEvent The Window Event.
      * 
      */

      public final void windowClosing(WindowEvent windowEvent) 
      {



         // Completely Destroy the Chat Window

            gui.serverConnection.chatWindow.dispose();
            gui.serverConnection.chatWindow = null;

      }


     /**
      *
      * <P>Handler for activating the Chat Window.</P>
      * 
      * @param windowEvent The Window Event.
      * 
      */

      public final void windowActivated(WindowEvent windowEvent) 
      { 

         // Allow the Chat Window to be open at the Same Time as main Window

            gui.pauseSystem(false);

      }


     /**
      *
      * <P>Handler for deactivating the Chat Window.</P>
      * 
      * @param windowEvent The Window Event.
      * 
      */

      public final void windowDeactivated (WindowEvent windowEvent) 
      {

         gui.pauseSystem(true); 

      }


     /**
      *
      * <P>Handler for opening the Chat Window.</P>
      * 
      * @param windowEvent The Window Event.
      * 
      */


      public final void windowOpened (WindowEvent windowEvent) {}


     /**
      *
      * <P>Handler for closing the Chat Window.</P>
      * 
      * @param windowEvent The Window Event.
      * 
      */

      public final void windowClosed (WindowEvent windowEvent) {}


     /**
      *
      * <P>Handler for iconifing the Chat Window.</P>
      * 
      * @param windowEvent The Window Event.
      * 
      */

      public final void windowIconified (WindowEvent windowEvent) {}


     /**
      *
      * <P>Handler for deiconifing the Chat Window.</P>
      * 
      * @param windowEvent The Window Event.
      * 
      */

      public final void windowDeiconified (WindowEvent windowEvent) {}
    
  
}

#endif
