
/*
import java.util.*;
import java.io.*;
*/


/** 
 *
 * Class for User Configuration
 *
 * @author   David de Niese
 * @version  0.56f
 * @final    TRUE
 *
 */

public final class UserSettings 
{


    /**
     *
     * The NESCafe LAN CoffeePot Server
     *
     */

     public String coffeePotServer = "localhost";


    /**
     *
     * Which Controllers are Plugged In
     *
     */

     public boolean controllerZapperEnabled = false;



     /**
      *
      * Use Undocumented OpCodes
      *
      */

      public boolean useUndocumentedOpCodes = false;


     /**
      *
      * Use Proxy Server
      *
      */

      public boolean useProxyServer = false;


     /**
      *
      * Proxy Server
      *
      */

      public String proxyServer = "";


     /**
      *
      * Proxy Server Port
      *
      */

      public String proxyServerPort = "";


     /**
      *
      * Proxy Server Username
      *
      */

      public String proxyServerUsername = "";


     /**
      *
      * Proxy Server Password
      *
      */

      public String proxyServerPassword = "";



     /**
      *
      * Method to Load these Settings
      *
      */

      public void loadSettings()
      {

#ifdef STAND

         try 
         {

            java.util.Properties settings = new java.util.Properties();
            settings.load(new java.io.FileInputStream("nescafe.ini"));


            useProxyServer  = settings.getProperty("useproxy").equalsIgnoreCase("TRUE");
            proxyServer     = settings.getProperty("proxyserver");
            proxyServerPort = settings.getProperty("proxyserverport");
            proxyServerUsername = settings.getProperty("proxyserverusername");
            proxyServerPassword = settings.getProperty("proxyserverpassword");


         } 
         catch (Exception e)
         {

         }


#endif

      }

     /**
      *
      * Method to Save these Settings
      *
      */

      public void saveSettings()
      {

#ifdef STAND

         try 
         {

            java.util.Properties settings = new java.util.Properties();

            settings.setProperty("useproxy", (useProxyServer)? "true":"false");
            settings.setProperty("proxyserver", proxyServer);
            settings.setProperty("proxyserverport", proxyServerPort);
            settings.setProperty("proxyserverusername", proxyServerUsername);
            settings.setProperty("proxyserverpassword", proxyServerPassword);

            settings.store(new java.io.FileOutputStream("nescafe.ini"), "NESCafe Settings");


         } 
         catch (Exception e)
         {

         }


#endif

      }

}
