#ifdef SOUND


/** 
 *
 * Class for the Triangle Channel required by the Sound Interface.
 *
 * @author   David de Niese
 * @version  0.56f
 * @final    TRUE
 *
 * Most of the information on how the NES Sound works was provided
 * by Brad Taylor's NES Sound document and the C implementation of
 * Nester's APU Source by Matt Conte (matt@conte.com).
 *
 */



final class SoundChannelTriangle 
{


     /**
      *
      * <P>Whether the Channel is enabled.</P>
      *
      */

      public boolean enabled = false;


     /**
      *
      * <P>The current frequency of the channel.</P>
      *
      */

      public int freq = 0;


     /**
      *
      * <P>The length of the Linear Counter.</P>
      *
      */

      public int linearLength = 0; 


     /**
      *
      * <P>The current output Volume of the channel.</P>
      *
      */

      public int outputVol = 0;


     /**
      *
      * <P>The Control Registers for the Triangle Channel.</P>
      *
      */

      public int regs[] = new int[4];


     /**
      * 
      * <P>Adder to determine whether channel is in a positive or negative cycle.</P>
      *
      */

      public int adder = 0; 


     /**
      *
      * <P>Whether or not the current note is held.</P>
      * 
      */

      public boolean holdNote = false; 


     /**
      *
      * <P>Whether or not the Linear Counter has started (is not in Load Mode).</P>
      *
      */

      public boolean counterStarted = false; 



     /**
      *
      * <P>The Cycle Debt for this Sample to Catch Up
      *
      */

      public int phaseacc = 0x00; 


     /**
      *
      * <P>The number of cycles left before the counter is started.</P>
      *
      */

      public int writeLatency = 0; 


     /**
      *
      * <P>The number of Vertical Blanks until the Channel is silenced.</P>
      *
      */

      public int vblLength = 0; 



}
#endif
