
#ifdef SOUND

/** 
 *
 * Class for the Rectangle Channel required by the Sound Interface.
 *
 * @author   David de Niese
 * @version  0.56f
 * @final    TRUE
 *
 * Most of the information on how the NES Sound works was provided
 * by Brad Taylor's NES Sound document and the C implementation of
 * Nester's APU Source by Matt Conte (matt@conte.com).
 *
 */



final class SoundChannelRectangle 
{



     /**
      * 
      * <P>Adder to determine whether channel is in a positive or negative cycle.</P>
      *
      */

      public int adder = 0; 


     /**
      *
      * <P>Specifies when to Flip from Positive to Negitive (when Adder equals this value).</P>
      *
      */

      public int dutyFlip = 0; 


     /**
      *
      * <P>Whether the Channel is enabled.</P>
      *
      */

      public boolean enabled = false; 


     /**
      *
      * <P>The Envelope Decay Frequency.</P>
      *
      */

      public int envDecay = 0; 


     /**
      *
      * <P>The Cycle Debt for the Envelope Counter to Catch Up
      *
      */

      public int envPhase = 0; 


     /**
      *
      * <P>The Envelope Volume Level (0-15).</P>
      *
      */

      public int envVol = 0; 


     /**
      *
      * <P>Whether the Envelope Decays.</P>
      *
      */

      public boolean fixedEnvelope = false; 


     /**
      *
      * <P>The current frequency of the channel.</P>
      *
      */

      public int freq = 0; 


     /**
      *
      * <P>The limit of the Frequency after a Shift (taken from LUT).</P>
      *
      */

      public int freqLimit = 0; 


     /**
      *
      * <P>Whether or not the current note is held.</P>
      * 
      */

      public boolean holdNote = false; 



     /**
      *
      * <P>The Cycle Debt for this Sample to Catch Up
      *
      */

      public int phaseacc = 0x00; 


     /**
      *
      * <P>The Cycle Debt for the Sweep Unit to Catch Up
      *
      */

      public int sweepPhase = 0; 


     /**
      *
      * <P>The current output Volume of the channel.</P>
      *
      */

      public int outputVol = 0; 


     /**
      *
      * <P>The Control Registers for the Rectangle Channel.</P>
      *
      */

      public int regs[] = new int[4]; 


     /**
      *
      * <P>The Sweep Decay Refresh Rate.</P>
      *
      */

      public int sweepDecay = 0; 


     /**
      *
      * <P>Whether to Increment or Decrement the Wavelength when Sweeping.</P>
      *
      */

      public boolean sweepInc = false; 



     /**
      *
      * <P>Whether Sweeping is Enabled.</P>
      *
      */

      public boolean sweepOn = false; 


     /**
      *
      * <P>The Right Shift of the new Frequency.</P>
      *
      */

      public int sweepShifts = 0; 


     /**
      *
      * <P>The number of Vertical Blanks until the Channel is silenced.</P>
      *
      */

      public int vblLength = 0; 


     /**
      *
      * <P>The Channel Volume used by Fixed Envelopes.</P>
      *
      */

      public int volume = 0; 



}
#endif
