#ifdef SOUND


/** 
 *
 * Class for the White Noise Channel required by the Sound Interface.
 *
 * @author   David de Niese
 * @version  0.56f
 * @final    TRUE
 *
 * Most of the information on how the NES Sound works was provided
 * by Brad Taylor's NES Sound document and the C implementation of
 * Nester's APU Source by Matt Conte (matt@conte.com).
 *
 */



final class SoundChannelNoise {



     /**
      *
      * <P>The current position within the Randomly Sampled Data.</P>
      *
      */

      public int curPos=0;


     /**
      *
      * <P>Whether the Channel is enabled.</P>
      *
      */

      public boolean enabled = false;


     /**
      *
      * <P>The Envelope Decay Frequency.</P>
      *
      */

      public int envDecay = 0;


     /**
      *
      * <P>The Cycle Debt for the Envelope Counter to Catch Up
      *
      */

      public int envPhase = 0;


     /**
      *
      * <P>The Envelope Volume Level (0-15).</P>
      *
      */

      public int envVol = 0;


     /**
      *
      * <P>Whether the Envelope Decays.</P>
      *
      */

      public boolean fixedEnvelope = false;


     /**
      *
      * <P>The current frequency of the channel.</P>
      *
      */

      public int freq = 0;


     /**
      *
      * <P>Whether or not the current note is held.</P>
      * 
      */

      public boolean holdNote = false;


     /**
      *
      * <P>The current output Volume of the channel.</P>
      *
      */

      public int outputVol = 0;


     /**
      *
      * <P>The Cycle Debt for this Sample to Catch Up
      *
      */

      public int phaseAcc = 0x00;


     /**
      *
      * <P>The Control Registers for the Rectangle Channel.</P>
      *
      */

      public int regs[] = new int[4];


     /**
      *
      * <P>Whether the Random Generator is Creating Short or Long Samples.</P>
      *
      */

      public boolean shortSample = false;


     /**
      *
      * <P>The number of Vertical Blanks until the Channel is silenced.</P>
      *
      */

      public int vblLength = 0;


     /**
      *
      * <P>The Channel Volume used by Fixed Envelopes.</P>
      *
      */

      public int volume = 0;


}
#endif
