#ifdef STAND


// Declare Imports

   import java.awt.*;
   import java.awt.event.*;
   import java.net.*;
   import java.io.*;



/** 
*
* Class for the Download Roms Frame used by the NESCafe.
*
* @author   David de Niese
* @version  0.56f
* @final    TRUE
*
*/

public final class NetRomsFrame extends Frame implements Runnable 
{



     /**
      *
      * <P>The List of descriptions for the ROM Files from the Server.</P>
      *
      */

      public List visibleList = new List();


     /**
      *
      * <P>The hidden List of URL Locations for the ROM Files from the Server.</P>
      *
      */

      public List hiddenList  = new List();


     /**
      *
      * <P>The current NES Engine.</P>
      *
      */

      private NES nes;


     /**
      *
      * <P>The current Graphical User Interface.</P>
      *
      */

      private GUI gui;



     /**
      *
      * <P>The OK Button.</P>
      *
      */

      Button butOk = null;


     /**
      *
      * <P>Create a NetRomsFrame Object.</P>
      *
      */

      public NetRomsFrame (NES Nes, GUI Gui) throws Exception 
      {


         // Grab References to NES and GUI

            nes = Nes;
            gui = Gui;


  
         // Create the Window Listener

            NetRomsFrameAdapter winAdapter = new NetRomsFrameAdapter(nes,gui);
            addWindowListener(winAdapter);


         // Set Border Layout

            setLayout(new BorderLayout());


         // Set up the Frame

            setResizable(true);
            setTitle("NESCafe - ROM Downloader");
            setBackground(Color.lightGray);



         // Configure the Visible List and Add it to the Display

            visibleList.setBackground(Color.white); 
            visibleList.setForeground(Color.black);	 
            add (visibleList, BorderLayout.CENTER); 


         // Create a Frame Listener

            NetRomsFrameListener listener = new NetRomsFrameListener(nes,gui,this); 


         // Make the Buttons

            butOk = new Button ("Download");
            butOk.setActionCommand("DOWNLOAD");
            butOk.addActionListener(listener); 
	         butOk.setForeground(Color.black); 
            butOk.setEnabled(false);

            Button butCancel = new Button ("Close");
            butCancel.setActionCommand("CLOSE");
            butCancel.addActionListener(listener); 
            butCancel.setForeground(Color.black); 



         // Create the Bottom Panel for the Buttons and Add them

            Panel botPanel1 = new Panel();
            botPanel1.add(butOk); 
            botPanel1.add(butCancel); 


         // Add that Panel to the Display

            Panel botPanel2 = new Panel();
            botPanel2.setLayout(new BorderLayout());
            botPanel2.add (botPanel1, BorderLayout.EAST); 


         // Show Warning

            Label warning = new Label("Do not download ROMs that you aren't legally entitled to.");
            Font font = new Font("Helvetica", Font.BOLD, 10);

            warning.setForeground(Color.black);
            warning.setFont(font);
            botPanel2.add(warning, BorderLayout.WEST);

            botPanel2.setBackground(Color.lightGray);
            add (botPanel2, BorderLayout.SOUTH); 


         // Return Screen Size

            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

            final int w = 500; 
            final int h = 200; 

     
         // Position the Frame at the Center of the Screen

            setLocation(screenSize.width/2 - w/2, screenSize.height/2 - h/2); 
 

         // Show the Frame and Quickly Resize it

            setSize(w,h); 


      }



      public final void run() 
      {


         // Show Waiting Message

            visibleList.add("Please wait while NESCafe website is contacted...");


         // Try to Download ROMs List

            try 
            {


               // Download the Roms List

                  URLReader reader = new URLReader(gui);
                  String downloadFile = ServerConnection.NESRomDirectory + ServerConnection.NESRomList;

                  if (!reader.download(new URL("http", ServerConnection.NESRomServer, downloadFile))) 
                  {

                     visibleList.removeAll();

                     switch(reader.getLastErrorNumber())
                     {

                     case URLReader.ERROR_NES_ROMLIST_UNAVAILABLE:
                       {
                          visibleList.add("The Online NESCafe Game List is currently unavailable.");
                          break;

                       }

                     case URLReader.ERROR_CONTENT_NOT_READABLE:
                       {
                          visibleList.add("The Online NESCafe Game List was not readable.");
                          break;

                       }

                     case URLReader.ERROR_MANUALLY_CANCELLED:
                       {
                          visibleList.add("Fetching of Online NESCafe Game List was manually cancelled.");
                          break;

                       }

                     default:
                       {
                          visibleList.add(reader.getLastErrorString());
                       }
                 
                     }

                     return;

                  }



               // Grab the Rom file List if Successful

                  String romList = reader.getContent();
            


               // Declare Variables

                  String gameName = "";
                  String gameFileName = "";



               // Fill the Lists

                  visibleList.removeAll();

                  while ((romList.indexOf("\n")) > -1) {


                     // Grab the Next Line

                        String tempAddition = romList.substring(0,romList.indexOf("\n"));


                     // Check Line has a Seperator

                        if (tempAddition.indexOf(";") > -1) {


                           // Add the Description of the ROM to the Visible List
 
                              gameName = tempAddition.substring(tempAddition.indexOf(";") + 1);
                              gameName = gameName.replace('\n',' ');
                              gameName = gameName.replace('\r',' ');
                              visibleList.add(gameName.trim()); 
 

                           // Add the URL of the ROM to the Hidden List

                              gameFileName = tempAddition.substring(0,tempAddition.indexOf(";"));
                              gameFileName = gameFileName.replace('\n',' ');
                              gameFileName = gameFileName.replace('\r',' ');
                              hiddenList.add(gameFileName.trim());


                        }


                     // Prepare for Next Line

                        romList = romList.substring(romList.indexOf("\n") + 1); 

                  }



               // Enable Button

                  butOk.setEnabled(visibleList.getItemCount()>0);



            }
            catch (Exception e)
            { }



      }

}


#endif
