#ifdef STAND

// Declare Imports

   import java.net.*;
   import java.io.*;
   import java.awt.*;



/** 
*
* Class for the downloading of remote ROM Images used by NESCafe.
*
* @author   David de Niese
* @version  0.56f
* @final    TRUE
*
*/

public final class NetRomsDownloader extends Thread 
{



     /**
      *
      * <P>The current Graphical User Interface.</P>
      *
      */

      private GUI gui;


     /**
      *
      * <P>The current NES Engine.</P>
      *
      */

      private NES nes;


     /**
      * 
      * <P>The remote Filename of the ROM.</P>
      *
      */

      private String filename;


     /**
      *
      * <P>The description of the ROM.</P>
      *
      */

      private String desc;


     /**
      *
      * <P>Create a new NetRomsDownloader Object.</P>
      *
      * @param Nes The current NES Engine.
      * @param Gui The current Graphical User Interface.
      * @param filename The filename to download.
      * @param description The desciption of the ROM image.
      *
      */

      public NetRomsDownloader (NES nes, GUI gui, String filename, String description) {


         // Start local References

            this.nes = nes;
            this.gui = gui;

            this.filename = filename;
            this.desc = description;

      }


     /**
      *
      * <P>The Run method to start the download.</P>
      *
      */

      public final void run() {


         // Clear Cancel Requests

            gui.cancelDownload = false;

            if (gui.downloadedFile != null && gui.downloadedFile.exists())
            {

               try
               {

                  gui.downloadedFile.delete();

               } catch (Exception e) {}

            }

            gui.downloadedFile = null;


         // Disable Simultaneous Downloads

            gui.serverMenu1.setEnabled(false);
            gui.serverMenu2.setEnabled(false);
            gui.serverMenu3.setEnabled(true);


         // Inform User of Downloading

            gui.writeToScreen("Downloading '" + desc + "'");


            try {


               // Create a URL Reader

                  URLReader reader = new URLReader(gui);


               // Ask it to Report its Progress

                  reader.setReportProgress(true);


               // Attempt to Download the ROM using the URLReader

                  if (!reader.download(new URL("http",ServerConnection.NESRomServer, ServerConnection.NESCafeRoot + "nescafe.server.asp?id=" + filename))) {


                     // An Error Occurred so Try and Resolve what Happened
                  
                        if (!reader.getLastErrorString().equals(""))
                        {
                           DavOS.MsgBox ( reader.getLastErrorString() );
                        }


                     // Throw Exception

                        throw new Exception("");

                  }


               // Save File Locally in Temp File

                  File tempFile = File.createTempFile("nescafe-", "-" + filename);
                  tempFile.deleteOnExit();


               // Copy Data into Temp File

                  FileOutputStream output = new FileOutputStream(tempFile);
                  output.write( reader.getBytes() );
                  output.close();


               // Inform the User that the Download is Ready for Playing

                  gui.writeToScreen("'" + desc + "' is ready to play");
                  gui.downloadedFile = tempFile;
                  gui.serverMenu1.setEnabled(true);
                  gui.serverMenu2.setEnabled(true);
                  gui.serverMenu3.setEnabled(false);



            } 
            catch (Exception e) 
            {

               gui.serverMenu1.setEnabled(true);
               gui.serverMenu2.setEnabled(false);
               gui.serverMenu3.setEnabled(false);
               gui.writeToScreen("Downloading '" + desc + "' failed");
               return;

            }

      }

}


#endif
