#ifdef STAND


// Declare Imports

   import java.awt.event.*;



/** 
*
* Class for the Window Listener used by the InternetConfigFrame.
*
* @author   David de Niese
* @version  0.56f
* @final    TRUE
*
*/

final class InternetConfigFrameListener implements ActionListener, ItemListener 
{



     /**
      *
      * <P>The NetRomsFrame the Listener is attached to.</P>
      *
      */

      private InternetConfigFrame host;


     /**
      *
      * <P>The current NES Engine.</P>
      *
      */

      private NES nes;


     /**
      *
      * <P>The current Graphical User Interface.</P>
      *
      */

      private GUI gui;


     /**
      *
      * <P>Create a Frame Listener for the InternetConfigFrame.</P>
      *
      */

      public InternetConfigFrameListener (NES nes, GUI gui, InternetConfigFrame host) 
      {



         // Grab References

            this.nes  = nes;
            this.gui  = gui;
            this.host = host;


      }



     /**
      *
      * <P>Handler for when a button is pressed within the NetRomsFrame.</P>
      *
      */

      public final void actionPerformed(ActionEvent e) 
      {


         // Fetch the Action Command

            String command = e.getActionCommand();


         // Check if the User Selected 'Download'

            if (command == "SET") 
            {


               // Check for Proxy Server

                  if (host.useProxy.getState())
                  {
                     if (host.proxyServer.getText().trim().equals(""))
                     {

                        DavOS.MsgBox("Please specify a Proxy Server.");
                        return;

                     }


                     if (host.proxyServerPort.getText().trim().equals(""))
                     {

                        DavOS.MsgBox("Please specify the Proxy Server Port");
                        return;

                     }


                     try 
                     {

                        Integer a = new Integer(host.proxyServerPort.getText());

                     }
                     catch (NumberFormatException nfe)
                     {

                        DavOS.MsgBox("Please specify a numeric Proxy Server Port.");
                        return;

                     }
                  }



               // Set the Settings

                  nes.usersettings.useProxyServer  = host.useProxy.getState();
                  nes.usersettings.proxyServer = host.proxyServer.getText();
                  nes.usersettings.proxyServerPort = host.proxyServerPort.getText();
                  nes.usersettings.proxyServerUsername = host.proxyUsername.getText();
                  nes.usersettings.proxyServerPassword = host.proxyPassword.getText();


               // Dispose of the Window

                  gui.internetConfigFrame.dispose();
                  gui.internetConfigFrame = null;

            }


         // Check if the User Selected 'CLOSE'

            if (command == "CANCEL" && gui.internetConfigFrame != null) 
            {

               gui.internetConfigFrame.dispose();
               gui.internetConfigFrame = null;

            }


      }



     /**
      *
      * <P>Handler for when Checkboxes are Changed.</P>
      *
      */

      public void itemStateChanged(ItemEvent e) 
      {



         // Grab the Command Name

            String menulabel = (String)e.getItem();
 


         // Use Proxy Server

            if (host.useProxy.getLabel().equals(menulabel))
            {

               boolean proxyEnabled = host.useProxy.getState();

               host.proxyServer.setEnabled(proxyEnabled);
               host.proxyServerPort.setEnabled(proxyEnabled);
               host.proxyUsername.setEnabled(proxyEnabled);
               host.proxyPassword.setEnabled(proxyEnabled);
               return;

            }


      }


}

#endif
