#ifdef STAND


// Declare Imports

   import java.awt.event.*;


/** 
 *
 * Class for GameGenie Window Adaptor required by the GameGenieWindow.
 *
 * @author   David de Niese
 * @version  0.56f
 * @final    TRUE
 *
 */

final class GameGenieWindowAdapter implements WindowListener, ActionListener 
{



     /**
      *
      * <P>The current NES Machine.</P>
      *
      */

      private NES nes;


     /**
      *
      * <P>The current Graphical User Interface.</P>
      *
      */

      private GUI gui;





     /**
      *
      * <P>Create a new Game Genie Window Adapter.</P>
      * 
      */

      public GameGenieWindowAdapter(NES Nes,GUI Gui)
      {

         nes = Nes;
         gui = Gui;

      }




     /**
      *
      * <P>Handler for closing the Game Genie Window.</P>
      * 
      * @param windowEvent The Window Event.
      * 
      */

      public final void windowClosing(WindowEvent windowEvent) 
      {


         // Completely Destroy the Game Genie Window

            gui.gameGenieWindow.dispose();
            gui.gameGenieWindow = null;


      }


     /**
      *
      * <P>Handler for activating the Game Genie Window.</P>
      * 
      * @param windowEvent The Window Event.
      * 
      */

      public final void windowActivated (WindowEvent windowEvent) {}


     /**
      *
      * <P>Handler for deactivating the Game Genie Window.</P>
      * 
      * @param windowEvent The Window Event.
      * 
      */

      public final void windowDeactivated (WindowEvent windowEvent) { }


     /**
      *
      * <P>Handler for opening the Game Genie Window.</P>
      * 
      * @param windowEvent The Window Event.
      * 
      */

      public final void windowOpened (WindowEvent windowEvent) {}


     /**
      *
      * <P>Handler for closing the Game Genie Window.</P>
      * 
      * @param windowEvent The Window Event.
      * 
      */

      public final void windowClosed (WindowEvent windowEvent) {}


     /**
      *
      * <P>Handler for iconifing the Game Genie Window.</P>
      * 
      * @param windowEvent The Window Event.
      * 
      */

      public final void windowIconified (WindowEvent windowEvent) {}


     /**
      *
      * <P>Handler for deiconifing the Game Genie Window.</P>
      * 
      * @param windowEvent The Window Event.
      * 
      */

      public final void windowDeiconified (WindowEvent windowEvent) {}


     /**
      *
      * <P>Handler for when the buttons are pressed on the Game Genie Window.</P>
      *
      */

      public final void actionPerformed(ActionEvent e) 
      {


         // Determine Which Button was Pressed

            String command = e.getActionCommand();

            if (command == "CANCEL") {

               // Completely Destroy the Chat Window

                  gui.gameGenieWindow.dispose();
                  gui.gameGenieWindow = null; 
                  return; 

            }

            if (command == "SUBMIT") {

               // Parse the Codes

                  parse(gui.gameGenieWindow.grabText());
                  return; 

            }


      }



     /**
      *
      * <P>Parse the user's codes for delivery to the Game Genie Decoder.</P>
      *
      */

      private final void parse (String[] codeBank) {


         // Find if Any Codes were Accepted

            int result = nes.memory.gameGenie.addCodeBank(codeBank); 

            if (result >= 0) {


               // Code were Accepted So Progress

                  nes.memory.gameGenieActive = (result == 1); 
                  gui.gameGenieWindow.dispose();
                  gui.gameGenieWindow = null; 


            }


      }



}

#endif
