#ifdef STAND

/** 
 *
 * Class for the Game Genie Decoder required by the NESCafe Emulator.
 *
 * @author   David de Niese
 * @version  0.56f
 * @final    TRUE
 *
 */

public final class GameGenie 
{



     /**
      * 
      * <P>The Bank of Local Game Genie Codes.</P>
      *
      */

      private GameGenieCode[] localCodes = new GameGenieCode[4];


     /**
      *
      * <P>The Game Genie Alphabet.</P>
      *
      */

      private String Letters = "APZLGITYEOXUKSVN";


     /**
      * 
      * <P>Decodes a 8-Character Game Genie Code.</P>
      *
      */

      private final int decode8(String code) 
      {


         // Convert the Code to Upper Case

            code = code.toUpperCase();


         // Check Length

            if (code.length() != 8) return -1;


         // Build Array to Hold Values

            int[] Values = new int [8];


         // Loop through Characters in Code

            for (int x=0; x<8; x++) 
            {


               // Decode Each Letter

                  String letter = code.substring(x,1+x);
                  int index = Letters.indexOf(letter);


               // Check Characters are Valid

                  if (index < 0) 
                  {

                     DavOS.MsgBox("'" + code + "' is an invalid Game Genie Code."); 
                     return -1; 

                  }

                  Values[x] = index; 


            }


         // Construct Value Parameter of Code

            int value = 0; 

            value |= ((Values[0] & 0x8)!= 0) ? 0x80 : 0; 
            value |= ((Values[1] & 0x4)!= 0) ? 0x40 : 0; 
            value |= ((Values[1] & 0x2)!= 0) ? 0x20 : 0; 
            value |= ((Values[1] & 0x1)!= 0) ? 0x10 : 0; 

            value |= ((Values[7] & 0x8)!= 0) ? 0x08 : 0; 
            value |= ((Values[0] & 0x4)!= 0) ? 0x04 : 0; 
            value |= ((Values[0] & 0x2)!= 0) ? 0x02 : 0; 
            value |= ((Values[0] & 0x1)!= 0) ? 0x01 : 0; 



         // Construct Address Parameter of Code

            int address = 0; 

            address |= ((Values[3] & 0x04) !=0)? 0x4000 : 0; 
            address |= ((Values[3] & 0x02) !=0)? 0x2000 : 0; 
            address |= ((Values[3] & 0x01) !=0)? 0x1000 : 0; 
            address |= ((Values[4] & 0x08) !=0)? 0x0800 : 0; 

            address |= ((Values[5] & 0x04) !=0)? 0x0400 : 0; 
            address |= ((Values[5] & 0x02) !=0)? 0x0200 : 0; 
            address |= ((Values[5] & 0x01) !=0)? 0x0100 : 0; 
            address |= ((Values[1] & 0x08) !=0)? 0x0080 : 0; 

            address |= ((Values[2] & 0x04) !=0)? 0x0040 : 0; 
            address |= ((Values[2] & 0x02) !=0)? 0x0020 : 0; 
            address |= ((Values[2] & 0x01) !=0)? 0x0010 : 0; 
            address |= ((Values[3] & 0x08) !=0)? 0x0008 : 0; 

            address |= ((Values[4] & 0x04) !=0)? 0x0004 : 0; 
            address |= ((Values[4] & 0x02) !=0)? 0x0002 : 0; 
            address |= ((Values[4] & 0x01) !=0)? 0x0001 : 0; 


         // Construct Compare Value of Code

            int compare = 0; 
      
            compare |= ((Values[6] & 0x8)!= 0) ? 0x80 : 0; 
            compare |= ((Values[7] & 0x4)!= 0) ? 0x40 : 0; 
            compare |= ((Values[7] & 0x2)!= 0) ? 0x20 : 0; 
            compare |= ((Values[7] & 0x1)!= 0) ? 0x10 : 0; 
      
            compare |= ((Values[5] & 0x8)!= 0) ? 0x08 : 0; 
            compare |= ((Values[6] & 0x4)!= 0) ? 0x04 : 0; 
            compare |= ((Values[6] & 0x2)!= 0) ? 0x02 : 0; 
            compare |= ((Values[6] & 0x1)!= 0) ? 0x01 : 0; 



         // Increment the Address

            address += 0x8000; 


         // Create the New Code Object

            GameGenieCode newCode = new GameGenieCode();
            newCode.code = code; 
            newCode.address = address; 
            newCode.value = value; 
            newCode.compare = compare; 


         // Add the New Code
      
            addCode(newCode); 
            return 0; 

      }



     /**
      * 
      * <P>Decodes a 6-Character Game Genie Code.</P>
      *
      */

      private final int decode6(String code) 
      {



         // Convert the Code to Upper Case

            code = code.toUpperCase();


         // Check Length
 
            if (code.length() != 6) return -1; 


         // Build Array to Hold Values

            int[] Values = new int [6]; 


         // Loop through Characters in Code

            for (int x=0; x<6; x++) {


               // Decode Each Letter

                  String letter = code.substring(x,1+x); 
                  int index = Letters.indexOf(letter); 


               // Check Characters are Valid

                  if (index < 0) {

                     DavOS.MsgBox("'" + code + "' is an invalid Game Genie Code.");
                     return -1;

                  }

                  Values[x] = index;

            }



         // Construct Value Parameter of Code

            int value = 0;

            value |= ((Values[0] & 0x8)!= 0) ? 0x80 : 0;
            value |= ((Values[1] & 0x4)!= 0) ? 0x40 : 0;
            value |= ((Values[1] & 0x2)!= 0) ? 0x20 : 0;
            value |= ((Values[1] & 0x1)!= 0) ? 0x10 : 0;

            value |= ((Values[5] & 0x8)!= 0) ? 0x08 : 0;
            value |= ((Values[0] & 0x4)!= 0) ? 0x04 : 0;
            value |= ((Values[0] & 0x2)!= 0) ? 0x02 : 0;
            value |= ((Values[0] & 0x1)!= 0) ? 0x01 : 0;


         // Construct Address Parameter of Code

            int address = 0;

            address |= ((Values[3] & 0x04) !=0)? 0x4000 : 0;
            address |= ((Values[3] & 0x02) !=0)? 0x2000 : 0;
            address |= ((Values[3] & 0x01) !=0)? 0x1000 : 0;
            address |= ((Values[4] & 0x08) !=0)? 0x0800 : 0;

            address |= ((Values[5] & 0x04) !=0)? 0x0400 : 0;
            address |= ((Values[5] & 0x02) !=0)? 0x0200 : 0;
            address |= ((Values[5] & 0x01) !=0)? 0x0100 : 0;
            address |= ((Values[1] & 0x08) !=0)? 0x0080 : 0;

            address |= ((Values[2] & 0x04) !=0)? 0x0040 : 0;
            address |= ((Values[2] & 0x02) !=0)? 0x0020 : 0;
            address |= ((Values[2] & 0x01) !=0)? 0x0010 : 0;
            address |= ((Values[3] & 0x08) !=0)? 0x0008 : 0;

            address |= ((Values[4] & 0x04) !=0)? 0x0004 : 0;
            address |= ((Values[4] & 0x02) !=0)? 0x0002 : 0;
            address |= ((Values[4] & 0x01) !=0)? 0x0001 : 0;


         // Increment the Address

            address += 0x8000; 


         // Create the New Code Object

            GameGenieCode newCode = new GameGenieCode();
            newCode.code = code;
            newCode.address = address;
            newCode.value = value;
            newCode.compare = -1;


         // Add the New Code
      
            addCode(newCode);
            return 0;

      }



     /**
      *
      * Add a Game Genie Code to the Collection.
      *
      */

      private final void addCode(GameGenieCode newCode) 
      {


         // Only Insert if Free Space Found

            for (int i = 0; i<localCodes.length; i++) {

               if (localCodes[i] == null) {

                  localCodes[i] = newCode;
                  return;

               }

            }

      }


     /**
      *
      * <P>Clear all the Game Genie Codes.</P>
      *
      */

      public final void clearCodes() 
      {


         // Clear out old Codes

            for (int i=0; i<localCodes.length; i++)
               localCodes[i] = null;


         // Garbage Collection

            System.gc();


      }


     /**
      *
      * <P>Add the Codes to the Code Bank.</P>
      *
      */

      public final int addCodeBank(String[] codeBank) 
      {


         // Clear Old Codes

            clearCodes();



         // Decode Each Code in the Array

            for (int i=0; i<codeBank.length; i++)
            {

               String code = codeBank[i];

               if (code.length() == 6) {

                  if (decode6(code) < 0) return -1;
  
               } else if (code.length() == 8) {

                  if (decode8(code) < 0) return -1;

               } else if (code.length() > 0) {

                  DavOS.MsgBox("'" + code + "' is an invalid Game Genie Code.");
                  return -1;
  
               }


            }


         // Return Positive if at Least One Code was Stored

            return (AtLeastOneStored() ? 1:0);


      }



     /**
      *
      * Returns true if at least one Code is in the Bank.
      *
      */

      private final boolean AtLeastOneStored() 
      {


         boolean foundOne = false;

         for (int i=0; i< localCodes.length; i++)
            if (localCodes[i] != null) foundOne = true;

         return foundOne;

      }



     /**
      *
      * Returns the Index of the Code that matches the given address.
      *
      */

      public final int addressMatch(int address) 
      {


         // Look for Matching Code

            for (int i=0; i< localCodes.length; i++) 
            {

               if (localCodes[i] != null)
                  if (localCodes[i].address == address) return i;

            }
  

         // No Matching Code

            return -1;


      }



     /**
      *
      * <P>Returns the Value of the Code at the given Index.</P>
      *
      */

      public final int getValue(int index) 
      {

         if (localCodes[index] != null)
            return localCodes[index].value;

         return 0;

      }


     /**
      *
      * <P>Returns the Compare Value of the Code at the given Index.</P>
      *
      */

      public final int getCompare(int index) 
      {

         if (localCodes[index] != null)
            return localCodes[index].compare;

         return 0;

      }


     /**
      *
      * <P>Returns the Code at the given Index.</P>
      *
      */

      public final String getCode(int index) 
      {

         if (localCodes[index] != null)
            return localCodes[index].code;

         return "";

      }


}

#endif
