#ifndef MOBILE

// Declare Imports

   import java.awt.*;
   import java.io.*;
   import java.awt.event.*;




/** 
 *
 * Class for the GUI required by the NESCafe NES Emulator.
 *
 * @author   David de Niese
 * @version  0.56f
 * @final    TRUE
 *
 */

public final class GUI extends Frame 
{



//////////////////////////////////////////////////////////////////////
//
// Main System Components
//
//////////////////////////////////////////////////////////////////////


     /**
      *
      * <P>The current NES Machine.</P>
      *
      */

      protected NES nes;



#ifdef STAND

     /**
      *
      * <P>Cancel any current downloading of ROMs to the GUI.</P>
      *
      */

      public boolean cancelDownload = false;



     /**
      *
      * <P>The Currently Downloaded File</P>
      *
      */

      public File downloadedFile = null;




     /**
      *
      * <P>The Server Connection used by the GUI.</P>
      *
      */

      protected ServerConnection serverConnection;

#endif


#ifndef MOBILE


     /**
      *
      * <P>The Canvas Object for Drawing.</P>
      *
      */

      private Canvas canvas = new Canvas();

#endif



#ifdef STAND

     /**
      *
      * <P>The Game Genie Console.</P>
      *
      */

      protected GameGenieWindow gameGenieWindow;

#endif


     /**
      *
      * <P>The Graphics Object of the Canvas.</P>
      *
      */

      private Graphics graphics;


     /**
      *
      * <P>Signals that the user has requested to Load State.</P>
      *
      */

      public boolean loadStateRequest = false;



     /**
      *
      * <P>Signals that the user has requested to Save State.</P>
      *
      */

      public boolean saveStateRequest = false;



     /**
      *
      * <P>The TV Controller used by the GUI.</P>
      *
      */

      protected TVController tvController;


     /**
      *
      * <P>Whether the GUI is displaying a Please Wait screen.</P>
      *
      */

      public boolean waitMode = false;


#ifdef STAND

     /**
      *
      * <P>The Download ROMS Frame.</P>
      *
      */

      protected NetRomsFrame downloadFrame;



     /**
      *
      * <P>The Internet Config Frame.</P>
      *
      */

      protected InternetConfigFrame internetConfigFrame;

#endif


//////////////////////////////////////////////////////////////////////
//
// Main Menu System
//
//////////////////////////////////////////////////////////////////////


#ifdef STAND

     /**
      *
      * <P>The File Menu.</P>
      *
      */

      private Menu menuFile = new Menu("File");


     /**
      *
      * <P>The CPU Menu.</P>
      *
      */

      private Menu menuCPU = new Menu("Nes");



     /**
      *
      * <P>The Debug SubMenu.</P>
      *
      */

      private Menu menuDebug = new Menu("Debug Nintendo ROM...");



     /**
      *
      * <P>The View Menu.</P>
      *
      */

      private Menu menuView = new Menu("View");



     /**
      *
      * <P>The Sound Menu.</P>
      *
      */

      private Menu menuSound = new Menu("Sound");



     /**
      *
      * <P>The Server Menu.</P>
      *
      */

      private Menu menuServer = new Menu("Online");




//////////////////////////////////////////////////////////////////////
//
// Sub Menu System
//
//////////////////////////////////////////////////////////////////////



     /**
      *
      * <P>File Open Menu item.</P>
      *
      */

      protected MenuItem fileMenu1 = new MenuItem("Load Rom...");


     /**
      *
      * <P>File Close Menu item.</P>
      *
      */

      protected MenuItem fileMenu2 = new MenuItem("Close Rom");


     /**
      *
      * <P>Exit NESCafe Menu item.</P>
      *
      */

      protected MenuItem fileMenu3 = new MenuItem("Exit NESCafe");


     /**
      *
      * <P>Save GIF Menu item.</P>
      *
      */

      protected MenuItem fileMenu4 = new MenuItem("Save as " + SaveImage.extension);


     /**
      *
      * <P>Commit Save State Menu item.</P>
      *
      */

      protected MenuItem fileMenu5 = new MenuItem("Commit State");


     /**
      *
      * <P>Rollback Load State Menu item.</P>
      *
      */

      protected MenuItem fileMenu6 = new MenuItem("Rollback to State");



     /**
      *
      * <P>Reset Rom Menu item.</P>
      *
      */

      protected MenuItem cpuMenu1 = new MenuItem("Reset ROM");


     /**
      *
      * <P>Pause Rom Menu item.</P>
      *
      */

      protected CheckboxMenuItem cpuMenu2 = new CheckboxMenuItem("Pause ROM",false);



     /**
      *
      * <P>For Entering Game Genie Codes.</P>
      *
      */

      protected MenuItem cpuMenu4 = new MenuItem("Enter Game Genie Code...");


     /**
      *
      *
      * <P>For allowing the Undocumented OpCodes.</P>
      *
      */

      protected CheckboxMenuItem cpuMenu5 = new CheckboxMenuItem("Allow Undocumented OpCodes",false);




     /**
      *
      *
      * <P>Controller 1 Joypad Menu</P>
      *
      */

      protected CheckboxMenuItem cpuMenu6 = new CheckboxMenuItem("Enable Light Gun",false);



     /**
      *
      *
      * <P>Debug Mode.</P>
      *
      */

      protected CheckboxMenuItem cpuMenu7 = new CheckboxMenuItem("Debug Mode",false);


     /**
      *
      *
      * <P>Debug Step.</P>
      *
      */

      protected MenuItem cpuMenu8 = new MenuItem("Step Instruction", new MenuShortcut(117));



     /**
      *
      *
      * <P>Debug Stepx20.</P>
      *
      */

      protected MenuItem cpuMenu9 = new MenuItem("Step Instruction x20", new MenuShortcut(118));




     /**
      *
      *
      * <P>Debug to Interrupt.</P>
      *
      */

      protected MenuItem cpuMenu10 = new MenuItem("Step to Event", new MenuShortcut(119));




     /**
      *
      * <P>Toggle FPS Menu item.</P>
      *
      */

      protected CheckboxMenuItem viewMenu1 = new CheckboxMenuItem("Show FPS Count",false);


     /**
      *
      * <P>Toggle Background Layer Menu item.</P>
      *
      */

      protected CheckboxMenuItem viewMenu2 = new CheckboxMenuItem("Show Background",true);


     /**
      *
      * <P>Toggle Sprites Menu item.</P>
      *
      */

      protected CheckboxMenuItem viewMenu3 = new CheckboxMenuItem("Show Sprites",true);


     /**
      *
      * <P>Toggle Sound Enable.</P>
      *
      */

      protected CheckboxMenuItem soundMenu1 = new CheckboxMenuItem("Enable Sound",false);


     /**
      *
      * <P>Toggle Sound Recording.</P>
      *
      */

      protected MenuItem soundMenu2 = new MenuItem("Start Recording WAV");


     /**
      *
      * <P>Toggle Sound Channel 1.</P>
      *
      */

      protected CheckboxMenuItem soundMenu3 = new CheckboxMenuItem("Enable Channel 1 (Square)",true);

     /**
      *
      * <P>Toggle Sound Channel 2.</P>
      *
      */

      protected CheckboxMenuItem soundMenu4 = new CheckboxMenuItem("Enable Channel 2 (Square)",true);


     /**
      *
      * <P>Toggle Sound Channel 3.</P>
      *
      */

      protected CheckboxMenuItem soundMenu5 = new CheckboxMenuItem("Enable Channel 3 (Triangle)",true);



     /**
      *
      * <P>Toggle Sound Channel 4.</P>
      *
      */

      protected CheckboxMenuItem soundMenu6 = new CheckboxMenuItem("Enable Channel 4 (Noise)",true);



     /**
      *
      * <P>Toggle Sound Channel 5.</P>
      *
      */

      protected CheckboxMenuItem soundMenu7 = new CheckboxMenuItem("Enable Channel 5 (DMC)",true);



     /**
      *
      * <P>NESCafe Chat</P>
      *
      */

      protected MenuItem serverMenu0 = new MenuItem("NESCafe Chat...");



     /**
      *
      * <P>Download ROM Image from Server</P>
      *
      */

      protected MenuItem serverMenu1 = new MenuItem("Download ROM...");



     /**
      *
      * <P>Download ROM Image from Server</P>
      *
      */

      protected MenuItem serverMenu3 = new MenuItem("Cancel Download!");



     /**
      *
      * <P>Download ROM Image from Server</P>
      *
      */

      protected MenuItem serverMenu2 = new MenuItem("Play Downloaded ROM");


     /**
      *
      * <P>Download ROM Image from Server</P>
      *
      */

      protected MenuItem serverMenu4 = new MenuItem("Configure Online Settings...");



#ifdef FUTURE

     /**
      *
      * <P>Toggle CoffeePot Server</P>
      *
      */

      protected CheckboxMenuItem serverMenu5 = new CheckboxMenuItem("Enable CoffeePot Server on My Computer",false);


     /**
      *
      * <P>Connect to a CoffeePot Server</P>
      *
      */

      protected MenuItem serverMenu6 = new MenuItem("Connect to Remote CoffeePot Server...");


#endif

#endif


//////////////////////////////////////////////////////////////////////
//
// Class Methods
//
//////////////////////////////////////////////////////////////////////


     /**
      *
      * <P>Create a new Graphical User Interface.</P>
      *
      */

      public GUI() 
      {

      }


#ifdef STAND


     /**
      *
      * <P>Create the Menu Bar.</P>
      *
      */

      private final MenuBar createMenu() 
      {


         // Create a Font

            Font font = new Font("Helvetica", Font.PLAIN, 12);


         // Create the Menu Monitor

            GUIMenuMonitor menuMonitor = new GUIMenuMonitor(nes,this);


         // Add the Menu Monitor to the File Menu Items

            fileMenu1.addActionListener(menuMonitor);
            fileMenu2.addActionListener(menuMonitor);
            fileMenu3.addActionListener(menuMonitor);
            fileMenu4.addActionListener(menuMonitor);
            fileMenu5.addActionListener(menuMonitor);
            fileMenu6.addActionListener(menuMonitor);


         // Add the Menu Monitor to the CPU Menu Items

            cpuMenu1.addActionListener(menuMonitor);
            cpuMenu2.addItemListener(menuMonitor);
            cpuMenu4.addActionListener(menuMonitor);
            cpuMenu5.addItemListener(menuMonitor);
            cpuMenu6.addItemListener(menuMonitor);

            cpuMenu7.addItemListener(menuMonitor);
            cpuMenu8.addActionListener(menuMonitor);
            cpuMenu9.addActionListener(menuMonitor);
            cpuMenu10.addActionListener(menuMonitor);



         // Add the Menu Monitor to the View Menu Items

            viewMenu1.addItemListener(menuMonitor);
            viewMenu2.addItemListener(menuMonitor);
            viewMenu3.addItemListener(menuMonitor);


         // Add the Menu Monitor to the Sound Menu Items

            soundMenu1.addItemListener(menuMonitor);
            soundMenu2.addActionListener(menuMonitor);
            soundMenu3.addItemListener(menuMonitor);
            soundMenu4.addItemListener(menuMonitor);
            soundMenu5.addItemListener(menuMonitor);
            soundMenu6.addItemListener(menuMonitor);
            soundMenu7.addItemListener(menuMonitor);


         // Add the Menu Monitor to the Sound Menu Items

            serverMenu0.addActionListener(menuMonitor);
            serverMenu1.addActionListener(menuMonitor);
            serverMenu2.addActionListener(menuMonitor);
            serverMenu3.addActionListener(menuMonitor);
            serverMenu4.addActionListener(menuMonitor);
            
#ifdef FUTURE

            serverMenu5.addItemListener(menuMonitor);
            serverMenu6.addActionListener(menuMonitor);

#endif


         // Set Command Names for Menu Items

            fileMenu1.setActionCommand("OPEN");
            fileMenu2.setActionCommand("CLOSE");
            fileMenu3.setActionCommand("EXIT");
            fileMenu4.setActionCommand("SAVEGIF");
            fileMenu5.setActionCommand("SAVESTATE");
            fileMenu6.setActionCommand("LOADSTATE");
            cpuMenu1.setActionCommand("RESET");            
            cpuMenu4.setActionCommand("GAMEGENIE");
            cpuMenu8.setActionCommand("DEBUGSTEP");
            cpuMenu9.setActionCommand("DEBUGSTEP20");
            cpuMenu10.setActionCommand("DEBUGEVENT");
            soundMenu2.setActionCommand("SOUNDRECORD");

            serverMenu0.setActionCommand("NESCAFECHAT");
            serverMenu1.setActionCommand("DOWNLOADROM");
            serverMenu2.setActionCommand("DOWNLOADPLAY");
            serverMenu3.setActionCommand("DOWNLOADSTOP");
            serverMenu4.setActionCommand("CONFIGINTERNET");
            
#ifdef FUTURE
            serverMenu6.setActionCommand("CONNECTCOFFEEPOT");
#endif

            


         // Construct File Menu

            menuFile.add(fileMenu1);
            menuFile.add(fileMenu2);
            menuFile.addSeparator();

            menuFile.add(fileMenu4);
            menuFile.addSeparator();

            menuFile.add(fileMenu5);
            menuFile.add(fileMenu6);
            menuFile.addSeparator();
            menuFile.add(fileMenu3);


         // Construct CPU Menu

            menuCPU.add(cpuMenu1);
            menuCPU.add(cpuMenu2);
            menuCPU.addSeparator();
            menuCPU.add(cpuMenu6);
            menuCPU.addSeparator();

            menuDebug.add(cpuMenu7);
            menuDebug.add(cpuMenu8);
            menuDebug.add(cpuMenu9);
            menuDebug.add(cpuMenu10);

            menuCPU.add(menuDebug);
            menuCPU.add(cpuMenu5);
            menuCPU.addSeparator();
            menuCPU.add(cpuMenu4);


         // Construct View Menu

            menuView.add(viewMenu1);
            menuView.addSeparator();
            menuView.add(viewMenu2);
            menuView.add(viewMenu3);


#ifdef SOUND

         // Construct Sound Menu

            menuSound.add(soundMenu1);
            menuSound.addSeparator();
            menuSound.add(soundMenu3);
            menuSound.add(soundMenu4);
            menuSound.add(soundMenu5);
            menuSound.add(soundMenu6);
            menuSound.add(soundMenu7);
            menuSound.addSeparator();
            menuSound.add(soundMenu2);


#endif


         // Construct Server Menu

            serverMenu0.setEnabled(false);
            
#ifdef FUTURE

            menuServer.add(serverMenu5);
            menuServer.add(serverMenu6);
            menuServer.addSeparator();
            
#endif

            menuServer.add(serverMenu0);
            menuServer.addSeparator();
            menuServer.add(serverMenu1);
            menuServer.add(serverMenu3);
            menuServer.add(serverMenu2);
            menuServer.addSeparator();
            menuServer.add(serverMenu4);
            serverMenu2.setEnabled(false);
            serverMenu3.setEnabled(false);


         // Create the Menu Bar and Return It

            MenuBar mb = new MenuBar();

            mb.add(menuFile);
            mb.add(menuCPU);
            mb.add(menuView);
            
#ifdef SOUND

            mb.add(menuSound);
            
#endif


            mb.add(menuServer);

     
            return mb;

      }

#endif


     /**
      *
      * <P>Initialise and Display the GUI.</P>
      *
      * @param Nes The current NES Engine.
      *
      */

      public final void init(NES nes) 
      {


         // Set Pointers

            this.nes = nes;



#ifdef STAND


         // Check Graphics Capabilities

            try 
            {

               Font f = new Font("Helvetica",10,Font.BOLD);
               f = null;

            } 
            catch (InternalError e) 
            {

               System.err.println("Computer has no Graphics device.");
               System.exit(1);

            }



         // Create and Set Menu Bar

            MenuBar menuBar = createMenu();
            setMenuBar(menuBar);


         // Create and Set the Window Adapter

            GUIWindowAdapter winAdapter = new GUIWindowAdapter(this,nes);
            addWindowListener(winAdapter);


         // Create the Layout

            setLayout(new BorderLayout());


         // Create a Font Object

            Font menuFont = new Font("Helvetica", Font.PLAIN, 10);


         // Set up the Frame

            setResizable(true);
            setTitle("NESCafe Emulator v" + NESCafe.version);
            setBackground(Color.black );
            setForeground(Color.black);


            
#endif

#ifdef APPLET

            nes.applet.setLayout(new BorderLayout());


#endif


#ifndef MOBILE


         // Add KeyListeners to Canvas and Frame

            GUIKeyListener keylistener = new GUIKeyListener(nes,this);
            GUIMouseListener mouselistener = new GUIMouseListener(nes,this);

#endif


#ifdef APPLET



            nes.applet.addKeyListener(keylistener);
            nes.applet.addMouseListener(mouselistener);
            nes.applet.addMouseMotionListener(mouselistener);
               
               
#endif

#ifdef STAND


         // Add Key Listener to Canvas

            canvas.addKeyListener(keylistener);
            canvas.addMouseListener(mouselistener);
            canvas.addMouseMotionListener(mouselistener);


         // Set Canvas Attribs and Add to Frame

            canvas.setSize(270,260); 
            canvas.setBackground(Color.black);


         // Add Canvas to Screen

            addKeyListener(keylistener);
            add (canvas, BorderLayout.CENTER);


         // Return Screen Size

            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            final int w = 320;
            final int h = 280;


         // Position the Frame at the Center of the Screen

            setLocation(screenSize.width/2 - w/2, screenSize.height/2 - h/2);


         // Set the Correct Menu

            showMenuNoRom();


         // Create the Server Connection

            serverConnection = new ServerConnection(nes,this);


         // Show the Frame

            pack();
            show();



         // Set Pointer to Graphics Context

            graphics = canvas.getGraphics();
            graphics.setFont(new Font("Helvetica",Font.PLAIN, 10));



#endif


         // Create a new TV Controller

            tvController = new TVController(nes,this);
            
            
#ifndef PUNCHOUT

            writeToScreen("Welcome to NESCafe " + NESCafe.version);

#endif



      }



     /**
      *
      * <P>Pauses display and NES Machine.</P>
      *
      */

      public final void pauseSystem(boolean pause) 
      {


         // Checks for Cartridge

            if (!nes.isCartRunning()) return;


         // Enable/Disable the CPU drawing to the Screen

            nes.cpu.enableDrawScreen(!pause);


         // Enable/Disable the CPU Running

            nes.cpu.setCpuActive(!pause);


         // Blank the Screen

            if (pause) showBlankDisplay();

      }



#ifdef STAND


     /**
      * 
      * <P>Configure Menu for when no Rom is loaded.</P>
      *
      */

      public final void showMenuNoRom() 
      {


         // Enable and Disable File Menu Items

            fileMenu1.setEnabled(true);
            fileMenu2.setEnabled(false);
            fileMenu3.setEnabled(true);
            fileMenu4.setEnabled(false);
            fileMenu5.setEnabled(false);
            fileMenu6.setEnabled(false);


         // Enable and Disable CPU Menu Items

            cpuMenu1.setEnabled(false);
            cpuMenu2.setEnabled(false);
            cpuMenu4.setEnabled(false);
            cpuMenu7.setEnabled(false);
            cpuMenu8.setEnabled(false);
            cpuMenu9.setEnabled(false);
            cpuMenu10.setEnabled(false);
            menuDebug.setEnabled(false);


         // Enable and Disable View Menu Items

            viewMenu1.setEnabled(false);
            viewMenu2.setEnabled(false);
            viewMenu3.setEnabled(false);


#ifdef SOUND

         // Enable and Disable Sound Menu Items

            boolean soundEnabled = false;

 
            if (nes.sound != null)
               soundEnabled = nes.sound.soundEngineLoaded;


            soundMenu1.setEnabled(soundEnabled);
            
            
            if (nes.sound != null && nes.sound.soundEngineLoaded && nes.sound.enableAllSound)
               soundEnabled = true;
            else
               soundEnabled = false;
               
            soundMenu3.setEnabled(soundEnabled);
            soundMenu4.setEnabled(soundEnabled);
            soundMenu5.setEnabled(soundEnabled);
            soundMenu6.setEnabled(soundEnabled);
            soundMenu7.setEnabled(soundEnabled);

            soundMenu2.setEnabled(false);

#endif

      }


     /**
      * 
      * <P>Configure Menu for when a Rom is loaded.</P>
      *
      */

      public final void showMenuRom() 
      {


         // Enable and Disable File Menu Items

            fileMenu1.setEnabled(true);
            fileMenu2.setEnabled(true);
            fileMenu3.setEnabled(true);
            fileMenu4.setEnabled(true);
            fileMenu5.setEnabled(true);
            fileMenu6.setEnabled(true);


         // Enable and Disable CPU Menu Items

            cpuMenu1.setEnabled(true);
            cpuMenu2.setEnabled(true);
            cpuMenu4.setEnabled(true);
            cpuMenu7.setEnabled(true);
            cpuMenu8.setEnabled(cpuMenu7.getState());
            cpuMenu9.setEnabled(cpuMenu7.getState());
            cpuMenu10.setEnabled(cpuMenu7.getState());
            menuDebug.setEnabled(true);


         // Enable and Disable View Menu Items

            viewMenu1.setEnabled(true);
            viewMenu2.setEnabled(true);
            viewMenu3.setEnabled(true);



#ifdef SOUND

         // Enable and Disable Sound Menu Items

            boolean soundEnabled = false;

            if (nes.sound != null)
               soundEnabled = nes.sound.soundEngineLoaded ;


            soundMenu1.setEnabled(soundEnabled);
            
            
            if (nes.sound != null && nes.sound.soundEngineLoaded && nes.sound.enableAllSound)
               soundEnabled = true;
            else
               soundEnabled = false;
               
            soundMenu3.setEnabled(soundEnabled);
            soundMenu4.setEnabled(soundEnabled);
            soundMenu5.setEnabled(soundEnabled);
            soundMenu6.setEnabled(soundEnabled);
            soundMenu7.setEnabled(soundEnabled);

            soundMenu2.setEnabled(soundMenu1.getState() && soundEnabled);

#endif


      }

#endif


//////////////////////////////////////////////////////////////////////
// 
// Basic Display Information Gathering Functions
//
/////////////////////////////////////////////////////////////////////


     /**
      *
      * <P>Returns the graphics context of the canvas.</P>
      *
      */

      public final Graphics connect() 
      {

         return graphics;

      }


     /**
      *
      * <P>Blank the current screen with Logo.</P>
      *
      */

      public final void showBlankDisplay() 
      {

         if (tvController != null)
            tvController.blankScreen();

      }


     /**
      *
      * <P>Blank the current screen with Logo.</P>
      *
      */

      public final void showNESCafeLogo()
      {
         if (tvController != null)
            tvController.showNESCafeLogo();
            
      }



     /**
      *
      * <P>Blank the current screen with Black.</P>
      *
      */

      public final void deleteDisplay() 
      {

         if (tvController != null) 
            tvController.deleteDisplay();

      }


     /**
      *
      * <P>Returns the display width of the canvas.</P>
      *
      */

      public final int getDispWidth() 
      {

         return canvas.getWidth();

      }


     /**
      *
      * <P>Returns the display height of the canvas.</P>
      *
      */

      public final int getDispHeight() 
      {

         return canvas.getHeight();

      }





     /**
      *
      * <P>Displays the ROM Loading Screen.</P>
      *
      */

      public final void showLoadingScreen(boolean show) 
      {

         waitMode = show;
         if (show) tvController.drawScreen(true);

      }




     /**
      *
      * <P>Writes a temporary message to the status bar.</P>
      *
      */

      public final void writeToScreen(String message) 
      {

          Messenger note = new Messenger(this,message);
          note.start();

      }





     /**
      *
      * <P>Writes a permanent message to the status bar.</P>
      *
      */

      public final void writeToTopBar(String message) 
      {

         // Display Message in Top Status Bar

            tvController.setTopStatusBar(message);


      }





#ifdef STAND


     /**
      *
      * <P>Display the Game Genie Screen.</P>
      *
      */

      public final void setGameGenieWindowVisible() 
      {

         if (gameGenieWindow == null) 
         {

            try 
            {

               gameGenieWindow = new GameGenieWindow(nes,this);

            } catch (Exception e) {}

         } else { 

            gameGenieWindow.setState(Frame.NORMAL);
            gameGenieWindow.show(); 

         }

      }


     /**
      *
      * <P>Display the Download ROMS Frame.</P>
      *
      */

      public final void setDownloadFrameVisible() 
      {

         if (downloadFrame == null) 
         {

            try 
            {

               downloadFrame = new NetRomsFrame(nes,this);
               downloadFrame.setVisible(true);

               Thread downloadList = new Thread(downloadFrame);
               downloadList.start();


            } 
            catch (Exception e) {}

         } 
         else 
         { 

            downloadFrame.setState(Frame.NORMAL);
            downloadFrame.show(); 
            downloadFrame.repaint();

         }

      }
    

     /**
      *
      * <P>Display the Download ROMS Frame.</P>
      *
      */

      public final void setInternetConfigFrameVisible() 
      {

         if (internetConfigFrame == null) 
         {

            try 
            {

               internetConfigFrame = new InternetConfigFrame(nes,this);
               internetConfigFrame.setVisible(true);
               internetConfigFrame.repaint();

            } 
            catch (Exception e) { e.printStackTrace(); }

         } else { 

            internetConfigFrame.setState(Frame.NORMAL);
            internetConfigFrame.show(); 

         }

      }
      
#endif

}

#endif
