#ifdef STAND


// Declare Imports

   import java.awt.event.*;


/** 
*
* Class for the Chat Window Listeners required by the ChatWindow.
*
* @author   David de Niese
* @version  0.56f
* @final    TRUE
*
*/

final class ChatWindowKeyListener implements KeyListener 
{



     /**
      *
      * <P>The current NES Machine.</P>
      *
      */

      private NES nes;


     /**
      *
      * <P>The current Graphical User Interface.</P>
      *
      */

      private GUI gui;


     /**
      *
      * <P>Create a new ChatWindowListener.</P>
      *
      * @param Nes The NES Machine.
      * @param Gui The Graphical User Interface.
      *
      */

      public ChatWindowKeyListener (NES nes, GUI gui) 
      {

         this.nes = nes;
         this.gui = gui;

      }



     /**
      *
      * <P>Handler for when a key is being pressed down in the Chat Window.</P>
      *
      * @param keyevent The Keyevent.
      *
      */

      public final void keyPressed(KeyEvent keyevent) {}


     /**
      *
      * <P>Handler for when a key is released in the Chat Window.</P>
      *
      * @param keyevent The Keyevent.
      *
      */

      public final void keyReleased(KeyEvent keyevent) 
      {


         // Check for Escape Key

            if (keyevent.getKeyCode() == 27) 
            {

               gui.serverConnection.chatWindow.grabText();
               return;

            }


         // Check for Enter Key

            if (keyevent.getKeyCode() == KeyEvent.VK_ENTER) 
            {

               parse(gui.serverConnection.chatWindow.grabText());
               return;

            }


      }



     /**
      *
      * <P>Handler for when a key is typed in the Chat Window.</P>
      *
      * @param keyevent The Keyevent.
      *
      */

      public final void keyTyped(KeyEvent keyevent) {}




     /**
      *
      * <P>Parse the user's text for delivery to the Chat Server.</P>
      *
      * @param text The text that the user has typed.
      *
      */

      private final void parse (String text) 
      {
        

         // Send Message to All Users with a Content Type of Chat

            gui.serverConnection.sendMessage("*:chat:" + text);


      }


}

#endif

