#ifdef STAND


// Declare Imports

   import java.awt.*;
   import java.awt.event.*;


/** 
 *
 * Class for the Chat Window required by the NESCafe NES Emulator.
 *
 * @author   David de Niese
 * @version  0.56f
 * @final    TRUE
 *
 */

public final class ChatWindow extends Frame 
{


     /**
      *
      * <P>The current NES Machine.</P>
      *
      */

      private NES nes;


     /**
      *
      * <P>The current Graphical User Interface.</P>
      *
      */

      private GUI gui;


     /**
      *
      * <P>The Console Window.</P>
      *
      */

      private java.awt.TextArea console = new java.awt.TextArea();


     /**
      * 
      * <P>The line of text written by the user.</P>
      *
      */

      private java.awt.TextField command;




     /**
      *
      * <P>Create a new Chat Window.</P>
      * 
      * @param Nes The current NES Machine.
      * @param Gui The current Graphical User Interface.
      *
      */

      public ChatWindow (NES nes, GUI gui) 
      {


         // Grab Pointers to NES and GUi

            this.nes = nes;
            this.gui = gui;


         // Set Border Layout for Chat Window

            setLayout(new BorderLayout());


         // Create and Add a Window Adaptor

            ChatWindowAdapter winAdapter = new ChatWindowAdapter(nes,gui);
            addWindowListener(winAdapter);


         // Create a Font Object

            Font menuFont = new Font("Helvetica", Font.PLAIN, 12);


         // Set up the Frame

            setResizable(true);
            setTitle("NESCafe - Chat Window");
            setBackground(Color.white);


         // Add the Console Window

            console.setEditable(false);
            console.setFont(new Font("Courier",Font.PLAIN,10 ));
            console.setBackground(Color.white);
            console.setForeground(Color.black);
            console.setSize(400,400);

            add(console, BorderLayout.CENTER);


         // Add Message Entry Box

            command = new TextField();
            command.setBackground(Color.white);
            command.setForeground(Color.black);
            command.addKeyListener(new ChatWindowKeyListener(nes,gui));


         // Create a Label prompting the User

            Label botLabel = new Label("Message  ");



         // Create the Bottom Panel

            Panel botPanel = new Panel();
            botLabel.setFont(new Font("Helvetica",Font.PLAIN,10));
            botLabel.setForeground(Color.black);
            botLabel.setBackground(Color.lightGray);
            botPanel.setLayout(new BorderLayout());
            botPanel.add (botLabel, BorderLayout.WEST);
            botPanel.add (command,  BorderLayout.CENTER);


         // Add the Bottom Panel to the Screen

            add(botPanel, BorderLayout.SOUTH);
         


         // Return Screen Size

            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();

            final int w = 400;
            final int h = 400;

       
         // Position the Frame at the Center of the Screen
  
            setLocation(screenSize.width/2 - w/2, screenSize.height/2 - h/2);


         // Show the Frame

            pack();
            show();

            command.requestFocus();


      }


     /**
      *
      * <P>Write text to the Console Window.</P>
      *
      * @param message The text that you wish to write to the Console.
      *
      */

      public final void append(String message) 
      {

         console.append(message  + "\n");

      }


     /**
      * 
      * <P>Grab the text from the input box.</P>
      *
      * @return The text from the input box.
      *
      */

      public final String grabText() 
      {

         String retVal = command.getText();
         command.setText("");
         command.requestFocus();
         return retVal;

      }



}


#endif
