#include <windows.h>
#include <stdio.h>
#include "RSP LLE/Rsp_#1.1.h"
#include "audio.h"
#include "resource.h"
#include "settings.h"
#include "DxSound.h"

#define PLUGIN_VERSION "1.0"

#define AI_STATUS_FIFO_FULL	0x80000000		/* Bit 31: full */
#define AI_STATUS_DMA_BUSY	0x40000000		/* Bit 30: busy */
#define MI_INTR_AI			0x04			/* Bit 2: AI intr */

HINSTANCE			g_hInst = NULL;
BOOL				g_Initialize = FALSE;

DWORD				ReverseStereo = 0;

AUDIO_INFO			AudioInfo;
DxSoundContext		g_DxSoundContext;

DxSound				*g_pDxSound;
HANDLE				g_hAudioThread = NULL;

void				AudioThreadRoutine(HMODULE hInst); 

BOOL WINAPI DllMain(  HINSTANCE hinst, DWORD fdwReason, LPVOID lpvReserved )
{ 
	g_hInst = hinst;
	return TRUE;
}

EXPORT void CALL AiDacrateChanged (int SystemType) 
{
	DebugPrintf("AiDacrateChanged(%s)\n", (SystemType == SYSTEM_NTSC) ? "SYSTEM_NTSC" : 
										  (SystemType == SYSTEM_PAL)  ? "SYSTEM_PAL" : 
										  (SystemType == SYSTEM_MPAL) ? "SYSTEM_MPAL" : "????" );

	if (g_pDxSound == NULL)
	{
		DebugPrintf("WARNING: call AiDacrateChanged before InitiateAudio!\n");
		return;
	}

	DWORD Dacrate = *AudioInfo.AI_DACRATE_REG;

	if (Dacrate == 0) 
		Dacrate = 1;

	if ((g_DxSoundContext.Dacrate == Dacrate) && 
		(g_DxSoundContext.SystemType == SystemType))
		return;
	
	g_DxSoundContext.Dacrate    = Dacrate;
	g_DxSoundContext.SystemType = SystemType;

	switch (SystemType) 
	{
		case SYSTEM_NTSC:
			g_DxSoundContext.Frequency = 48681812 / g_DxSoundContext.Dacrate; 
			break;

		case SYSTEM_PAL:  
			g_DxSoundContext.Frequency = 49656530 / g_DxSoundContext.Dacrate; 
			break;
		
		case SYSTEM_MPAL: 
			g_DxSoundContext.Frequency = 48628316 / g_DxSoundContext.Dacrate; 
			break;

		default:
			g_DxSoundContext.Frequency = 48681812 / g_DxSoundContext.Dacrate; 
			break;
	
	}

	if (g_pDxSound->IsInitialized())
	{
		g_pDxSound->Stop();
		g_pDxSound->Deinit();
	}
	g_pDxSound->Init(g_DxSoundContext);
}


EXPORT void CALL AiLenChanged (void) 
{
	//DebugPrintf("AiLenChanged\n");
	if (*AudioInfo.AI_LEN_REG == 0)
		return;

	if ((g_pDxSound == NULL) || 
		(g_pDxSound->IsInitialized() == false)) 
	{
		*AudioInfo.AI_STATUS_REG &= ~AI_STATUS_FIFO_FULL;
		*AudioInfo.MI_INTR_REG |= MI_INTR_AI;
		AudioInfo.CheckInterrupts();
		return;
	}

	*AudioInfo.AI_STATUS_REG |= AI_STATUS_FIFO_FULL; 

	int Snd1Len = (*AudioInfo.AI_LEN_REG & 0x3FFF8);
	BYTE* Snd1ReadPos = AudioInfo.RDRAM + (*AudioInfo.AI_DRAM_ADDR_REG & 0x00FFFFF8);

	// move data to DxSound data queue
	g_pDxSound->ReceiveSndData(Snd1ReadPos, Snd1Len);
	g_pDxSound->DigestSndData();

	if (g_pDxSound->SndDateRemain() == 0)
	{
		*AudioInfo.AI_STATUS_REG &= ~AI_STATUS_FIFO_FULL;
		*AudioInfo.MI_INTR_REG |= MI_INTR_AI;
		AudioInfo.CheckInterrupts();
	}
}


EXPORT DWORD CALL AiReadLength() 
{
	//DebugPrintf("AiReadLength --> %d\n", Snd1Len);
	if (g_pDxSound)
		return g_pDxSound->SndDateRemain();

	return 0;
}


BOOL CALLBACK ConfigDialogProc(HWND hwndDlg, UINT message, WPARAM wParam, LPARAM lParam) 
{ 
	switch (message) 
    { 
		case WM_INITDIALOG:
			CheckDlgButton(hwndDlg, IDC_REVERSE_STEREO, ReverseStereo);
			break;
	
		case WM_COMMAND: 
            switch (LOWORD(wParam)) 
            { 
                case IDOK: 
					ReverseStereo = (SendDlgItemMessage( hwndDlg, IDC_REVERSE_STEREO, BM_GETCHECK, 0, 0) == BST_CHECKED);
					RegWriteDW("Settings", "ReverseStereo", ReverseStereo);
					if (g_pDxSound)
						g_pDxSound->ReverseStereo(ReverseStereo);
                    EndDialog(hwndDlg, wParam); 
                    return TRUE; 

				case IDCANCEL: 
                    EndDialog(hwndDlg, wParam); 
                    return TRUE; 

				case IDC_ABOUT:
					DllAbout(NULL);
					break;
            }
			break;

    } 
    return FALSE; 
} 

EXPORT void CALL DllConfig ( HWND hParent )
{
	DialogBox(g_hInst, MAKEINTRESOURCE(IDD_AUDIOOPTION), NULL, (DLGPROC)ConfigDialogProc);
}

EXPORT void CALL AiUpdate (BOOL Wait)
{
	Sleep(10);
}

void _AiUpdate (BOOL Wait)
{
	//DebugPrintf("AiUpdate(%s)\n", Wait ? "TRUE" : "FALSE");

	if ((g_pDxSound == NULL) || 
		(g_pDxSound->IsInitialized() == false))
	{
		Sleep(20);
		return;
	}

	g_pDxSound->DigestSndData();
	g_pDxSound->Play();
	g_pDxSound->UpdateSoundBuffer(Wait);

	if (g_pDxSound->SndDateRemain() == 0)
	{
		if (*AudioInfo.AI_STATUS_REG & AI_STATUS_FIFO_FULL)
		{
			*AudioInfo.AI_STATUS_REG &= ~AI_STATUS_FIFO_FULL;
			*AudioInfo.MI_INTR_REG |= MI_INTR_AI;
			AudioInfo.CheckInterrupts();
		}
	}
}

EXPORT void CALL CloseDLL (void)
{
	DebugPrintf("CloseDLL\n");

	if (!g_Initialize)
		return;

	if (g_hAudioThread != NULL)
	{
		TerminateThread(g_hAudioThread, 0);
		g_hAudioThread = NULL;
	}

	if (g_pDxSound != NULL)
	{
		delete g_pDxSound;
		g_pDxSound = NULL;
	}

	g_Initialize = FALSE;
}

EXPORT void CALL DllAbout ( HWND hParent ) 
{
	char Scratch[700];
	char Caption[0x80];

	sprintf(Caption, "About HLE Audio %s", PLUGIN_VERSION);

	sprintf(Scratch, "HLE Audio Plug-in 1.0 by Shunyuan\n\n"
		             "HLE aduio plug-in is a high level emulation audio plugin\n"
					 "that supports prebuffer streaming audio,\n"
					 "uses modified CXD4 LLE RSP core for audio rendering,\n"
					 "and uses DirectSound8 as output device.\n\n"
					 "Thanks CXD4 for his LLE RSP.\n");

	MessageBox (NULL, Scratch, Caption, MB_OK);
}


EXPORT void CALL GetDllInfo ( PLUGIN_INFO * PluginInfo )
{ 
	PluginInfo->Version = 0x0101;
	PluginInfo->Type = PLUGIN_TYPE_AUDIO;
	PluginInfo->MemoryBswaped = TRUE;
	sprintf(PluginInfo->Name, "shunyuan's HLE Audio %s", PLUGIN_VERSION);
}


EXPORT BOOL CALL InitiateAudio (AUDIO_INFO Audio_Info) 
{
	DebugPrintf("InitiateAudio\n");

	if (g_Initialize)
		DebugPrintf("WARNING: call InitiateAudio() twice before call CloseDLL!\n");

	ReverseStereo = FALSE;
	RegReadDW("Settings", "ReverseStereo", &ReverseStereo);

    AudioInfo = Audio_Info;

	g_DxSoundContext.hWnd		   = Audio_Info.hwnd;
	g_DxSoundContext.MemoryBswaped = Audio_Info.MemoryBswaped;
	g_DxSoundContext.Dacrate       = 0;
	g_DxSoundContext.SystemType    = 0;
	g_DxSoundContext.ReverseStereo = ReverseStereo;

	if (g_pDxSound != NULL)
	{
		delete g_pDxSound;
		g_pDxSound = NULL;
	}

	g_pDxSound = new DxSound;

	// initialize RSP for HLE 
	InitiateRSP(Audio_Info.RDRAM, Audio_Info.DMEM, Audio_Info.IMEM);

	if (g_hAudioThread != NULL)
	{
		TerminateThread(g_hAudioThread, 0);
		g_hAudioThread = NULL;
	}

	DWORD ThreadID;
	g_hAudioThread = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE) AudioThreadRoutine, (LPVOID)g_hInst, 0, &ThreadID);			

	g_Initialize = TRUE;

	return TRUE;
}

void AudioThreadRoutine(HMODULE hInst) 
{
	SetThreadPriority(GetCurrentThread(), THREAD_PRIORITY_TIME_CRITICAL );
	
	for (;;) 
	{ 
		_AiUpdate(true);
		Sleep(1);
	}
}


EXPORT void CALL ProcessAList(void) 
{
	//DebugPrintf("ProcessAList\n");
	RunRSP();
}

EXPORT void CALL RomClosed (void) 
{
	DebugPrintf("RomClosed\n");

	if (g_pDxSound)
	{
		g_pDxSound->Stop();
		g_pDxSound->Clear();
	}

	if (g_hAudioThread != NULL)
	{
		TerminateThread(g_hAudioThread, 0);
		g_hAudioThread = NULL;
	}
 
	*AudioInfo.AI_STATUS_REG &= ~AI_STATUS_FIFO_FULL;
	*AudioInfo.MI_INTR_REG |= MI_INTR_AI;
}



