/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.test;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.swing.UIManager;
import jpcsp.MainGUI;
import jpcsp.Memory;
import jpcsp.memory.FastMemory;
import jpcsp.memory.StandardMemory;
import jpcsp.util.Utilities;

public class MemoryTest {
    private String comment;
    private boolean success;

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MainGUI gui = new MainGUI();
        gui.setVisible(true);
        gui.getConsoleWindow().setVisible(true);
        MemoryTest memoryTest = new MemoryTest();
        memoryTest.run();
    }

    public void run() {
        Memory mem = Memory.getInstance();
        if (mem instanceof StandardMemory) {
            this.TestMemory(mem, "StandardMemory");
        } else {
            this.TestMemory(new StandardMemory(), "StandardMemory");
        }
        if (mem instanceof FastMemory) {
            this.TestMemory(mem, "FastMemory");
        } else {
            this.TestMemory(new FastMemory(), "FastMemory");
        }
    }

    public void log(String s) {
        System.out.println(s);
    }

    public void log(String comment, String s, boolean success) {
        this.log(String.format("    %-7s - %s - %s", success ? "SUCCESS" : "FAILED", comment, s));
    }

    public void success(String s) {
        this.log(this.comment, s, true);
    }

    public boolean fail(String s) {
        this.success = false;
        this.log(this.comment, s, this.success);
        return this.success;
    }

    public void startTest(String comment) {
        this.success = true;
        this.comment = comment;
        this.log("Starting Test " + comment);
    }

    public void endTest() {
        if (this.success) {
            this.log("Test " + this.comment + " terminated successfully.");
        } else {
            this.log("Test " + this.comment + " failed");
        }
    }

    public void TestMemory(Memory mem, String comment) {
        int b;
        int i;
        this.startTest(comment);
        if (mem == null) {
            this.fail("Memory could not be created");
            return;
        }
        if (!mem.allocate()) {
            this.fail("allocate");
            return;
        }
        this.success("allocate");
        boolean success = true;
        int address = 0x8000000;
        for (i = 0; i < 100; ++i) {
            mem.write8(address + i, (byte)i);
        }
        for (i = 0; i < 100; ++i) {
            b = mem.read8(address + i);
            if (b == i) continue;
            success = this.fail("write8/read8 " + i);
        }
        if (success) {
            this.success("write8/read8");
        }
        success = true;
        address = 0x8000000;
        for (i = 0; i < 10000; i += 2) {
            mem.write16(address + i, (short)i);
        }
        for (i = 0; i < 10000; i += 2) {
            b = mem.read16(address + i);
            if (b == i) continue;
            success = this.fail("write16/read16 " + i);
        }
        if (success) {
            this.success("write16/read16");
        }
        success = true;
        address = 0x8000000;
        for (i = 0; i < 100000; i += 4) {
            mem.write32(address + i, i);
        }
        for (i = 0; i < 100000; i += 4) {
            b = mem.read32(address + i);
            if (b == i) continue;
            success = this.fail("write32/read32 " + i);
        }
        if (success) {
            this.success("write32/read32");
        }
        success = true;
        address = 0x8000001;
        int data = 137;
        int limitData = 18;
        int length = 100;
        mem.write8(address - 1, (byte)limitData);
        mem.write8(address + length, (byte)limitData);
        mem.memset(address, (byte)data, length);
        for (int i2 = 0; i2 < length; ++i2) {
            int b2 = mem.read8(address + i2);
            if (b2 == data) continue;
            success = this.fail("memset " + i2);
        }
        if (mem.read8(address - 1) != limitData) {
            success = this.fail("memset lower limit");
        }
        if (mem.read8(address + length) != limitData) {
            success = this.fail("memset upper limit");
        }
        if (success) {
            this.success("memset");
        }
        success = true;
        if (Memory.isAddressGood(0x7FFFFFF)) {
            success = this.fail("isAddressGood START_RAM - 1");
        }
        if (!Memory.isAddressGood(0x8000000)) {
            success = this.fail("isAddressGood START_RAM");
        }
        if (Memory.isAddressGood(0)) {
            success = this.fail("isAddressGood 0");
        }
        if (success) {
            this.success("isAddressGood");
        }
        success = true;
        byte[] bytes = new byte[]{18, 35, 52, 69, 86, 103, 120, -119, -102};
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int length2 = bytes.length;
        int address2 = 0x8000001;
        int limitData2 = 17;
        mem.write8(address2 - 1, (byte)limitData2);
        mem.write8(address2 + length2, (byte)limitData2);
        mem.copyToMemory(address2, buffer, length2);
        for (int i3 = 0; i3 < length2; ++i3) {
            int b3 = mem.read8(address2 + i3);
            if (b3 == (bytes[i3] & 0xFF)) continue;
            success = this.fail("copyToMemory " + i3);
        }
        if (mem.read8(address2 - 1) != limitData2) {
            success = this.fail("copyToMemory lower limit");
        }
        if (mem.read8(address2 + length2) != limitData2) {
            success = this.fail("copyToMemory upper limit");
        }
        if (success) {
            this.success("copyToMemory");
        }
        success = true;
        bytes = new byte[]{18, 35, 52, 69, 86, 103, 120, -119, -102, -85, -68, -51};
        ByteBuffer referenceByteBuffer = ByteBuffer.wrap(bytes);
        length2 = bytes.length;
        address2 = 0x8000004;
        mem.copyToMemory(address2, referenceByteBuffer, length2);
        referenceByteBuffer.rewind();
        int[] ints = new int[]{1161044754, -1988597930, -843273318};
        IntBuffer referenceIntBuffer = IntBuffer.wrap(ints);
        Buffer buffer2 = mem.getBuffer(address2, length2);
        if (buffer2.capacity() * Utilities.bufferElementSize(buffer2) != length2) {
            success = this.fail("getBuffer capacity");
        }
        if (buffer2 instanceof ByteBuffer) {
            if (!referenceByteBuffer.equals(buffer2)) {
                success = this.fail("getBuffer Byte content");
            }
        } else if (buffer2 instanceof IntBuffer) {
            if (!referenceIntBuffer.equals(buffer2)) {
                success = this.fail("getBuffer Int content");
            }
        } else {
            success = this.fail("getBuffer unknown content");
        }
        if (success) {
            this.success("getBuffer");
        }
        success = true;
        mem.write32(0, 305419896);
        if (mem.read32(0) != 0) {
            success = this.fail("Invalid memory could be accessed");
        }
        mem.write32(-1887436768, 305419896);
        if (mem.read32(-1887436768) != 0) {
            success = this.fail("Invalid memory could be accessed");
        }
        if (success) {
            this.success("Check of Invalid memory access");
        }
        this.endTest();
    }
}

