/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.sound;

import jpcsp.HLE.modules150.sceAtrac3plus;
import jpcsp.Memory;
import jpcsp.connector.AtracCodec;
import jpcsp.sound.ISampleSource;

public class SampleSourceAtrac3
implements ISampleSource {
    private final sceAtrac3plus.AtracID id;
    private final AtracCodec codec;
    private final int maxSamples;
    private final int buffer;
    private int sampleIndex;
    private int currentSampleIndex;
    private int bufferedSamples;
    private final Memory mem;

    public SampleSourceAtrac3(sceAtrac3plus.AtracID id) {
        this.id = id;
        this.codec = id.getAtracCodec();
        this.maxSamples = id.getMaxSamples();
        id.createInternalBuffer(this.maxSamples * 4);
        this.buffer = id.getInternalBuffer().addr;
        this.sampleIndex = 0;
        this.bufferedSamples = 0;
        this.currentSampleIndex = -1;
        this.mem = Memory.getInstance();
    }

    private void decode() {
        this.bufferedSamples = this.codec.atracDecodeData(this.id.getAtracId(), this.buffer);
        this.sampleIndex = 0;
    }

    @Override
    public int getNextSample() {
        if (this.sampleIndex >= this.bufferedSamples) {
            this.decode();
            if (this.bufferedSamples <= 0) {
                return 0;
            }
        }
        int sample = this.mem.read32(this.buffer + (this.sampleIndex << 2));
        ++this.currentSampleIndex;
        ++this.sampleIndex;
        return sample;
    }

    @Override
    public void setSampleIndex(int index) {
    }

    @Override
    public int getSampleIndex() {
        return this.currentSampleIndex;
    }

    @Override
    public int getNumberSamples() {
        return this.id.getAtracEndSample();
    }
}

