/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.settings;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import jpcsp.Controller;
import jpcsp.Emulator;
import jpcsp.GUI.RecentElement;
import jpcsp.State;
import jpcsp.settings.ISettingsListener;
import jpcsp.settings.SettingsListenerInfo;
import jpcsp.util.Utilities;

public class Settings {
    private static final String SETTINGS_FILE_NAME = "Settings.properties";
    private static final String DEFAULT_SETTINGS_FILE_NAME = "/jpcsp/DefaultSettings.properties";
    private static Settings instance = null;
    private Properties defaultSettings;
    private SortedProperties loadedSettings;
    private Properties patchSettings;
    private HashMap<String, List<ISettingsListener>> listenersByKey = new HashMap();
    private List<SettingsListenerInfo> allListeners = new LinkedList<SettingsListenerInfo>();
    private Font loadedFont = null;

    public static Settings getInstance() {
        if (instance == null) {
            instance = new Settings();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Settings() {
        this.defaultSettings = new Properties();
        this.patchSettings = new Properties();
        InputStream defaultSettingsStream = null;
        BufferedInputStream loadedSettingsStream = null;
        try {
            defaultSettingsStream = this.getClass().getResourceAsStream(DEFAULT_SETTINGS_FILE_NAME);
            this.defaultSettings.load(defaultSettingsStream);
            this.loadedSettings = new SortedProperties(this.defaultSettings);
            File settingsFile = new File(SETTINGS_FILE_NAME);
            settingsFile.createNewFile();
            loadedSettingsStream = new BufferedInputStream(new FileInputStream(settingsFile));
            this.loadedSettings.load(loadedSettingsStream);
        }
        catch (FileNotFoundException e) {
            Emulator.log.error((Object)"Settings file not found:", (Throwable)e);
            Utilities.close(defaultSettingsStream, loadedSettingsStream);
        }
        catch (IOException e2) {
            Emulator.log.error((Object)"Problem loading settings:", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    Utilities.close(defaultSettingsStream, loadedSettingsStream);
                    throw throwable;
                }
            }
            Utilities.close(defaultSettingsStream, loadedSettingsStream);
        }
        Utilities.close(defaultSettingsStream, loadedSettingsStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void loadPatchSettings() {
        String key;
        Properties previousPatchSettings = new Properties(this.patchSettings);
        this.patchSettings.clear();
        String discId = State.discId;
        if (discId != "[unknown, file]" && discId != "[unknown, nothing loaded]") {
            String patchFileName = String.format("patches/%s.properties", discId);
            File patchFile = new File(patchFileName);
            BufferedInputStream patchSettingsStream = null;
            try {
                patchSettingsStream = new BufferedInputStream(new FileInputStream(patchFile));
                this.patchSettings.load(patchSettingsStream);
                Emulator.log.info((Object)String.format("Overwriting default settings with patch file '%s'", patchFileName));
            }
            catch (FileNotFoundException e) {
                Emulator.log.debug((Object)String.format("Patch file not found: %s", e.toString()));
                Utilities.close(patchSettingsStream);
            }
            catch (IOException e2) {
                Emulator.log.error((Object)"Problem loading patch:", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        Utilities.close(patchSettingsStream);
                        throw throwable;
                    }
                }
                Utilities.close(patchSettingsStream);
            }
            Utilities.close(patchSettingsStream);
        }
        Enumeration<Object> e = this.patchSettings.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement().toString();
            previousPatchSettings.remove(key);
            String value = this.patchSettings.getProperty(key);
            if (value.equals(this.loadedSettings.getProperty(key))) continue;
            this.triggerSettingsListener(key, value);
        }
        e = previousPatchSettings.keys();
        while (e.hasMoreElements()) {
            String newValue;
            key = e.nextElement().toString();
            String oldValue = previousPatchSettings.getProperty(key);
            if (oldValue.equals(newValue = this.getProperty(key))) continue;
            this.triggerSettingsListener(key, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void writeSettings() {
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(SETTINGS_FILE_NAME));
            this.loadedSettings.store(out, null);
        }
        catch (FileNotFoundException e) {
            Emulator.log.error((Object)"Settings file not found:", (Throwable)e);
            Utilities.close(out);
        }
        catch (IOException e2) {
            Emulator.log.error((Object)"Problem saving settings:", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    Utilities.close(out);
                    throw throwable;
                }
            }
            Utilities.close(out);
        }
        Utilities.close(out);
    }

    private String getProperty(String key) {
        String value = this.patchSettings.getProperty(key);
        if (value == null) {
            value = this.loadedSettings.getProperty(key);
        }
        return value;
    }

    private String getProperty(String key, String defaultValue) {
        String value = this.patchSettings.getProperty(key);
        if (value == null) {
            value = this.loadedSettings.getProperty(key, defaultValue);
        }
        return value;
    }

    private void setProperty(String key, String value) {
        String previousValue = this.getProperty(key);
        this.loadedSettings.setProperty(key, value);
        String newValue = this.getProperty(key);
        if (previousValue == null || !previousValue.equals(newValue)) {
            this.triggerSettingsListener(key, newValue);
        }
    }

    public Point readWindowPos(String windowname) {
        String x = this.getProperty("gui.windows." + windowname + ".x");
        String y = this.getProperty("gui.windows." + windowname + ".y");
        Point position = new Point();
        position.x = x != null ? Integer.parseInt(x) : 0;
        position.y = y != null ? Integer.parseInt(y) : 0;
        return position;
    }

    public Dimension readWindowSize(String windowname, int defaultWidth, int defaultHeight) {
        String w = this.getProperty("gui.windows." + windowname + ".w");
        String h = this.getProperty("gui.windows." + windowname + ".h");
        Dimension dimension = new Dimension();
        dimension.width = w != null ? Integer.parseInt(w) : defaultWidth;
        dimension.height = h != null ? Integer.parseInt(h) : defaultHeight;
        return dimension;
    }

    public void writeWindowPos(String windowname, Point pos) {
        this.setProperty("gui.windows." + windowname + ".x", Integer.toString(pos.x));
        this.setProperty("gui.windows." + windowname + ".y", Integer.toString(pos.y));
        this.writeSettings();
    }

    public void writeWindowSize(String windowname, Dimension dimension) {
        this.setProperty("gui.windows." + windowname + ".w", Integer.toString(dimension.width));
        this.setProperty("gui.windows." + windowname + ".h", Integer.toString(dimension.height));
        this.writeSettings();
    }

    public static boolean parseBool(String value) {
        return Integer.parseInt(value) != 0;
    }

    public static int parseInt(String value) {
        return Integer.parseInt(value);
    }

    public static float parseFloat(String value) {
        return Float.parseFloat(value);
    }

    public boolean readBool(String option) {
        String bool = this.getProperty(option);
        if (bool == null) {
            return false;
        }
        return Settings.parseBool(bool);
    }

    public int readInt(String option) {
        return this.readInt(option, 0);
    }

    public int readInt(String option, int defaultValue) {
        String value = this.getProperty(option);
        if (value == null) {
            return defaultValue;
        }
        return Settings.parseInt(value);
    }

    public void writeBool(String option, boolean value) {
        String state = value ? "1" : "0";
        this.setProperty(option, state);
        this.writeSettings();
    }

    public void writeInt(String option, int value) {
        String state = Integer.toString(value);
        this.setProperty(option, state);
        this.writeSettings();
    }

    public String readString(String option) {
        return this.readString(option, "");
    }

    public String readString(String option, String defaultValue) {
        return this.getProperty(option, defaultValue);
    }

    public boolean isOptionFromPatch(String option) {
        return this.patchSettings.containsKey(option);
    }

    public void writeString(String option, String value) {
        this.setProperty(option, value);
        this.writeSettings();
    }

    public void writeFloat(String option, float value) {
        String state = Float.toString(value);
        this.setProperty(option, state);
        this.writeSettings();
    }

    public float readFloat(String option, float defaultValue) {
        String value = this.getProperty(option);
        if (value == null) {
            return defaultValue;
        }
        return Settings.parseFloat(value);
    }

    public HashMap<Integer, Controller.keyCode> loadKeys() {
        HashMap<Integer, Controller.keyCode> m = new HashMap<Integer, Controller.keyCode>(22);
        m.put(this.readKey("up"), Controller.keyCode.UP);
        m.put(this.readKey("down"), Controller.keyCode.DOWN);
        m.put(this.readKey("left"), Controller.keyCode.LEFT);
        m.put(this.readKey("right"), Controller.keyCode.RIGHT);
        m.put(this.readKey("analogUp"), Controller.keyCode.ANUP);
        m.put(this.readKey("analogDown"), Controller.keyCode.ANDOWN);
        m.put(this.readKey("analogLeft"), Controller.keyCode.ANLEFT);
        m.put(this.readKey("analogRight"), Controller.keyCode.ANRIGHT);
        m.put(this.readKey("start"), Controller.keyCode.START);
        m.put(this.readKey("select"), Controller.keyCode.SELECT);
        m.put(this.readKey("triangle"), Controller.keyCode.TRIANGLE);
        m.put(this.readKey("square"), Controller.keyCode.SQUARE);
        m.put(this.readKey("circle"), Controller.keyCode.CIRCLE);
        m.put(this.readKey("cross"), Controller.keyCode.CROSS);
        m.put(this.readKey("lTrigger"), Controller.keyCode.L1);
        m.put(this.readKey("rTrigger"), Controller.keyCode.R1);
        m.put(this.readKey("home"), Controller.keyCode.HOME);
        m.put(this.readKey("hold"), Controller.keyCode.HOLD);
        m.put(this.readKey("volPlus"), Controller.keyCode.VOLPLUS);
        m.put(this.readKey("volMin"), Controller.keyCode.VOLMIN);
        m.put(this.readKey("screen"), Controller.keyCode.SCREEN);
        m.put(this.readKey("music"), Controller.keyCode.MUSIC);
        return m;
    }

    public HashMap<Controller.keyCode, String> loadController() {
        HashMap<Controller.keyCode, String> m = new HashMap<Controller.keyCode, String>(22);
        m.put(Controller.keyCode.UP, this.readController("up"));
        m.put(Controller.keyCode.DOWN, this.readController("down"));
        m.put(Controller.keyCode.LEFT, this.readController("left"));
        m.put(Controller.keyCode.RIGHT, this.readController("right"));
        m.put(Controller.keyCode.ANUP, this.readController("analogUp"));
        m.put(Controller.keyCode.ANDOWN, this.readController("analogDown"));
        m.put(Controller.keyCode.ANLEFT, this.readController("analogLeft"));
        m.put(Controller.keyCode.ANRIGHT, this.readController("analogRight"));
        m.put(Controller.keyCode.START, this.readController("start"));
        m.put(Controller.keyCode.SELECT, this.readController("select"));
        m.put(Controller.keyCode.TRIANGLE, this.readController("triangle"));
        m.put(Controller.keyCode.SQUARE, this.readController("square"));
        m.put(Controller.keyCode.CIRCLE, this.readController("circle"));
        m.put(Controller.keyCode.CROSS, this.readController("cross"));
        m.put(Controller.keyCode.L1, this.readController("lTrigger"));
        m.put(Controller.keyCode.R1, this.readController("rTrigger"));
        m.put(Controller.keyCode.HOME, this.readController("home"));
        m.put(Controller.keyCode.HOLD, this.readController("hold"));
        m.put(Controller.keyCode.VOLPLUS, this.readController("volPlus"));
        m.put(Controller.keyCode.VOLMIN, this.readController("volMin"));
        m.put(Controller.keyCode.SCREEN, this.readController("screen"));
        m.put(Controller.keyCode.MUSIC, this.readController("music"));
        for (Controller.keyCode key : Controller.keyCode.values()) {
            if (m.get((Object)key) != null) continue;
            m.remove((Object)key);
        }
        return m;
    }

    public void writeKeys(HashMap<Integer, Controller.keyCode> keys) {
        for (Map.Entry<Integer, Controller.keyCode> entry : keys.entrySet()) {
            Controller.keyCode key = entry.getValue();
            int value = entry.getKey();
            switch (key) {
                case DOWN: {
                    this.writeKey("down", value);
                    break;
                }
                case UP: {
                    this.writeKey("up", value);
                    break;
                }
                case LEFT: {
                    this.writeKey("left", value);
                    break;
                }
                case RIGHT: {
                    this.writeKey("right", value);
                    break;
                }
                case ANDOWN: {
                    this.writeKey("analogDown", value);
                    break;
                }
                case ANUP: {
                    this.writeKey("analogUp", value);
                    break;
                }
                case ANLEFT: {
                    this.writeKey("analogLeft", value);
                    break;
                }
                case ANRIGHT: {
                    this.writeKey("analogRight", value);
                    break;
                }
                case TRIANGLE: {
                    this.writeKey("triangle", value);
                    break;
                }
                case SQUARE: {
                    this.writeKey("square", value);
                    break;
                }
                case CIRCLE: {
                    this.writeKey("circle", value);
                    break;
                }
                case CROSS: {
                    this.writeKey("cross", value);
                    break;
                }
                case L1: {
                    this.writeKey("lTrigger", value);
                    break;
                }
                case R1: {
                    this.writeKey("rTrigger", value);
                    break;
                }
                case START: {
                    this.writeKey("start", value);
                    break;
                }
                case SELECT: {
                    this.writeKey("select", value);
                    break;
                }
                case HOME: {
                    this.writeKey("home", value);
                    break;
                }
                case HOLD: {
                    this.writeKey("hold", value);
                    break;
                }
                case VOLMIN: {
                    this.writeKey("volMin", value);
                    break;
                }
                case VOLPLUS: {
                    this.writeKey("volPlus", value);
                    break;
                }
                case SCREEN: {
                    this.writeKey("screen", value);
                    break;
                }
                case MUSIC: {
                    this.writeKey("music", value);
                }
            }
        }
        this.writeSettings();
    }

    public void writeController(HashMap<Controller.keyCode, String> keys) {
        for (Map.Entry<Controller.keyCode, String> entry : keys.entrySet()) {
            Controller.keyCode key = entry.getKey();
            String value = entry.getValue();
            switch (key) {
                case DOWN: {
                    this.writeController("down", value);
                    break;
                }
                case UP: {
                    this.writeController("up", value);
                    break;
                }
                case LEFT: {
                    this.writeController("left", value);
                    break;
                }
                case RIGHT: {
                    this.writeController("right", value);
                    break;
                }
                case ANDOWN: {
                    this.writeController("analogDown", value);
                    break;
                }
                case ANUP: {
                    this.writeController("analogUp", value);
                    break;
                }
                case ANLEFT: {
                    this.writeController("analogLeft", value);
                    break;
                }
                case ANRIGHT: {
                    this.writeController("analogRight", value);
                    break;
                }
                case TRIANGLE: {
                    this.writeController("triangle", value);
                    break;
                }
                case SQUARE: {
                    this.writeController("square", value);
                    break;
                }
                case CIRCLE: {
                    this.writeController("circle", value);
                    break;
                }
                case CROSS: {
                    this.writeController("cross", value);
                    break;
                }
                case L1: {
                    this.writeController("lTrigger", value);
                    break;
                }
                case R1: {
                    this.writeController("rTrigger", value);
                    break;
                }
                case START: {
                    this.writeController("start", value);
                    break;
                }
                case SELECT: {
                    this.writeController("select", value);
                    break;
                }
                case HOME: {
                    this.writeController("home", value);
                    break;
                }
                case HOLD: {
                    this.writeController("hold", value);
                    break;
                }
                case VOLMIN: {
                    this.writeController("volMin", value);
                    break;
                }
                case VOLPLUS: {
                    this.writeController("volPlus", value);
                    break;
                }
                case SCREEN: {
                    this.writeController("screen", value);
                    break;
                }
                case MUSIC: {
                    this.writeController("music", value);
                }
            }
        }
        this.writeSettings();
    }

    private int readKey(String keyName) {
        String str = this.getProperty("keys." + keyName);
        if (str == null) {
            return 0;
        }
        return Integer.parseInt(str);
    }

    private void writeKey(String keyName, int key) {
        this.setProperty("keys." + keyName, Integer.toString(key));
    }

    private String readController(String name) {
        return this.getProperty("controller." + name);
    }

    private void writeController(String name, String value) {
        this.setProperty("controller." + name, value);
    }

    public void readRecent(String cat, List<RecentElement> recent) {
        String r;
        int i = 0;
        while ((r = this.getProperty("gui.recent." + cat + "." + i)) != null) {
            String title = this.getProperty("gui.recent." + cat + "." + i + ".title");
            recent.add(new RecentElement(r, title));
            ++i;
        }
    }

    public void writeRecent(String cat, List<RecentElement> recent) {
        Enumeration keys = this.loadedSettings.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!key.startsWith("gui.recent." + cat)) continue;
            this.loadedSettings.remove(key);
        }
        int index = 0;
        for (RecentElement elem : recent) {
            this.setProperty("gui.recent." + cat + "." + index, elem.path);
            if (elem.title != null) {
                this.setProperty("gui.recent." + cat + "." + index + ".title", elem.title);
            }
            ++index;
        }
        this.writeSettings();
    }

    public Font getFont() {
        if (this.loadedFont != null) {
            return this.loadedFont;
        }
        Font font = new Font("SansSerif", 0, 1);
        int fontsize = 11;
        try {
            Font base = font;
            String fontname = this.readString("gui.font.name");
            String fontfilename = this.readString("gui.font.file");
            String fontsizestr = this.readString("gui.font.size");
            if (fontfilename.length() != 0) {
                File fontfile = new File(fontfilename);
                if (fontfile.exists()) {
                    base = Font.createFont(0, fontfile);
                } else {
                    System.err.println("gui.font.file '" + fontfilename + "' doesn't exist.");
                }
            } else if (fontname.length() != 0) {
                base = new Font(fontname, 0, 1);
            }
            if (fontsizestr.length() > 0) {
                fontsize = Integer.parseInt(fontsizestr);
            } else {
                System.err.println("gui.font.size setting is missing.");
            }
            font = base.deriveFont(0, fontsize);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(base);
        }
        catch (NumberFormatException e) {
            System.err.println("gui.font.size setting is invalid.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
        this.loadedFont = font;
        return font;
    }

    public void registerSettingsListener(String name, String option, ISettingsListener listener) {
        this.removeSettingsListener(name, option);
        SettingsListenerInfo info = new SettingsListenerInfo(name, option, listener);
        this.allListeners.add(info);
        List<ISettingsListener> listenersForKey = this.listenersByKey.get(option);
        if (listenersForKey == null) {
            listenersForKey = new LinkedList<ISettingsListener>();
            this.listenersByKey.put(option, listenersForKey);
        }
        listenersForKey.add(listener);
        String value = this.getProperty(option);
        if (value != null) {
            listener.settingsValueChanged(option, value);
        }
    }

    public void removeSettingsListener(String name, String option) {
        ListIterator<SettingsListenerInfo> lit = this.allListeners.listIterator();
        while (lit.hasNext()) {
            SettingsListenerInfo info = lit.next();
            if (!info.equals(name, option)) continue;
            lit.remove();
            String key = info.getKey();
            List<ISettingsListener> listenersForKey = this.listenersByKey.get(key);
            listenersForKey.remove(info.getListener());
            if (!listenersForKey.isEmpty()) continue;
            this.listenersByKey.remove(key);
        }
    }

    public void removeSettingsListener(String name) {
        this.removeSettingsListener(name, null);
    }

    private void triggerSettingsListener(String key, String value) {
        List<ISettingsListener> listenersForKey = this.listenersByKey.get(key);
        if (listenersForKey != null) {
            for (ISettingsListener listener : listenersForKey) {
                listener.settingsValueChanged(key, value);
            }
        }
    }

    private static class SortedProperties
    extends Properties {
        private static final long serialVersionUID = -8127868945637348944L;

        public SortedProperties(Properties defaultSettings) {
            super(defaultSettings);
        }

        @Override
        public synchronized Enumeration keys() {
            Enumeration<Object> keysEnum = super.keys();
            ArrayList<Object> keyList = Collections.list(keysEnum);
            Collections.sort(keyList);
            return Collections.enumeration(keyList);
        }
    }
}

