/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.jpcsp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.HashSet;
import java.util.Set;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.Memory;
import jpcsp.network.INetworkAdapter;
import jpcsp.network.adhoc.AdhocDatagramSocket;
import jpcsp.network.adhoc.AdhocMessage;
import jpcsp.network.adhoc.AdhocSocket;
import jpcsp.network.adhoc.PtpObject;
import jpcsp.network.jpcsp.JpcspAdhocPtpMessage;

public class JpcspPtpObject
extends PtpObject {
    private JpcspAdhocPtpMessage connectRequest;
    private int connectRequestPort;
    private JpcspAdhocPtpMessage connectConfirm;
    private boolean connected;
    private Set<Integer> acceptedIds = new HashSet<Integer>();

    public JpcspPtpObject(PtpObject ptpObject) {
        super(ptpObject);
    }

    public JpcspPtpObject(INetworkAdapter networkAdapter) {
        super(networkAdapter);
    }

    @Override
    public boolean canAccept() {
        return this.connectRequest != null;
    }

    @Override
    public boolean canConnect() {
        return this.connectConfirm != null;
    }

    @Override
    public int connect(int timeout, int nonblock) {
        int result = 0;
        try {
            JpcspAdhocPtpMessage adhocPtpMessage = new JpcspAdhocPtpMessage(1);
            adhocPtpMessage.setDataInt32(this.getId());
            this.send(adhocPtpMessage);
            result = super.connect(timeout, nonblock);
        }
        catch (SocketException e) {
            log.error((Object)"connect", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"connect", (Throwable)e);
        }
        return result;
    }

    @Override
    protected boolean pollAccept(int peerMacAddr, int peerPortAddr, SceKernelThreadInfo thread) {
        boolean acceptCompleted = false;
        Memory mem = Memory.getInstance();
        try {
            JpcspAdhocPtpMessage adhocPtpMessage = this.connectRequest;
            int adhocPtpMessagePort = this.connectRequestPort;
            if (adhocPtpMessage == null) {
                byte[] bytes = new byte[this.getBufSize() + 13];
                int length = this.socket.receive(bytes, bytes.length);
                adhocPtpMessage = new JpcspAdhocPtpMessage(bytes, length);
                adhocPtpMessagePort = this.socket.getReceivedPort();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("pollAccept: received message %s", adhocPtpMessage));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)String.format("pollAccept: processing pending message %s", adhocPtpMessage));
            }
            if (adhocPtpMessage.isForMe()) {
                switch (adhocPtpMessage.getType()) {
                    case 1: {
                        int acceptedId = adhocPtpMessage.getDataInt32();
                        if (this.acceptedIds.contains(acceptedId)) {
                            if (!log.isDebugEnabled()) break;
                            log.debug((Object)String.format("Connect message received for an id=%d already accepted. Dropping message.", acceptedId));
                            break;
                        }
                        pspNetMacAddress peerMacAddress = new pspNetMacAddress();
                        peerMacAddress.setMacAddress(adhocPtpMessage.getFromMacAddress());
                        int peerPort = Modules.sceNetAdhocModule.getClientPortFromRealPort(adhocPtpMessage.getFromMacAddress(), adhocPtpMessagePort);
                        if (peerMacAddr != 0) {
                            peerMacAddress.write(mem, peerMacAddr);
                        }
                        if (peerPortAddr != 0) {
                            mem.write16(peerPortAddr, (short)peerPort);
                        }
                        JpcspPtpObject ptpObject = new JpcspPtpObject(this);
                        ptpObject.setDestMacAddress(peerMacAddress);
                        ptpObject.setDestPort(peerPort);
                        ptpObject.setPort(0);
                        Modules.sceNetAdhocModule.hleAddPtpObject(ptpObject);
                        JpcspPtpObject.setReturnValue(thread, ptpObject.getId());
                        this.acceptedIds.add(acceptedId);
                        ptpObject.setPort(0);
                        ptpObject.openSocket();
                        JpcspAdhocPtpMessage confirmMessage = new JpcspAdhocPtpMessage(2);
                        confirmMessage.setDataInt32(ptpObject.getPort());
                        ptpObject.send(confirmMessage);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("accept completed, creating new Ptp object %s", ptpObject));
                        }
                        acceptCompleted = true;
                        this.connectRequest = null;
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)String.format("pollAccept: received a message not for me: %s", adhocPtpMessage));
            }
        }
        catch (SocketException e) {
            log.error((Object)"pollAccept", (Throwable)e);
        }
        catch (SocketTimeoutException e) {
        }
        catch (IOException e) {
            log.error((Object)"pollAccept", (Throwable)e);
        }
        return acceptCompleted;
    }

    @Override
    protected boolean pollConnect(SceKernelThreadInfo thread) {
        boolean connectCompleted = false;
        try {
            JpcspAdhocPtpMessage adhocPtpMessage = this.connectConfirm;
            if (adhocPtpMessage == null) {
                byte[] bytes = new byte[this.getBufSize() + 13];
                int length = this.socket.receive(bytes, bytes.length);
                adhocPtpMessage = new JpcspAdhocPtpMessage(bytes, length);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("pollConnect: received message %s", adhocPtpMessage));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)String.format("pollConnect: processing pending message %s", adhocPtpMessage));
            }
            if (adhocPtpMessage.isForMe()) {
                switch (adhocPtpMessage.getType()) {
                    case 2: {
                        int port = Modules.sceNetAdhocModule.getClientPortFromRealPort(adhocPtpMessage.getFromMacAddress(), adhocPtpMessage.getDataInt32());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Received connect confirmation, changing destination port from %d to %d", this.getDestPort(), port));
                        }
                        this.setDestPort(port);
                        JpcspPtpObject.setReturnValue(thread, 0);
                        this.connectConfirm = null;
                        connectCompleted = true;
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)String.format("pollConnect: received a message not for me: %s", adhocPtpMessage));
            }
        }
        catch (SocketException e) {
            log.error((Object)"pollConnect", (Throwable)e);
        }
        catch (SocketTimeoutException e) {
        }
        catch (IOException e) {
            log.error((Object)"pollConnect", (Throwable)e);
        }
        if (connectCompleted) {
            this.connected = true;
        }
        return connectCompleted;
    }

    @Override
    protected boolean isForMe(AdhocMessage adhocMessage, int port, InetAddress address) {
        if (adhocMessage instanceof JpcspAdhocPtpMessage) {
            JpcspAdhocPtpMessage adhocPtpMessage = (JpcspAdhocPtpMessage)adhocMessage;
            int type = adhocPtpMessage.getType();
            if (type == 2) {
                if (this.connected) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Received connect confirmation but already connected, discarding", new Object[0]));
                    }
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Received connect confirmation, processing later", new Object[0]));
                    }
                    this.connectConfirm = adhocPtpMessage;
                }
                return false;
            }
            if (type == 1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Received connect request, processing later", new Object[0]));
                }
                this.connectRequest = adhocPtpMessage;
                this.connectRequestPort = port;
                return false;
            }
            if (type != 3) {
                return false;
            }
        }
        return super.isForMe(adhocMessage, port, address);
    }

    @Override
    protected void closeSocket() {
        super.closeSocket();
        this.connected = false;
    }

    @Override
    protected AdhocSocket createSocket() {
        return new AdhocDatagramSocket();
    }
}

