/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;

public class DirectBufferMemory
extends Memory {
    private ByteBuffer byteBuffer;
    private ShortBuffer shortBuffer;
    private IntBuffer intBuffer;
    private static final int clearBufferSize = 10240;
    private ByteBuffer clearBuffer;

    @Override
    public boolean allocate() {
        try {
            this.byteBuffer = ByteBuffer.allocateDirect(MemoryMap.END_RAM + 1).order(ByteOrder.LITTLE_ENDIAN);
            this.intBuffer = this.byteBuffer.asIntBuffer();
            this.shortBuffer = this.byteBuffer.asShortBuffer();
            this.clearBuffer = ByteBuffer.allocateDirect(10240).order(this.byteBuffer.order());
        }
        catch (OutOfMemoryError e) {
            Memory.log.warn((Object)"Cannot allocate DirectBufferMemory: add the option '-Xmx256m' to the Java Virtual Machine startup command to improve Performance");
            Memory.log.info((Object)("The current Java Virtual Machine has been started using '-Xmx" + Runtime.getRuntime().maxMemory() / 0x100000L + "m'"));
            return false;
        }
        return super.allocate();
    }

    @Override
    public void Initialise() {
        int i;
        this.byteBuffer.clear();
        this.intBuffer.clear();
        this.shortBuffer.clear();
        this.clearBuffer.clear();
        for (i = 0; i < 10240; ++i) {
            this.clearBuffer.put((byte)0);
        }
        this.clearBuffer.clear();
        for (i = 0; i < MemoryMap.END_RAM; i += 10240) {
            this.byteBuffer.put(this.clearBuffer);
        }
        this.clearBuffer.clear();
        this.byteBuffer.clear();
    }

    private static ByteBuffer slice(ByteBuffer buffer) {
        return buffer.slice().order(buffer.order());
    }

    @Override
    public void copyToMemory(int address, ByteBuffer source, int length) {
        source = DirectBufferMemory.slice(source);
        source.limit(length);
        ByteBuffer mem = DirectBufferMemory.slice(this.byteBuffer);
        mem.position(address &= 0x3FFFFFFF);
        mem.put(source);
    }

    protected ByteBuffer getByteBuffer(int address, int length) {
        ByteBuffer mem = DirectBufferMemory.slice(this.byteBuffer);
        mem.position(address &= 0x3FFFFFFF);
        mem.limit(address + length);
        return DirectBufferMemory.slice(mem);
    }

    @Override
    public Buffer getBuffer(int address, int length) {
        return this.getByteBuffer(address, length);
    }

    @Override
    public Buffer getMainMemoryByteBuffer() {
        return DirectBufferMemory.slice(this.byteBuffer);
    }

    @Override
    protected void memcpy(int destination, int source, int length, boolean checkOverlap) {
        destination = this.normalizeAddress(destination);
        source = this.normalizeAddress(source);
        if (checkOverlap || !this.areOverlapping(destination, source, length)) {
            ByteBuffer destinationBuffer = this.getByteBuffer(destination, length);
            ByteBuffer sourceBuffer = this.getByteBuffer(source, length);
            destinationBuffer.put(sourceBuffer);
        } else {
            IMemoryReader sourceReader = MemoryReader.getMemoryReader(source, length, 1);
            for (int i = 0; i < length; ++i) {
                this.write8(destination + i, (byte)sourceReader.readNext());
            }
        }
    }

    @Override
    public void memset(int address, byte data, int length) {
        ByteBuffer source;
        ByteBuffer destination = this.getByteBuffer(address, length);
        if (data == 0) {
            source = DirectBufferMemory.slice(this.clearBuffer);
        } else {
            source = ByteBuffer.allocateDirect(10240);
            for (int i = 0; i < 10240; ++i) {
                source.put(data);
            }
            source.clear();
        }
        while (length >= 10240) {
            destination.put(source);
            source.clear();
            length -= 10240;
        }
        if (length > 0) {
            source.limit(length);
            destination.put(source);
        }
    }

    @Override
    public int read16(int address) {
        return this.shortBuffer.get((address &= 0x3FFFFFFF) >> 1) & 0xFFFF;
    }

    @Override
    public int read32(int address) {
        return this.intBuffer.get((address &= 0x3FFFFFFF) >> 2);
    }

    @Override
    public int read8(int address) {
        return this.byteBuffer.get(address &= 0x3FFFFFFF) & 0xFF;
    }

    @Override
    public void write16(int address, short data) {
        this.shortBuffer.put((address &= 0x3FFFFFFF) >> 1, data);
    }

    @Override
    public void write32(int address, int data) {
        this.intBuffer.put((address &= 0x3FFFFFFF) >> 2, data);
    }

    @Override
    public void write8(int address, byte data) {
        this.byteBuffer.put(address &= 0x3FFFFFFF, data);
    }
}

