/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.log;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintStream;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import jpcsp.log.LoggingOutputStream;
import jpcsp.log.TextPaneAppender;
import jpcsp.settings.Settings;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class LogWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static String confFile = "LogSettings.xml";
    private String[] loglevels = new String[]{"ALL", "TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL", "OFF"};
    private JTextPane textPane;

    public LogWindow() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Logger");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                if (Settings.getInstance().readBool("gui.saveWindowPos")) {
                    Settings.getInstance().writeWindowPos("logwindow", LogWindow.this.getLocation());
                    Settings.getInstance().writeWindowSize("logwindow", LogWindow.this.getSize());
                }
            }
        });
        this.textPane = new JTextPane();
        JScrollPane scrollPane = new JScrollPane(this.textPane);
        TextPaneAppender textPaneAppender = (TextPaneAppender)Logger.getRootLogger().getAppender("JpcspAppender");
        if (textPaneAppender != null) {
            textPaneAppender.setTextPane(this.textPane);
        }
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogWindow.this.clearScreenMessages();
            }
        });
        JLabel loglevellabel = new JLabel("Choose Log Level");
        final JComboBox<String> loglevelcombo = new JComboBox<String>(this.loglevels);
        final Logger rootLogger = Logger.getRootLogger();
        Level getlevelfromconfig = rootLogger.getLevel();
        if (getlevelfromconfig.equals((Object)Level.ALL)) {
            loglevelcombo.setSelectedIndex(0);
        }
        if (getlevelfromconfig.equals((Object)Level.TRACE)) {
            loglevelcombo.setSelectedIndex(1);
        }
        if (getlevelfromconfig.equals((Object)Level.DEBUG)) {
            loglevelcombo.setSelectedIndex(2);
        }
        if (getlevelfromconfig.equals((Object)Level.INFO)) {
            loglevelcombo.setSelectedIndex(3);
        }
        if (getlevelfromconfig.equals((Object)Level.WARN)) {
            loglevelcombo.setSelectedIndex(4);
        }
        if (getlevelfromconfig.equals((Object)Level.ERROR)) {
            loglevelcombo.setSelectedIndex(5);
        }
        if (getlevelfromconfig.equals((Object)Level.FATAL)) {
            loglevelcombo.setSelectedIndex(6);
        }
        if (getlevelfromconfig.equals((Object)Level.OFF)) {
            loglevelcombo.setSelectedIndex(7);
        }
        loglevelcombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    if (itemEvent.getItem().equals("ALL")) {
                        rootLogger.setLevel(Level.ALL);
                    }
                    if (itemEvent.getItem().equals("TRACE")) {
                        rootLogger.setLevel(Level.TRACE);
                    }
                    if (itemEvent.getItem().equals("DEBUG")) {
                        rootLogger.setLevel(Level.DEBUG);
                    }
                    if (itemEvent.getItem().equals("WARN")) {
                        rootLogger.setLevel(Level.WARN);
                    }
                    if (itemEvent.getItem().equals("INFO")) {
                        rootLogger.setLevel(Level.INFO);
                    }
                    if (itemEvent.getItem().equals("ERROR")) {
                        rootLogger.setLevel(Level.ERROR);
                    }
                    if (itemEvent.getItem().equals("FATAL")) {
                        rootLogger.setLevel(Level.FATAL);
                    }
                    if (itemEvent.getItem().equals("OFF")) {
                        rootLogger.setLevel(Level.OFF);
                    }
                }
            }
        });
        loglevelcombo.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent wheelEvent) {
                switch (wheelEvent.getWheelRotation()) {
                    case 1: {
                        if (loglevelcombo.getSelectedIndex() == 7) break;
                        loglevelcombo.setSelectedIndex(loglevelcombo.getSelectedIndex() + 1);
                        break;
                    }
                    case -1: {
                        if (loglevelcombo.getSelectedIndex() == 0) break;
                        loglevelcombo.setSelectedIndex(loglevelcombo.getSelectedIndex() - 1);
                        break;
                    }
                }
            }
        });
        GroupLayout layout = new GroupLayout(this.getRootPane());
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(scrollPane).addGroup(layout.createSequentialGroup().addComponent(loglevellabel).addComponent(loglevelcombo).addComponent(clearButton)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(scrollPane).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(loglevellabel).addComponent(loglevelcombo).addComponent(clearButton)));
        this.setSize(Settings.getInstance().readWindowSize("logwindow", 500, 300));
        this.getRootPane().setLayout(layout);
    }

    public static void setConfXMLFile(String path) {
        confFile = path;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.setProperty("log4j.properties", confFile);
        DOMConfigurator.configure((String)confFile);
        System.setOut(new PrintStream(new LoggingOutputStream(Logger.getLogger((String)"sysout"), Level.INFO)));
        new LogWindow().setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearScreenMessages() {
        JTextPane jTextPane = this.textPane;
        synchronized (jTextPane) {
            this.textPane.setText("");
        }
    }
}

