/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.util.Utilities;

public class Elf32ProgramHeader {
    private long p_type;
    private long p_offset;
    private long p_vaddr;
    private long p_paddr;
    private long p_filesz;
    private long p_memsz;
    private long p_flags;
    private long p_align;

    public static int sizeof() {
        return 32;
    }

    public Elf32ProgramHeader(ByteBuffer f) throws IOException {
        this.read(f);
    }

    private void read(ByteBuffer f) throws IOException {
        this.p_type = Utilities.readUWord(f);
        this.p_offset = Utilities.readUWord(f);
        this.p_vaddr = Utilities.readUWord(f);
        this.p_paddr = Utilities.readUWord(f);
        this.p_filesz = Utilities.readUWord(f);
        this.p_memsz = Utilities.readUWord(f);
        this.p_flags = Utilities.readUWord(f);
        this.p_align = Utilities.readUWord(f);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("p_type \t\t " + Utilities.formatString("long", Long.toHexString(this.getP_type() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_offset \t " + Utilities.formatString("long", Long.toHexString(this.getP_offset() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_vaddr \t " + Utilities.formatString("long", Long.toHexString(this.getP_vaddr() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_paddr \t " + Utilities.formatString("long", Long.toHexString(this.getP_paddr() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_filesz \t " + Utilities.formatString("long", Long.toHexString(this.getP_filesz() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_memsz \t " + Utilities.formatString("long", Long.toHexString(this.getP_memsz() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_flags \t " + Utilities.formatString("long", Long.toHexString(this.getP_flags() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_align \t " + Utilities.formatString("long", Long.toHexString(this.getP_align() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        return str.toString();
    }

    public long getP_type() {
        return this.p_type;
    }

    public long getP_offset() {
        return this.p_offset;
    }

    public long getP_vaddr() {
        return this.p_vaddr;
    }

    public long getP_paddr() {
        return this.p_paddr;
    }

    public long getP_filesz() {
        return this.p_filesz;
    }

    public long getP_memsz() {
        return this.p_memsz;
    }

    public long getP_flags() {
        return this.p_flags;
    }

    public long getP_align() {
        return this.p_align;
    }
}

