/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import jpcsp.Memory;

public class DeferredStub {
    private String moduleName;
    private int importAddress;
    private int nid;

    public DeferredStub(String moduleName, int importAddress, int nid) {
        this.moduleName = moduleName;
        this.importAddress = importAddress;
        this.nid = nid;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public int getImportAddress() {
        return this.importAddress;
    }

    public int getNid() {
        return this.nid;
    }

    public void resolve(Memory mem, int address) {
        int instruction = 0x8000000 | address >>> 2 & 0x3FFFFFF;
        mem.write32(this.importAddress, instruction);
        mem.write32(this.importAddress + 4, 0);
    }

    public String toString() {
        return String.format("0x%08X [0x%08X] Module '%s'", this.getImportAddress(), this.getNid(), this.getModuleName());
    }
}

