/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.filesystems.umdiso.iso9660;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jpcsp.filesystems.umdiso.UmdIsoFile;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.filesystems.umdiso.iso9660.Iso9660File;

public class Iso9660Directory {
    private List<Iso9660File> files;

    public Iso9660Directory(UmdIsoReader r, int directorySector, int directorySize) throws IOException {
        UmdIsoFile dataStream = new UmdIsoFile(r, directorySector, directorySize, null, null);
        this.files = new ArrayList<Iso9660File>();
        while (directorySize >= 1) {
            int entryLength = dataStream.read();
            if (entryLength == 0) {
                --directorySize;
                continue;
            }
            directorySize -= entryLength;
            byte[] b = new byte[entryLength - 1];
            dataStream.read(b);
            Iso9660File file = new Iso9660File(b, b.length);
            this.files.add(file);
        }
    }

    public Iso9660File getEntryByIndex(int index) throws ArrayIndexOutOfBoundsException {
        return this.files.get(index);
    }

    public int getFileIndex(String fileName) throws FileNotFoundException {
        for (int i = 0; i < this.files.size(); ++i) {
            String file = this.files.get(i).getFileName();
            if (!file.equalsIgnoreCase(fileName)) continue;
            return i;
        }
        throw new FileNotFoundException("File " + fileName + " not found in directory.");
    }

    public String[] getFileList() throws FileNotFoundException {
        String[] list = new String[this.files.size()];
        for (int i = 0; i < this.files.size(); ++i) {
            list[i] = this.files.get(i).getFileName();
        }
        return list;
    }
}

