/*
 * Decompiled with CFR 0.152.
 */
package jpcsp;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import jpcsp.Allegrex.CpuState;
import jpcsp.Memory;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class ParameterReader {
    private CpuState cpu;
    private Memory memory;
    private int parameterIndex = 0;
    private int parameterIndexFloat = 0;
    private static final Charset utf8 = Charset.forName("UTF8");
    protected static final int maxParameterInGprRegisters = 8;
    protected static final int maxParameterInFprRegisters = 8;
    protected static final int firstParameterInGpr = 4;
    protected static final int firstParameterInFpr = 12;

    public ParameterReader(CpuState cpu, Memory memory) {
        this.cpu = cpu;
        this.memory = memory;
    }

    public void setCpu(CpuState cpu) {
        this.cpu = cpu;
    }

    public void resetReading() {
        this.parameterIndex = 0;
        this.parameterIndexFloat = 0;
    }

    private int getParameterIntAt(int index) {
        if (index >= 8) {
            return this.memory.read32(this.cpu.gpr[29] + (index - 8) * 4);
        }
        return this.cpu.gpr[4 + index];
    }

    private float getParameterFloatAt(int index) {
        if (index >= 8) {
            throw new NotImplementedException();
        }
        return this.cpu.fpr[12 + index];
    }

    private long getParameterLongAt(int index) {
        if (index % 2 != 0) {
            throw new RuntimeException("Parameter misalignment");
        }
        return (long)this.getParameterIntAt(index) + (long)this.getParameterIntAt(index + 1) << 32;
    }

    private String getParameterStringAt(int index, Charset charset) {
        return new String(this.getBytez(this.getParameterIntAt(index)), charset);
    }

    protected int moveParameterIndex(int size) {
        while (this.parameterIndex % size != 0) {
            ++this.parameterIndex;
        }
        int retParameterIndex = this.parameterIndex;
        this.parameterIndex += size;
        return retParameterIndex;
    }

    protected int moveParameterIndexFloat(int size) {
        while (this.parameterIndexFloat % size != 0) {
            ++this.parameterIndexFloat;
        }
        int retParameterIndexFloat = this.parameterIndexFloat;
        this.parameterIndexFloat += size;
        return retParameterIndexFloat;
    }

    protected byte[] getBytez(int addr) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.memory.strlen(addr));
        this.memory.copyToMemory(addr, byteBuffer, byteBuffer.limit());
        return byteBuffer.array();
    }

    public int getNextInt() {
        return this.getParameterIntAt(this.moveParameterIndex(1));
    }

    public long getNextLong() {
        return this.getParameterLongAt(this.moveParameterIndex(2));
    }

    public float getNextFloat() {
        return this.getParameterFloatAt(this.moveParameterIndexFloat(1));
    }

    public String getNextStringUtf8() {
        return this.getNextString(utf8);
    }

    public String getNextString(Charset charset) {
        return this.getParameterStringAt(this.moveParameterIndex(1), charset);
    }

    public void setReturnValueInt(int value) {
        this.cpu.gpr[2] = value;
    }

    public void setReturnValueFloat(float value) {
        this.cpu.fpr[0] = value;
    }

    public void setReturnValueLong(long value) {
        this.cpu.gpr[2] = (int)(value >> 0 & 0xFFFFFFFFFFFFFFFFL);
        this.cpu.gpr[3] = (int)(value >> 32 & 0xFFFFFFFFFFFFFFFFL);
    }
}

