/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.Emulator;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryWriter;
import jpcsp.sound.SoundMixer;
import jpcsp.sound.SoundVoice;
import org.apache.log4j.Logger;

public class sceSasCore
extends HLEModule {
    public static Logger log = Modules.getLogger("sceSasCore");
    public static final int PSP_SAS_ERROR_ADDRESS = -2143158267;
    public static final int PSP_SAS_ERROR_VOICE_INDEX = -2143158256;
    public static final int PSP_SAS_ERROR_NOISE_CLOCK = -2143158255;
    public static final int PSP_SAS_ERROR_PITCH_VAL = -2143158254;
    public static final int PSP_SAS_ERROR_ADSR_MODE = -2143158253;
    public static final int PSP_SAS_ERROR_ADPCM_SIZE = -2143158252;
    public static final int PSP_SAS_ERROR_LOOP_MODE = -2143158251;
    public static final int PSP_SAS_ERROR_INVALID_STATE = -2143158250;
    public static final int PSP_SAS_ERROR_VOLUME_VAL = -2143158248;
    public static final int PSP_SAS_ERROR_ADSR_VAL = -2143158247;
    public static final int PSP_SAS_ERROR_FX_TYPE = -2143158240;
    public static final int PSP_SAS_ERROR_FX_FEEDBACK = -2143158239;
    public static final int PSP_SAS_ERROR_FX_DELAY = -2143158238;
    public static final int PSP_SAS_ERROR_FX_VOLUME_VAL = -2143158237;
    public static final int PSP_SAS_ERROR_BUSY = -2143158224;
    public static final int PSP_SAS_ERROR_NOTINIT = -2143158016;
    public static final int PSP_SAS_ERROR_ALRDYINIT = -2143158015;
    public static final int PSP_SAS_VOICES_MAX = 32;
    public static final int PSP_SAS_GRAIN_SAMPLES = 256;
    public static final int PSP_SAS_VOL_MAX = 4096;
    public static final int PSP_SAS_LOOP_MODE_OFF = 0;
    public static final int PSP_SAS_LOOP_MODE_ON = 1;
    public static final int PSP_SAS_PITCH_MIN = 1;
    public static final int PSP_SAS_PITCH_BASE = 4096;
    public static final int PSP_SAS_PITCH_MAX = 16384;
    public static final int PSP_SAS_NOISE_FREQ_MAX = 63;
    public static final int PSP_SAS_ENVELOPE_HEIGHT_MAX = 0x40000000;
    public static final int PSP_SAS_ENVELOPE_FREQ_MAX = Integer.MAX_VALUE;
    public static final int PSP_SAS_ADSR_CURVE_MODE_LINEAR_INCREASE = 0;
    public static final int PSP_SAS_ADSR_CURVE_MODE_LINEAR_DECREASE = 1;
    public static final int PSP_SAS_ADSR_CURVE_MODE_LINEAR_BENT = 2;
    public static final int PSP_SAS_ADSR_CURVE_MODE_EXPONENT_DECREASE = 3;
    public static final int PSP_SAS_ADSR_CURVE_MODE_EXPONENT_INCREASE = 4;
    public static final int PSP_SAS_ADSR_CURVE_MODE_DIRECT = 5;
    public static final int PSP_SAS_ADSR_ATTACK = 1;
    public static final int PSP_SAS_ADSR_DECAY = 2;
    public static final int PSP_SAS_ADSR_SUSTAIN = 4;
    public static final int PSP_SAS_ADSR_RELEASE = 8;
    public static final int PSP_SAS_OUTPUTMODE_STEREO = 0;
    public static final int PSP_SAS_OUTPUTMODE_MULTICHANNEL = 1;
    public static final int PSP_SAS_EFFECT_TYPE_OFF = -1;
    public static final int PSP_SAS_EFFECT_TYPE_ROOM = 0;
    public static final int PSP_SAS_EFFECT_TYPE_UNK1 = 1;
    public static final int PSP_SAS_EFFECT_TYPE_UNK2 = 2;
    public static final int PSP_SAS_EFFECT_TYPE_UNK3 = 3;
    public static final int PSP_SAS_EFFECT_TYPE_HALL = 4;
    public static final int PSP_SAS_EFFECT_TYPE_SPACE = 5;
    public static final int PSP_SAS_EFFECT_TYPE_ECHO = 6;
    public static final int PSP_SAS_EFFECT_TYPE_DELAY = 7;
    public static final int PSP_SAS_EFFECT_TYPE_PIPE = 8;
    private static final String[] sasADSRCurveTypeNames = new String[]{"LINEAR_INCREASE", "LINEAR_DECREASE", "LINEAR_BENT", "EXPONENT_REV", "EXPONENT", "DIRECT"};
    protected int sasCoreUid;
    protected SoundVoice[] voices;
    protected SoundMixer mixer;
    protected int grainSamples;
    protected int outputMode;
    protected static final int waveformBufMaxSize = 1024;
    protected int waveformEffectType;
    protected int waveformEffectLeftVol;
    protected int waveformEffectRightVol;
    protected int waveformEffectDelay;
    protected int waveformEffectFeedback;
    protected boolean waveformEffectIsDryOn;
    protected boolean waveformEffectIsWetOn;
    protected static final int sasCoreDelay = 5000;
    protected static final String sasCodeUidPurpose = "sceSasCore-SasCore";

    @Override
    public String getName() {
        return "sceSasCore";
    }

    @Override
    public void start() {
        this.sasCoreUid = -1;
        this.voices = new SoundVoice[32];
        for (int i = 0; i < this.voices.length; ++i) {
            this.voices[i] = new SoundVoice(i);
        }
        this.mixer = new SoundMixer(this.voices);
        this.grainSamples = 256;
        this.outputMode = 0;
        super.start();
    }

    public static String getSasADSRCurveTypeName(int curveType) {
        if (curveType < 0 || curveType >= sasADSRCurveTypeNames.length) {
            return String.format("UNKNOWN_%d", curveType);
        }
        return sasADSRCurveTypeNames[curveType];
    }

    protected void checkSasAddressGood(int sasCore) {
        if (!Memory.isAddressGood(sasCore)) {
            log.warn((Object)String.format("%s bad sasCore Address 0x%08X", sceSasCore.getCallingFunctionName(3), sasCore));
            throw new SceKernelErrorException(-2143158267);
        }
        if (!Memory.isAddressAlignedTo(sasCore, 64)) {
            log.warn((Object)String.format("%s bad sasCore Address 0x%08X (not aligned to 64)", sceSasCore.getCallingFunctionName(3), sasCore));
            throw new SceKernelErrorException(-2143158267);
        }
    }

    protected void checkSasHandleGood(int sasCore) {
        this.checkSasAddressGood(sasCore);
        if (Processor.memory.read32(sasCore) != this.sasCoreUid) {
            throw new SceKernelErrorException(-2143158016);
        }
    }

    protected void checkVoiceNumberGood(int voice) {
        if (voice < 0 || voice >= this.voices.length) {
            log.warn((Object)String.format("%s bad voice number %d", sceSasCore.getCallingFunctionName(3), voice));
            throw new SceKernelErrorException(-2143158256);
        }
    }

    protected void checkSasAndVoiceHandlesGood(int sasCore, int voice) {
        this.checkSasHandleGood(sasCore);
        this.checkVoiceNumberGood(voice);
    }

    protected void checkADSRmode(int curveIndex, int flag, int curveType) {
        int[] validCurveTypes = new int[]{21, 42, 63, 42};
        if ((flag & 1 << curveIndex) != 0 && (validCurveTypes[curveIndex] & 1 << curveType) == 0) {
            throw new SceKernelErrorException(-2143158253);
        }
    }

    protected void checkVoiceNotPaused(int voice) {
        if (this.voices[voice].isPaused()) {
            throw new SceKernelErrorException(-2143158250);
        }
    }

    private void delayThread(long startMicros, int delayMicros) {
        long now = Emulator.getClock().microTime();
        int threadDelayMicros = delayMicros - (int)(now - startMicros);
        if (threadDelayMicros > 0) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(threadDelayMicros, false);
        } else {
            Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
        }
    }

    private void delayThreadSasCore(long startMicros) {
        int delayMicros = 600;
        this.delayThread(startMicros, delayMicros);
    }

    @HLEFunction(nid=26945003, version=150, checkInsideInterrupt=true)
    public int __sceSasSetADSR(int sasCore, int voice, int flag, int attack, int decay, int sustain, int release) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasSetADSR sasCore=0x%08X, voice=%d flag=0x%1X a=0x%08X d=0x%08X s=0x%08X r=0x%08X", sasCore, voice, flag, attack, decay, sustain, release));
        }
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        SoundVoice.VoiceADSREnvelope envelope = this.voices[voice].getEnvelope();
        if ((flag & 1) != 0) {
            envelope.AttackRate = attack;
        }
        if ((flag & 2) != 0) {
            envelope.DecayRate = decay;
        }
        if ((flag & 4) != 0) {
            envelope.SustainRate = sustain;
        }
        if ((flag & 8) != 0) {
            envelope.ReleaseRate = release;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasSetADSR voice=%d: %s", voice, envelope.toString()));
        }
        return 0;
    }

    @HLEFunction(nid=645557714, version=150, checkInsideInterrupt=true)
    public int __sceSasRevParam(int sasCore, int delay, int feedback) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasRevParam sasCore=0x%08X, delay=%d, feedback=%d", sasCore, delay, feedback));
        }
        this.checkSasHandleGood(sasCore);
        this.waveformEffectDelay = delay;
        this.waveformEffectFeedback = feedback;
        return 0;
    }

    @HLEFunction(nid=747530931, version=150, checkInsideInterrupt=true)
    public int __sceSasGetPauseFlag(int sasCore) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasGetPauseFlag sasCore=0x%08X", sasCore));
        }
        this.checkSasHandleGood(sasCore);
        int pauseFlag = 0;
        for (int i = 0; i < this.voices.length; ++i) {
            if (!this.voices[i].isPaused()) continue;
            pauseFlag |= 1 << i;
        }
        return pauseFlag;
    }

    @HLEFunction(nid=869575479, version=150, checkInsideInterrupt=true)
    public int __sceSasRevType(int sasCore, int type) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasRevType sasCore=0x%08X, type=%d", sasCore, type));
        }
        this.checkSasHandleGood(sasCore);
        this.waveformEffectType = type;
        return 0;
    }

    @HLEFunction(nid=1115130527, version=150)
    public int __sceSasInit(TPointer sasCore, int grain, int maxVoices, int outputMode, int sampleRate) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasInit sasCore=0x%08X, grain=%d, maxVoices=%d, outputMode=%d, sampleRate=%d", sasCore.getAddress(), grain, maxVoices, outputMode, sampleRate));
        }
        this.checkSasAddressGood(sasCore.getAddress());
        if (this.sasCoreUid != -1) {
            SceUidManager.releaseUid(this.sasCoreUid, sasCodeUidPurpose);
        }
        this.sasCoreUid = SceUidManager.getNewUid(sasCodeUidPurpose);
        sasCore.setValue32(0, this.sasCoreUid);
        this.grainSamples = grain;
        this.outputMode = outputMode;
        for (int i = 0; i < this.voices.length; ++i) {
            this.voices[i].setSampleRate(sampleRate);
        }
        return 0;
    }

    @HLEFunction(nid=1141680088, version=150, checkInsideInterrupt=true)
    public int __sceSasSetVolume(Processor processor, int sasCore, int voice, int leftVolume, int rightVolume, int effectLeftVolumne, int effectRightVolume) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasSetVolume sasCore=0x%08X, voice=%d, leftVolume=0x%04X, rightVolume=0x%04X, effectLeftVolume=0x%04X, effectRightVolume=0x%04X", sasCore, voice, leftVolume, rightVolume, effectLeftVolumne, effectRightVolume));
        }
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        this.voices[voice].setLeftVolume(leftVolume << 3);
        this.voices[voice].setRightVolume(rightVolume << 3);
        return 0;
    }

    @HLEFunction(nid=1352748540, version=150, checkInsideInterrupt=true)
    public int __sceSasCoreWithMix(int sasCore, int sasInOut, int leftVolume, int rightVolume) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasCoreWithMix 0x%08X, sasInOut=0x%08X, leftVolume=0x%04X, rightVolume=0x%04X", sasCore, sasInOut, leftVolume, rightVolume));
        }
        this.checkSasHandleGood(sasCore);
        long startTime = Emulator.getClock().microTime();
        this.mixer.synthesizeWithMix(sasInOut, this.grainSamples, leftVolume << 3, rightVolume << 3);
        this.delayThreadSasCore(startTime);
        return 0;
    }

    @HLEFunction(nid=1603611126, version=150, checkInsideInterrupt=true)
    public int __sceSasSetSL(int sasCore, int voice, int level) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasSetSL sasCore=0x%08X, voice=%d, level=0x%08X", sasCore, voice, level));
        }
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        this.voices[voice].getEnvelope().SustainLevel = level;
        return 0;
    }

    @HLEFunction(nid=1755605909, version=150)
    public int __sceSasGetEndFlag(int sasCore) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasGetEndFlag sasCore=0x%08X", sasCore));
        }
        this.checkSasHandleGood(sasCore);
        int endFlag = 0;
        for (int i = 0; i < this.voices.length; ++i) {
            if (!this.voices[i].isEnded()) continue;
            endFlag |= 1 << i;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasGetEndFlag returning 0x%08X", endFlag));
        }
        return endFlag;
    }

    @HLEFunction(nid=1957582890, version=150, checkInsideInterrupt=true)
    public int __sceSasGetEnvelopeHeight(int sasCore, int voice) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasGetEnvelopeHeight sasCore=0x%08X ,voice=%d", sasCore, voice));
        }
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        return this.voices[voice].getEnvelope().height;
    }

    @HLEFunction(nid=1995446986, version=150, checkInsideInterrupt=true)
    public int __sceSasSetKeyOn(int sasCore, int voice) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasSetKeyOn: sasCore=0x%08X, voice=%d", sasCore, voice));
        }
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        this.checkVoiceNotPaused(voice);
        this.voices[voice].on();
        return 0;
    }

    @HLEFunction(nid=2021459157, version=150, checkInsideInterrupt=true)
    public int __sceSasSetPause(int sasCore, int voice_bit, boolean setPause) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasSetPause sasCore=0x%08X voice_bit=0x%X setPause=%b", sasCore, voice_bit, setPause));
        }
        this.checkSasHandleGood(sasCore);
        int i = 0;
        while (voice_bit != 0) {
            if ((voice_bit & 1) != 0) {
                this.voices[i].setPaused(setPause);
            }
            ++i;
            voice_bit >>>= 1;
        }
        return 0;
    }

    @HLEFunction(nid=-1718337399, version=150, checkInsideInterrupt=true)
    public int __sceSasSetVoice(int sasCore, int voice, int vagAddr, int size, int loopmode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasSetVoice sasCore=0x%08X, voice=%d, vagAddr=0x%08X, size=0x%08X, loopmode=%d", sasCore, voice, vagAddr, size, loopmode));
        }
        if (size <= 0 || (size & 0xF) != 0) {
            log.warn((Object)String.format("__sceSasSetVoice invalid size 0x%08X", size));
            throw new SceKernelErrorException(-2143158252);
        }
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        this.voices[voice].setVAG(vagAddr, size);
        this.voices[voice].setLoopMode(loopmode);
        return 0;
    }

    @HLEFunction(nid=-1631361174, version=150, checkInsideInterrupt=true)
    public int __sceSasSetADSRmode(int sasCore, int voice, int flag, int attackType, int decayType, int sustainType, int releaseType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasSetADSRmode sasCore=0x%08X, voice=%d, flag=0x%1X, attackType=%d, decayType=%d, sustainType=%d, releaseType=%d", sasCore, voice, flag, attackType, decayType, sustainType, releaseType));
        }
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        this.checkADSRmode(0, flag, attackType);
        this.checkADSRmode(1, flag, decayType);
        this.checkADSRmode(2, flag, sustainType);
        this.checkADSRmode(3, flag, releaseType);
        SoundVoice.VoiceADSREnvelope envelope = this.voices[voice].getEnvelope();
        if ((flag & 1) != 0) {
            envelope.AttackCurveType = attackType;
        }
        if ((flag & 2) != 0) {
            envelope.DecayCurveType = decayType;
        }
        if ((flag & 4) != 0) {
            envelope.SustainCurveType = sustainType;
        }
        if ((flag & 8) != 0) {
            envelope.ReleaseCurveType = releaseType;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasSetADSRmode voice=%d: %s", voice, envelope.toString()));
        }
        return 0;
    }

    @HLEFunction(nid=-1597034588, version=150, checkInsideInterrupt=true)
    public int __sceSasSetKeyOff(int sasCore, int voice) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasSetKeyOff sasCore=%08X, voice=%d", sasCore, voice));
        }
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        this.checkVoiceNotPaused(voice);
        this.voices[voice].off();
        return 0;
    }

    @HLEFunction(nid=-1573729306, version=150, checkInsideInterrupt=true)
    public int __sceSasSetTriangularWave(int sasCore, int voice, int unknown) {
        log.warn((Object)String.format("Unimplemented __sceSasSetTrianglarWave sasCore=0x%08X, voice=%d, unknown=0x%08X", sasCore, voice, unknown));
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        return 0;
    }

    @HLEFunction(nid=-1554473599, version=150, checkInsideInterrupt=true)
    public int __sceSasCore(int sasCore, int sasOut) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasCore 0x%08X, out=0x%08X", sasCore, sasOut));
        }
        this.checkSasHandleGood(sasCore);
        long startTime = Emulator.getClock().microTime();
        this.mixer.synthesize(sasOut, this.grainSamples);
        this.delayThreadSasCore(startTime);
        return 0;
    }

    @HLEFunction(nid=-1383804033, version=150, checkInsideInterrupt=true)
    public int __sceSasSetPitch(int sasCore, int voice, int pitch) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasSetPitch sasCore=%08X, voice=%d, pitch=0x%04X", sasCore, voice, pitch));
        }
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        this.voices[voice].setPitch(pitch);
        return 0;
    }

    @HLEFunction(nid=-1218049501, version=150, checkInsideInterrupt=true)
    public int __sceSasSetNoise(int sasCore, int voice, int freq) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasSetNoise sasCore=%08X, voice=%d, freq=0x%04X", sasCore, voice, freq));
        }
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        this.voices[voice].setNoise(freq);
        return 0;
    }

    @HLEFunction(nid=-1122912318, version=150, checkInsideInterrupt=true)
    public int __sceSasGetGrain(int sasCore) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasGetGrain sasCore=0x%08X returning grain samples=%d", sasCore, this.grainSamples));
        }
        this.checkSasHandleGood(sasCore);
        return this.grainSamples;
    }

    private int getSimpleSustainLevel(int bitfield1) {
        return (bitfield1 & 0xF) + 1 << 26;
    }

    private int getSimpleDecayRate(int bitfield1) {
        return Integer.MIN_VALUE >>> (bitfield1 >> 4 & 0xF);
    }

    private int getSimpleRate(int n) {
        if ((n &= 0x7F) == 127) {
            return 0;
        }
        int rate = 7 - (n & 3) << 26 >>> (n >> 2);
        if (rate == 0) {
            return 1;
        }
        return rate;
    }

    private int getSimpleAttackRate(int bitfield1) {
        return this.getSimpleRate(bitfield1 >> 8);
    }

    private int getSimpleAttackCurveType(int bitfield1) {
        return (bitfield1 & 0x8000) == 0 ? 0 : 2;
    }

    private int getSimpleReleaseRate(int bitfield2) {
        int n = bitfield2 & 0x1F;
        if (n == 31) {
            return 0;
        }
        if (this.getSimpleReleaseCurveType(bitfield2) == 1) {
            return 0x40000000 >>> n + 2;
        }
        return 0x8000000 >>> n;
    }

    private int getSimpleReleaseCurveType(int bitfield2) {
        return (bitfield2 & 0x20) == 0 ? 1 : 3;
    }

    private int getSimpleSustainRate(int bitfield2) {
        return this.getSimpleRate(bitfield2 >> 6);
    }

    private int getSimpleSustainCurveType(int bitfield2) {
        switch (bitfield2 >> 13) {
            case 0: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 6: {
                return 3;
            }
        }
        throw new SceKernelErrorException(-2143158253);
    }

    @HLEFunction(nid=-875737223, version=150, checkInsideInterrupt=true)
    public int __sceSasSetSimpleADSR(Processor processor, int sasCore, int voice, int ADSREnv1, int ADSREnv2) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasSetSimpleADSR sasCore=0x%08X, voice=%d, ADSREnv1=0x%04X, ADSREnv2=0x%04X", sasCore, voice, ADSREnv1, ADSREnv2));
        }
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        int env1Bitfield = ADSREnv1 & 0xFFFF;
        int env2Bitfield = ADSREnv2 & 0xFFFF;
        SoundVoice.VoiceADSREnvelope envelope = this.voices[voice].getEnvelope();
        envelope.SustainLevel = this.getSimpleSustainLevel(env1Bitfield);
        envelope.DecayRate = this.getSimpleDecayRate(env1Bitfield);
        envelope.DecayCurveType = 3;
        envelope.AttackRate = this.getSimpleAttackRate(env1Bitfield);
        envelope.AttackCurveType = this.getSimpleAttackCurveType(env1Bitfield);
        envelope.ReleaseRate = this.getSimpleReleaseRate(env2Bitfield);
        envelope.ReleaseCurveType = this.getSimpleReleaseCurveType(env2Bitfield);
        envelope.SustainRate = this.getSimpleSustainRate(env2Bitfield);
        envelope.SustainCurveType = this.getSimpleSustainCurveType(env2Bitfield);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasSetSimpleADSR voice=%d: %s", voice, envelope.toString()));
        }
        return 0;
    }

    @HLEFunction(nid=-773808098, version=150, checkInsideInterrupt=true)
    public int __sceSasSetGrain(int sasCore, int grain) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasSetGrain sasCore=0x%08X, grain=%d", sasCore, grain));
        }
        this.checkSasHandleGood(sasCore);
        this.grainSamples = grain;
        return 0;
    }

    @HLEFunction(nid=-710792759, version=150, checkInsideInterrupt=true)
    public int __sceSasRevEVOL(int sasCore, int leftVolume, int rightVolume) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasRevEVOL sasCore=0x%08X, leftVolume=0x%04X, rightVolume=0x%04X", sasCore, leftVolume, rightVolume));
        }
        this.checkSasHandleGood(sasCore);
        this.waveformEffectLeftVol = leftVolume;
        this.waveformEffectRightVol = rightVolume;
        return 0;
    }

    @HLEFunction(nid=-705971251, version=150, checkInsideInterrupt=true)
    public int __sceSasSetSteepWave(int sasCore, int voice, int unknown) {
        log.warn((Object)String.format("Unimplemented __sceSasSetSteepWave sasCore=0x%08X, voice=%d, unknown=0x%08X", sasCore, voice, unknown));
        this.checkSasAndVoiceHandlesGood(sasCore, voice);
        return 0;
    }

    @HLEFunction(nid=-512364698, version=150, checkInsideInterrupt=true)
    public int __sceSasGetOutputmode(int sasCore) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasGetOutputmode sasCore=0x%08X, returning output mode=%d", sasCore, this.outputMode));
        }
        this.checkSasHandleGood(sasCore);
        return this.outputMode;
    }

    @HLEFunction(nid=-397033610, version=150, checkInsideInterrupt=true)
    public int __sceSasSetOutputmode(int sasCore, int outputMode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasSetOutputmode sasCore=0x%08X, outputMode=%d", sasCore, outputMode));
        }
        this.checkSasHandleGood(sasCore);
        this.outputMode = outputMode;
        return 0;
    }

    @HLEFunction(nid=-108809850, version=150, checkInsideInterrupt=true)
    public int __sceSasRevVON(int sasCore, int dry, int wet) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasRevVON sasCore=0x%08X, dry=%d, wet=%d", sasCore, dry, wet));
        }
        this.checkSasHandleGood(sasCore);
        this.waveformEffectIsDryOn = dry > 0;
        this.waveformEffectIsWetOn = wet > 0;
        return 0;
    }

    @HLEFunction(nid=133532708, version=150, checkInsideInterrupt=true)
    public int __sceSasGetAllEnvelopeHeights(int sasCore, int heightsAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("__sceSasGetAllEnvelopeHeights sasCore=0x%08X, heightsAddr=0x%08X", sasCore, heightsAddr));
        }
        this.checkSasHandleGood(sasCore);
        if (!Memory.isAddressGood(heightsAddr)) {
            return -1;
        }
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(heightsAddr, this.voices.length * 4, 4);
        for (int i = 0; i < this.voices.length; ++i) {
            memoryWriter.writeNext(this.voices[i].getEnvelope().height);
        }
        memoryWriter.flush();
        return 0;
    }
}

