/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.StringInfo;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.hardware.Wlan;
import jpcsp.network.INetworkAdapter;
import jpcsp.network.NetworkAdapterFactory;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

@HLELogging
public class sceNet
extends HLEModule {
    public static Logger log = Modules.getLogger("sceNet");
    private INetworkAdapter networkAdapter;
    protected int netMemSize;

    @Override
    public String getName() {
        return "sceNet";
    }

    @Override
    public void start() {
        this.networkAdapter = NetworkAdapterFactory.createNetworkAdapter();
        this.networkAdapter.start();
        super.start();
    }

    @Override
    public void stop() {
        this.networkAdapter.stop();
        this.networkAdapter = null;
        super.stop();
    }

    public INetworkAdapter getNetworkAdapter() {
        return this.networkAdapter;
    }

    public static String convertMacAddressToString(byte[] macAddress) {
        return String.format("%02x:%02x:%02x:%02x:%02x:%02x", macAddress[0], macAddress[1], macAddress[2], macAddress[3], macAddress[4], macAddress[5]);
    }

    protected static int parseHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        log.error((Object)String.format("Cannot parse hex digit '%c'", Character.valueOf(c)));
        return 0;
    }

    public static byte[] convertStringToMacAddress(String str) {
        byte[] macAddress = new byte[6];
        int n = 0;
        for (int i = 0; i < macAddress.length; ++i) {
            int n1 = sceNet.parseHexDigit(str.charAt(n++));
            int n2 = sceNet.parseHexDigit(str.charAt(n++));
            ++n;
            macAddress[i] = (byte)((n1 << 4) + n2);
        }
        return macAddress;
    }

    protected int networkSwap32(int value) {
        return Utilities.endianSwap32(value);
    }

    protected int networkSwap16(int value) {
        return Utilities.endianSwap16(value);
    }

    @HLELogging(level="info")
    @HLEFunction(nid=967784870, version=150, checkInsideInterrupt=true)
    public int sceNetInit(int poolSize, int calloutThreadPri, int calloutThreadStack, int netinitThreadPri, int netinitThreadStack) {
        this.netMemSize = poolSize;
        return 0;
    }

    @HLEFunction(nid=672737449, version=150, checkInsideInterrupt=true)
    public int sceNetTerm() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1348760880, version=150, checkInsideInterrupt=true)
    public int sceNetFreeThreadinfo(int threadID) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1385675578, version=150, checkInsideInterrupt=true)
    public int sceNetThreadAbort(int threadID) {
        return 0;
    }

    @HLEFunction(nid=-1992947376, version=150, checkInsideInterrupt=true)
    public int sceNetEtherNtostr(pspNetMacAddress macAddress, TPointer strAddr) {
        Utilities.writeStringZ(Memory.getInstance(), strAddr.getAddress(), sceNet.convertMacAddressToString(macAddress.macAddress));
        return 0;
    }

    @HLEFunction(nid=-763797047, version=150, checkInsideInterrupt=true)
    public int sceNetEtherStrton(@StringInfo(maxLength=17) PspString str, TPointer etherAddr) {
        pspNetMacAddress macAddress = new pspNetMacAddress();
        macAddress.setMacAddress(sceNet.convertStringToMacAddress(str.getString()));
        macAddress.write(etherAddr);
        return 0;
    }

    @HLEFunction(nid=-176136450, version=150, checkInsideInterrupt=true)
    public int sceNetHtonl(int host32) {
        return this.networkSwap32(host32);
    }

    @HLEFunction(nid=968998658, version=150, checkInsideInterrupt=true)
    public int sceNetHtons(int host16) {
        return this.networkSwap16(host16);
    }

    @HLEFunction(nid=-1815826562, version=150, checkInsideInterrupt=true)
    public int sceNetNtohl(int net32) {
        return this.networkSwap32(net32);
    }

    @HLEFunction(nid=1289761287, version=150, checkInsideInterrupt=true)
    public int sceNetNtohs(int net16) {
        return this.networkSwap16(net16);
    }

    @HLEFunction(nid=200319918, version=150, checkInsideInterrupt=true)
    public int sceNetGetLocalEtherAddr(TPointer etherAddr) {
        pspNetMacAddress macAddress = new pspNetMacAddress();
        macAddress.setMacAddress(Wlan.getMacAddress());
        macAddress.write(etherAddr);
        return 0;
    }

    @HLEFunction(nid=-868663736, version=150, checkInsideInterrupt=true)
    public int sceNetGetMallocStat(TPointer32 statAddr) {
        int freeSize = this.netMemSize / 2;
        statAddr.setValue(0, this.netMemSize);
        statAddr.setValue(4, this.netMemSize - freeSize);
        statAddr.setValue(8, freeSize);
        return 0;
    }
}

