/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.nio.ByteBuffer;
import java.util.HashMap;
import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEUidClass;
import jpcsp.HLE.HLEUidObjectMapping;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.Memory;
import jpcsp.media.MediaEngine;
import jpcsp.media.PacketChannel;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

@HLELogging
public class sceMp3
extends HLEModule {
    public static Logger log = Modules.getLogger("sceMp3");
    protected int mp3HandleCount;
    protected HashMap<Integer, Mp3Stream> mp3Map;
    protected static final int compressionFactor = 10;
    protected static final int PSP_MP3_LOOP_NUM_INFINITE = -1;
    protected static final int mp3DecodeDelay = 4000;
    private boolean useMediaEngine = false;
    static final int ERROR_MP3_NOT_FOUND = 0;

    @Override
    public String getName() {
        return "sceMp3";
    }

    @Override
    public void start() {
        this.mp3Map = new HashMap();
        this.setSettingsListener("emu.useMediaEngine", new EnableMediaEngineSettingsListerner());
        super.start();
    }

    protected boolean checkMediaEngineState() {
        return this.useMediaEngine;
    }

    private void setEnableMediaEngine(boolean state) {
        this.useMediaEngine = state;
    }

    protected int endianSwap(int x) {
        return x << 24 | x << 8 & 0xFF0000 | x >> 8 & 0xFF00 | x >> 24 & 0xFF;
    }

    public int makeFakeMp3StreamHandle() {
        return 0xA300 | this.mp3HandleCount++ & 0xFFFF;
    }

    private void delayThread(long startMicros, int delayMicros) {
        long now = Emulator.getClock().microTime();
        int threadDelayMicros = delayMicros - (int)(now - startMicros);
        if (threadDelayMicros > 0) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(threadDelayMicros, false);
        }
    }

    @HLEFunction(nid=132919834, version=150, checkInsideInterrupt=true)
    public Mp3Stream sceMp3ReserveMp3Handle(TPointer mp3args) {
        Mp3Stream mp3Stream = new Mp3Stream(mp3args.getAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp3ReserveMp3Handle returning %s", mp3Stream));
        }
        return mp3Stream;
    }

    @HLEFunction(nid=229722612, version=150, checkInsideInterrupt=true)
    public int sceMp3NotifyAddStreamData(Mp3Stream mp3Stream, int size) {
        mp3Stream.addMp3StreamData(size);
        return 0;
    }

    @HLEFunction(nid=708216417, version=150, checkInsideInterrupt=true)
    public int sceMp3ResetPlayPosition(Mp3Stream mp3Stream) {
        mp3Stream.setMp3BufCurrentPos(0);
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=896860272, version=150, checkInsideInterrupt=true)
    public int sceMp3InitResource() {
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=1009754200, version=150, checkInsideInterrupt=true)
    public int sceMp3TermResource() {
        return 0;
    }

    @HLEFunction(nid=1022314575, version=150, checkInsideInterrupt=true)
    public int sceMp3SetLoopNum(Mp3Stream mp3Stream, int loopNbr) {
        mp3Stream.setMp3LoopNum(loopNbr);
        return 0;
    }

    @HLEFunction(nid=1155559721, version=150, checkInsideInterrupt=true)
    public int sceMp3Init(Mp3Stream mp3Stream) {
        mp3Stream.init();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Initializing Mp3 data: channels=%d, samplerate=%dkHz, bitrate=%dkbps.", mp3Stream.getMp3ChannelNum(), mp3Stream.getMp3SamplingRate(), mp3Stream.getMp3BitRate()));
        }
        return 0;
    }

    @HLEFunction(nid=2137614210, version=150, checkInsideInterrupt=true)
    public int sceMp3GetMp3ChannelNum(Mp3Stream mp3Stream) {
        return mp3Stream.getMp3ChannelNum();
    }

    @HLEFunction(nid=-1891300968, version=150, checkInsideInterrupt=true)
    public int sceMp3GetSamplingRate(Mp3Stream mp3Stream) {
        return mp3Stream.getMp3SamplingRate();
    }

    @HLEFunction(nid=-1492910577, version=150, checkInsideInterrupt=true)
    public int sceMp3GetInfoToAddStreamData(Mp3Stream mp3Stream, @CanBeNull TPointer32 mp3BufPtr, @CanBeNull TPointer32 mp3BufToWritePtr, @CanBeNull TPointer32 mp3PosPtr) {
        mp3BufPtr.setValue(mp3Stream.isStreamDataEnd() ? 0 : mp3Stream.getMp3BufWriteAddr());
        mp3BufToWritePtr.setValue(mp3Stream.isStreamDataEnd() ? 0 : mp3Stream.getMp3AvailableSequentialWriteSize());
        mp3PosPtr.setValue((int)mp3Stream.getMp3InputFileSize());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp3GetInfoToAddStreamData returning mp3Buf=0x%08X, mp3BufToWrite=0x%X, mp3Pos=0x%X", mp3BufPtr.getValue(), mp3BufToWritePtr.getValue(), mp3PosPtr.getValue()));
        }
        return 0;
    }

    @HLEFunction(nid=-803094277, version=150, checkInsideInterrupt=true)
    public int sceMp3Decode(Mp3Stream mp3Stream, TPointer32 outPcmPtr) {
        long startTime = Emulator.getClock().microTime();
        int pcmBytes = mp3Stream.decode();
        int pcmSamples = mp3Stream.getMp3DecodedSamples();
        outPcmPtr.setValue(mp3Stream.getMp3PcmBufAddr());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp3Decode returning %d samples (%d bytes) at 0x%08X", pcmSamples, pcmBytes, outPcmPtr.getValue()));
        }
        this.delayThread(startTime, 4000);
        return pcmSamples;
    }

    @HLEFunction(nid=-794467690, version=150, checkInsideInterrupt=true)
    public boolean sceMp3CheckStreamDataNeeded(Mp3Stream mp3Stream) {
        boolean dataNeeded = mp3Stream.isStreamDataNeeded();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp3CheckStreamDataNeeded returning %b", dataNeeded));
        }
        return dataNeeded;
    }

    @HLEFunction(nid=-179862989, version=150, checkInsideInterrupt=true)
    public int sceMp3ReleaseMp3Handle(Mp3Stream mp3Stream) {
        HLEUidObjectMapping.removeObject(mp3Stream);
        return 0;
    }

    @HLEFunction(nid=894248938, version=150)
    public int sceMp3GetSumDecodedSample(Mp3Stream mp3Stream) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp3GetSumDecodedSample returning %d", mp3Stream.getMp3DecodedSamples()));
        }
        return mp3Stream.getMp3DecodedSamples();
    }

    @HLEFunction(nid=-2023260608, version=150, checkInsideInterrupt=true)
    public int sceMp3GetBitRate(Mp3Stream mp3Stream) {
        return mp3Stream.getMp3BitRate();
    }

    @HLEFunction(nid=-2017303599, version=150, checkInsideInterrupt=true)
    public int sceMp3GetMaxOutputSample(Mp3Stream mp3Stream) {
        return mp3Stream.getMp3MaxSamples();
    }

    @HLEFunction(nid=-655013295, version=150, checkInsideInterrupt=true)
    public int sceMp3GetLoopNum(Mp3Stream mp3Stream) {
        return mp3Stream.getMp3LoopNum();
    }

    @HLEUnimplemented
    @HLEFunction(nid=893955784, version=150)
    public int sceMp3GetFrameNum(Mp3Stream mp3Stream) {
        return 0;
    }

    @HLEFunction(nid=-1368580057, version=150)
    public int sceMp3GetVersion(Mp3Stream mp3Stream) {
        return mp3Stream.getMp3Version();
    }

    @HLEFunction(nid=138471432, version=150, checkInsideInterrupt=true)
    public int sceMp3ResetPlayPosition2(Mp3Stream mp3Stream, int position) {
        mp3Stream.setMp3BufCurrentPos(position);
        return 0;
    }

    @HLEUidClass(moduleMethodUidGenerator="makeFakeMp3StreamHandle", errorValueOnNotFound=0)
    protected class Mp3Stream {
        private static final int ME_READ_AHEAD = 229376;
        private final long mp3StreamStart;
        private final long mp3StreamEnd;
        private final int mp3Buf;
        private final int mp3BufSize;
        private final int mp3PcmBuf;
        private final int mp3PcmBufSize;
        private long mp3InputFileSize;
        private int mp3InputFileReadPos;
        private int mp3InputBufWritePos;
        private int mp3InputBufSize;
        private int mp3DecodedBytes;
        private int mp3SampleRate;
        private int mp3LoopNum;
        private int mp3BitRate;
        private int mp3MaxSamples;
        private int mp3Channels;
        private int mp3Version;
        protected MediaEngine me;
        protected PacketChannel mp3Channel;
        private byte[] mp3PcmBuffer;

        public Mp3Stream(int args) {
            Memory mem = Memory.getInstance();
            this.mp3StreamStart = mem.read64(args);
            this.mp3StreamEnd = mem.read64(args + 8);
            this.mp3Buf = mem.read32(args + 16);
            this.mp3BufSize = mem.read32(args + 20);
            this.mp3PcmBuf = mem.read32(args + 24);
            this.mp3PcmBufSize = mem.read32(args + 28);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceMp3ReserveMp3Handle Stream start=0x%X, end=0x%X", this.mp3StreamStart, this.mp3StreamEnd));
                log.debug((Object)String.format("sceMp3ReserveMp3Handle Mp3Buf 0x%08X, size=0x%X", this.mp3Buf, this.mp3BufSize));
                log.debug((Object)String.format("sceMp3ReserveMp3Handle PcmBuf 0x%08X, size=0x%X", this.mp3PcmBuf, this.mp3PcmBufSize));
            }
            this.mp3InputFileReadPos = 0;
            this.mp3InputFileSize = 0L;
            this.mp3InputBufWritePos = this.mp3InputFileReadPos;
            this.mp3InputBufSize = 0;
            this.mp3MaxSamples = this.mp3PcmBufSize / 4;
            this.mp3LoopNum = -1;
            this.mp3DecodedBytes = 0;
            if (sceMp3.this.checkMediaEngineState()) {
                this.me = new MediaEngine();
                this.me.setAudioSamplesSize(this.mp3MaxSamples);
                this.mp3Channel = new PacketChannel();
            }
            this.mp3PcmBuffer = new byte[this.mp3PcmBufSize];
        }

        private void parseMp3FrameHeader() {
            Memory mem = Memory.getInstance();
            int header = sceMp3.this.endianSwap(Utilities.readUnaligned32(mem, this.mp3Buf + (int)this.mp3StreamStart));
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Mp3 header: 0x%08X", header));
            }
            this.mp3Channels = this.calculateMp3Channels(header >> 6 & 3);
            this.mp3SampleRate = this.calculateMp3SampleRate(header >> 10 & 3);
            this.mp3BitRate = this.calculateMp3Bitrate(header >> 12 & 0xF);
            this.mp3Version = header >> 19 & 3;
        }

        private int calculateMp3Bitrate(int bitVal) {
            switch (bitVal) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 32;
                }
                case 2: {
                    return 40;
                }
                case 3: {
                    return 48;
                }
                case 4: {
                    return 56;
                }
                case 5: {
                    return 64;
                }
                case 6: {
                    return 80;
                }
                case 7: {
                    return 96;
                }
                case 8: {
                    return 112;
                }
                case 9: {
                    return 128;
                }
                case 10: {
                    return 160;
                }
                case 11: {
                    return 192;
                }
                case 12: {
                    return 224;
                }
                case 13: {
                    return 256;
                }
                case 14: {
                    return 320;
                }
            }
            return -1;
        }

        private int calculateMp3SampleRate(int bitVal) {
            if (bitVal == 0) {
                return 44100;
            }
            if (bitVal == 1) {
                return 48000;
            }
            if (bitVal == 2) {
                return 32000;
            }
            return 0;
        }

        private int calculateMp3Channels(int bitVal) {
            if (bitVal == 0 || bitVal == 1 || bitVal == 2) {
                return 2;
            }
            if (bitVal == 3) {
                return 1;
            }
            return 0;
        }

        public int getMp3AvailableReadSize() {
            return this.mp3InputBufSize;
        }

        public int getMp3AvailableWriteSize() {
            return this.mp3BufSize - this.getMp3AvailableReadSize();
        }

        public int getMp3AvailableSequentialWriteSize() {
            return this.mp3BufSize - this.mp3InputBufWritePos;
        }

        private int consumeRead(int size) {
            size = Math.min(size, this.getMp3AvailableReadSize());
            this.mp3InputBufSize -= size;
            this.mp3InputFileReadPos += size;
            return size;
        }

        private int consumeWrite(int size) {
            size = Math.min(size, this.getMp3AvailableWriteSize());
            this.mp3InputBufSize += size;
            this.mp3InputBufWritePos += size;
            if (this.mp3InputBufWritePos >= this.mp3BufSize) {
                this.mp3InputBufWritePos -= this.mp3BufSize;
            }
            return size;
        }

        public void init() {
            this.parseMp3FrameHeader();
            if (sceMp3.this.checkMediaEngineState()) {
                this.me.finish();
            }
        }

        private boolean checkMediaEngineChannel() {
            if (sceMp3.this.checkMediaEngineState() && this.mp3Channel.length() < 229376) {
                int neededLength = 229376 - this.mp3Channel.length();
                if (this.getMp3AvailableWriteSize() < neededLength) {
                    this.consumeRead(neededLength - this.getMp3AvailableWriteSize());
                }
                return false;
            }
            return true;
        }

        public int decode() {
            if (sceMp3.this.checkMediaEngineState()) {
                if (this.checkMediaEngineChannel()) {
                    if (this.me.getContainer() == null) {
                        this.me.init(this.mp3Channel, false, true);
                    }
                    this.me.stepAudio(this.getMp3MaxSamples() * this.getBytesPerSample());
                    this.mp3DecodedBytes = this.copySamplesToMem(this.mp3PcmBuf, this.mp3PcmBufSize, this.mp3PcmBuffer);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("decoded %d samples: %s", this.mp3DecodedBytes, Utilities.getMemoryDump(this.mp3PcmBuf, this.mp3DecodedBytes)));
                    }
                } else {
                    int fakeSamples = 1;
                    this.mp3DecodedBytes = fakeSamples * this.getBytesPerSample();
                    Memory.getInstance().memset(this.mp3PcmBuf, (byte)0, this.mp3PcmBufSize);
                }
            } else {
                this.mp3DecodedBytes = this.getMp3MaxSamples() * this.getBytesPerSample();
                Memory.getInstance().memset(this.mp3PcmBuf, (byte)0, this.mp3DecodedBytes);
                int mp3BufReadConsumed = Math.min(this.mp3DecodedBytes / 10, this.getMp3AvailableReadSize());
                this.consumeRead(mp3BufReadConsumed);
            }
            return this.mp3DecodedBytes;
        }

        public int getBytesPerSample() {
            return this.getMp3ChannelNum() * 2;
        }

        public boolean isStreamDataNeeded() {
            if (this.isStreamDataEnd()) {
                return false;
            }
            if (sceMp3.this.checkMediaEngineState()) {
                this.checkMediaEngineChannel();
                if (this.mp3Channel.length() >= 229376) {
                    return false;
                }
            }
            return this.getMp3AvailableWriteSize() > 0;
        }

        public boolean isStreamDataEnd() {
            return this.mp3InputFileSize >= this.mp3StreamEnd;
        }

        public int addMp3StreamData(int size) {
            if (sceMp3.this.checkMediaEngineState()) {
                this.mp3Channel.write(this.getMp3BufWriteAddr(), size);
            }
            this.mp3InputFileSize += (long)size;
            return this.consumeWrite(size);
        }

        private int copySamplesToMem(int address, int maxLength, byte[] buffer) {
            Memory mem = Memory.getInstance();
            int bytes = this.me.getCurrentAudioSamples(buffer);
            if (bytes > 0) {
                mem.copyToMemory(address, ByteBuffer.wrap(buffer, 0, bytes), bytes);
            }
            return bytes;
        }

        public int getMp3BufWriteAddr() {
            return this.getMp3BufAddr() + this.getMp3InputBufWritePos();
        }

        public int getMp3LoopNum() {
            return this.mp3LoopNum;
        }

        public int getMp3BufAddr() {
            return this.mp3Buf;
        }

        public int getMp3PcmBufAddr() {
            return this.mp3PcmBuf;
        }

        public int getMp3PcmBufSize() {
            return this.mp3PcmBufSize;
        }

        public int getMp3InputFileReadPos() {
            return this.mp3InputFileReadPos;
        }

        public int getMp3InputBufWritePos() {
            return this.mp3InputBufWritePos;
        }

        public int getMp3BufSize() {
            return this.mp3BufSize;
        }

        public int getMp3DecodedSamples() {
            return this.mp3DecodedBytes / this.getBytesPerSample();
        }

        public int getMp3MaxSamples() {
            return this.mp3MaxSamples;
        }

        public int getMp3BitRate() {
            return this.mp3BitRate;
        }

        public int getMp3ChannelNum() {
            return this.mp3Channels;
        }

        public int getMp3SamplingRate() {
            return this.mp3SampleRate;
        }

        public long getMp3InputFileSize() {
            return this.mp3InputFileSize;
        }

        public void setMp3LoopNum(int n) {
            this.mp3LoopNum = n;
        }

        public void setMp3BufCurrentPos(int pos) {
            this.mp3InputFileReadPos = pos;
            this.mp3InputBufWritePos = pos;
            this.mp3InputBufSize = 0;
            this.mp3InputFileSize = 0L;
            this.mp3DecodedBytes = 0;
        }

        public int getMp3Version() {
            return this.mp3Version;
        }

        public String toString() {
            return String.format("Mp3Stream(maxSize=%d, availableSize=%d, readPos=%d, writePos=%d)", this.mp3BufSize, this.mp3InputBufSize, this.mp3InputFileReadPos, this.mp3InputBufWritePos);
        }
    }

    private class EnableMediaEngineSettingsListerner
    extends AbstractBoolSettingsListener {
        private EnableMediaEngineSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            sceMp3.this.setEnableMediaEngine(value);
        }
    }
}

