/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules150;

import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.types.SceKernelLMOption;
import jpcsp.HLE.kernel.types.SceKernelModuleInfo;
import jpcsp.HLE.kernel.types.SceKernelSMOption;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.HLEModule;
import jpcsp.HLE.modules.HLEModuleManager;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.HLE.modules150.SysMemUserForUser;
import jpcsp.Loader;
import jpcsp.Memory;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.filesystems.umdiso.UmdIsoFile;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class ModuleMgrForUser
extends HLEModule {
    protected static Logger log = Modules.getLogger("ModuleMgrForUser");
    public static final int loadHLEModuleDelay = 1000;

    @Override
    public String getName() {
        return "ModuleMgrForUser";
    }

    private String extractHLEModuleName(String path) {
        String result = "UNKNOWN";
        String sectorString = path.substring(path.indexOf("sce_lbn") + 7, path.indexOf("_size"));
        int PRXStartSector = (int)Utilities.parseHexLong(sectorString);
        try {
            byte[] buffer = Modules.IoFileMgrForUserModule.getIsoReader().readSector(PRXStartSector);
            String libName = new String(buffer);
            int indexSce = libName.indexOf("sce");
            int indexSpace = libName.indexOf(" ");
            if (indexSce >= 0 && indexSpace > indexSce) {
                String module = libName.substring(indexSce, indexSpace);
                if (module.startsWith("sceFont")) {
                    result = "libfont";
                } else if (module.startsWith("sceMpeg")) {
                    result = "mpeg";
                } else if (module.startsWith("sceSAScore")) {
                    result = "sc_sascore";
                } else if (module.startsWith("sceATRAC3plus")) {
                    result = "libatrac3plus";
                }
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return result;
    }

    private int loadHLEModule(String name, String prxname) {
        HLEModuleManager moduleManager = HLEModuleManager.getInstance();
        if (moduleManager.hasFlash0Module(prxname)) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("hleKernelLoadModule(path='%s') HLE module %s loaded", name, prxname));
            }
            return moduleManager.LoadFlash0Module(prxname);
        }
        for (bannedModulesList bannedModuleName : bannedModulesList.values()) {
            if (!bannedModuleName.name().equalsIgnoreCase(prxname.toString())) continue;
            log.warn((Object)String.format("IGNORED:hleKernelLoadModule(path='%s'): module %s from banlist not loaded", name, prxname));
            return moduleManager.LoadFlash0Module(prxname);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int hleKernelLoadHLEModule(String name, StringBuilder prxname) {
        HLEModuleManager moduleManager = HLEModuleManager.getInstance();
        if (prxname == null) {
            prxname = new StringBuilder();
        }
        int findprx = name.lastIndexOf("/");
        int endprx = name.toLowerCase().indexOf(".prx");
        if (endprx >= 0) {
            prxname.append(name.substring(findprx + 1, endprx));
        } else if (name.contains("sce_lbn")) {
            prxname.append(this.extractHLEModuleName(name));
        } else {
            prxname.append("UNKNOWN");
        }
        if (name.startsWith("flash0:")) {
            log.warn((Object)("IGNORED:hleKernelLoadModule(path='" + name + "'): module from flash0 not loaded"));
            return moduleManager.LoadFlash0Module(prxname.toString());
        }
        int result = this.loadHLEModule(name, prxname.toString());
        if (result >= 0) {
            return result;
        }
        SeekableDataInput moduleInput = Modules.IoFileMgrForUserModule.getFile(name, 1);
        if (moduleInput != null) {
            int sceHeaderLength = 64;
            byte[] header = new byte[164];
            try {
                moduleInput.readFully(header);
                ByteBuffer f = ByteBuffer.wrap(header);
                int sceMagic = Utilities.readWord(f);
                if (sceMagic == 1162040190) {
                    f.position(64);
                    int pspMagic = Utilities.readWord(f);
                    if (pspMagic == 1347637374) {
                        f.position(f.position() + 6);
                        String libName = Utilities.readStringZ(f);
                        if (libName != null && libName.length() > 0 && (result = this.loadHLEModule(name, libName)) >= 0) {
                            prxname.setLength(0);
                            prxname.append(libName);
                            int n = result;
                            return n;
                        }
                    }
                }
            }
            catch (IOException e) {
            }
            finally {
                try {
                    moduleInput.close();
                }
                catch (IOException e) {}
            }
        }
        return -1;
    }

    public int hleKernelLoadModule(String name, int flags, int uid, boolean byUid) {
        int result;
        block11: {
            StringBuilder prxname = new StringBuilder();
            result = this.hleKernelLoadHLEModule(name, prxname);
            if (result >= 0) {
                Modules.ThreadManForUserModule.hleKernelDelayThread(1000, false);
                return result;
            }
            try {
                SeekableDataInput moduleInput = Modules.IoFileMgrForUserModule.getFile(name, flags);
                if (moduleInput != null) {
                    SysMemUserForUser.SysMemInfo testInfo;
                    UmdIsoFile umdIsoFile;
                    String realFileName;
                    if (moduleInput instanceof UmdIsoFile && (realFileName = (umdIsoFile = (UmdIsoFile)moduleInput).getName()) != null && !name.endsWith(realFileName) && (result = this.hleKernelLoadHLEModule(realFileName, null)) >= 0) {
                        moduleInput.close();
                        return result;
                    }
                    byte[] moduleBytes = new byte[(int)moduleInput.length()];
                    moduleInput.readFully(moduleBytes);
                    moduleInput.close();
                    ByteBuffer moduleBuffer = ByteBuffer.wrap(moduleBytes);
                    int partitionId = 2;
                    boolean allocType = false;
                    int moduleHeaderSize = 256;
                    SceModule testModule = Loader.getInstance().LoadModule(name, moduleBuffer, 0x8800000, true);
                    moduleBuffer.rewind();
                    int totalAllocSize = 256 + testModule.loadAddressHigh - testModule.loadAddressLow;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Module '%s' requires %d bytes memory", name, totalAllocSize));
                    }
                    if ((testInfo = Modules.SysMemUserForUserModule.malloc(2, "ModuleMgr-TestInfo", 0, totalAllocSize, 0)) == null) {
                        log.error((Object)String.format("Failed module allocation of size 0x%08X for '%s' (maxFreeMemSize=0x%08X)", totalAllocSize, name, Modules.SysMemUserForUserModule.maxFreeMemSize()));
                        return -1;
                    }
                    int testBase = testInfo.addr;
                    Modules.SysMemUserForUserModule.free(testInfo);
                    SysMemUserForUser.SysMemInfo moduleInfo = Modules.SysMemUserForUserModule.malloc(2, "ModuleMgr", 2, 256, testBase);
                    if (moduleInfo == null) {
                        log.error((Object)String.format("Failed module allocation 0x%08X != null for '%s'", testBase, name));
                        return -1;
                    }
                    if (moduleInfo.addr != testBase) {
                        log.error((Object)String.format("Failed module allocation 0x%08X != 0x%08X for '%s'", testBase, moduleInfo.addr, name));
                        return -1;
                    }
                    int moduleBase = moduleInfo.addr;
                    SceModule module = Loader.getInstance().LoadModule(name, moduleBuffer, moduleBase + 256, false);
                    module.load();
                    if ((module.fileFormat & 8) == 8 || (module.fileFormat & 0x10) == 16) {
                        log.info((Object)("hleKernelLoadModule(path='" + name + "') encrypted module not loaded"));
                        SceModule fakeModule = new SceModule(true);
                        fakeModule.addAllocatedMemory(moduleInfo);
                        fakeModule.modname = prxname.toString();
                        fakeModule.write(Memory.getInstance(), moduleInfo.addr);
                        Managers.modules.addModule(fakeModule);
                        result = fakeModule.modid;
                        break block11;
                    }
                    if ((module.fileFormat & 1) == 1) {
                        module.addAllocatedMemory(moduleInfo);
                        result = module.modid;
                        break block11;
                    }
                    return -1;
                }
                log.warn((Object)("hleKernelLoadModule(path='" + name + "') can't find file"));
                return -2147418110;
            }
            catch (IOException e) {
                log.error((Object)("hleKernelLoadModule - Error while loading module " + name + ": " + e.getMessage()));
                return -1;
            }
        }
        return result;
    }

    protected int getSelfModuleId() {
        return Modules.ThreadManForUserModule.getCurrentThread().moduleid;
    }

    @HLEFunction(nid=-1208719848, version=150, checkInsideInterrupt=true)
    public int sceKernelLoadModuleByID(int uid, @CanBeNull TPointer optionAddr) {
        String name = Modules.IoFileMgrForUserModule.getFileFilename(uid);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelLoadModuleByID uid=0x%X('%s'), optionAddr=%s", uid, name, optionAddr));
        }
        SceKernelLMOption lmOption = null;
        if (optionAddr.isNotNull()) {
            lmOption = new SceKernelLMOption();
            lmOption.read(Memory.getInstance(), optionAddr.getAddress());
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceKernelLoadModule: partition=%d, position=%d", lmOption.mpidText, lmOption.position));
            }
        }
        return this.hleKernelLoadModule(name, 0, uid, true);
    }

    @HLEFunction(nid=-1753357434, version=150, checkInsideInterrupt=true)
    public int sceKernelLoadModule(PspString path, int flags, @CanBeNull TPointer optionAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelLoadModule path=%s, flags=0x%X, optionAddr=%s", path, flags, optionAddr));
        }
        SceKernelLMOption lmOption = null;
        if (optionAddr.isNotNull()) {
            lmOption = new SceKernelLMOption();
            lmOption.read(optionAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceKernelLoadModule: partition=%d, position=%d", lmOption.mpidText, lmOption.position));
            }
        }
        return this.hleKernelLoadModule(path.getString(), flags, 0, false);
    }

    @HLEUnimplemented
    @HLEFunction(nid=1896833461, version=150, checkInsideInterrupt=true)
    public int sceKernelLoadModuleMs() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-114860648, version=150, checkInsideInterrupt=true)
    public int sceKernelLoadModuleBufferUsbWlan() {
        return 0;
    }

    @HLEFunction(nid=1357955564, version=150, checkInsideInterrupt=true)
    public int sceKernelStartModule(int uid, int argSize, @CanBeNull TPointer argp, @CanBeNull TPointer32 statusAddr, @CanBeNull TPointer optionAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelStartModule uid=0x%X, argSize=%d, argp=%s, statusAddr=%s, optionAddr=%s", uid, argSize, argp, statusAddr, optionAddr));
        }
        SceModule sceModule = Managers.modules.getModuleByUID(uid);
        SceKernelSMOption smOption = null;
        if (optionAddr.isNotNull()) {
            smOption = new SceKernelSMOption();
            smOption.read(optionAddr);
        }
        if (sceModule == null) {
            log.warn((Object)String.format("sceKernelStartModule - unknown module UID 0x%X", uid));
            return -2147352274;
        }
        statusAddr.setValue(0);
        if (sceModule.isFlashModule) {
            if (HLEModuleManager.getInstance().hasFlash0Module(sceModule.modname)) {
                log.info((Object)String.format("IGNORING:sceKernelStartModule HLE module '%s'", sceModule.modname));
            } else {
                log.warn((Object)String.format("IGNORING:sceKernelStartModule flash module '%s'", sceModule.modname));
            }
            sceModule.start();
            return sceModule.modid;
        }
        if (HLEModuleManager.getInstance().hasFlash0Module(sceModule.modname)) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceKernelStartModule - loading missing HLE module '%s' (was loaded as ELF)", sceModule.modname));
            }
            HLEModuleManager.getInstance().LoadFlash0Module(sceModule.modname);
            sceModule.start();
            return sceModule.modid;
        }
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        int attribute = sceModule.attribute;
        int entryAddr = sceModule.entry_addr;
        if (entryAddr == -1) {
            log.info((Object)"sceKernelStartModule - module has no entry point, trying to use module_start_func");
            entryAddr = sceModule.module_start_func;
            attribute = sceModule.module_start_thread_attr;
        }
        if (Memory.isAddressGood(entryAddr)) {
            int priority = 32;
            if (smOption != null && smOption.priority > 0) {
                priority = smOption.priority;
            } else if (sceModule.module_start_thread_priority > 0) {
                priority = sceModule.module_start_thread_priority;
            }
            int stackSize = 262144;
            if (smOption != null && smOption.stackSize > 0) {
                stackSize = smOption.stackSize;
            } else if (sceModule.module_start_thread_stacksize > 0) {
                stackSize = sceModule.module_start_thread_stacksize;
            }
            if (smOption != null) {
                attribute = smOption.attribute;
            }
            SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
            SceKernelThreadInfo thread = threadMan.hleKernelCreateThread("SceModmgrStart", entryAddr, priority, stackSize, attribute, 0);
            thread.moduleid = sceModule.modid;
            thread.exitStatusAddr = statusAddr;
            sceModule.start();
            threadMan.hleKernelStartThread(thread, argSize, argp.getAddress(), sceModule.gp_value);
            threadMan.hleKernelWaitThreadEnd(currentThread, thread.uid, 0, false, false);
        } else if (entryAddr == 0) {
            Modules.log.info((Object)"sceKernelStartModule - no entry address");
            sceModule.start();
        } else {
            log.warn((Object)String.format("sceKernelStartModule - invalid entry address 0x%08X", entryAddr));
            return -1;
        }
        return sceModule.modid;
    }

    @HLEFunction(nid=-771778518, version=150, checkInsideInterrupt=true)
    public int sceKernelStopModule(int uid, int argSize, @CanBeNull TPointer argp, @CanBeNull TPointer32 statusAddr, @CanBeNull TPointer optionAddr) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("sceKernelStopModule uid=0x%X, argSize=%d, argp=%s, statusAddr=%s, optionAddr=%s", uid, argSize, argp, statusAddr, optionAddr));
        }
        SceModule sceModule = Managers.modules.getModuleByUID(uid);
        SceKernelSMOption smOption = null;
        if (optionAddr.isNotNull()) {
            smOption = new SceKernelSMOption();
            smOption.read(optionAddr);
        }
        if (sceModule == null) {
            log.warn((Object)("sceKernelStopModule - unknown module UID 0x" + Integer.toHexString(uid)));
            return -2147352274;
        }
        statusAddr.setValue(0);
        if (sceModule.isFlashModule) {
            if (HLEModuleManager.getInstance().hasFlash0Module(sceModule.modname)) {
                log.info((Object)("IGNORING:sceKernelStopModule HLE module '" + sceModule.modname + "'"));
            } else {
                log.warn((Object)("IGNORING:sceKernelStopModule flash module '" + sceModule.modname + "'"));
            }
            sceModule.stop();
            return 0;
        }
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        if (Memory.isAddressGood(sceModule.module_stop_func)) {
            int priority = 32;
            if (smOption != null && smOption.priority > 0) {
                priority = smOption.priority;
            } else if (sceModule.module_stop_thread_priority > 0) {
                priority = sceModule.module_stop_thread_priority;
            }
            int stackSize = 262144;
            if (smOption != null && smOption.stackSize > 0) {
                stackSize = smOption.stackSize;
            } else if (sceModule.module_stop_thread_stacksize > 0) {
                stackSize = sceModule.module_stop_thread_stacksize;
            }
            int attribute = sceModule.module_stop_thread_attr;
            if (smOption != null) {
                attribute = smOption.attribute;
            }
            SceKernelThreadInfo thread = threadMan.hleKernelCreateThread("SceModmgrStop", sceModule.module_stop_func, priority, stackSize, attribute, 0);
            thread.moduleid = sceModule.modid;
            thread.exitStatusAddr = statusAddr;
            sceModule.stop();
            threadMan.hleKernelStartThread(thread, argSize, argp.getAddress(), sceModule.gp_value);
        } else if (sceModule.module_stop_func == 0) {
            log.info((Object)"sceKernelStopModule - module has no stop function");
            sceModule.stop();
        } else {
            if (sceModule.isModuleStopped()) {
                log.warn((Object)"sceKernelStopModule - module already stopped");
                return -2147352267;
            }
            log.warn((Object)String.format("sceKernelStopModule - invalid stop function 0x%08X", sceModule.module_stop_func));
            return -1;
        }
        return 0;
    }

    @HLEFunction(nid=772346282, version=150, checkInsideInterrupt=true)
    public int sceKernelUnloadModule(int uid) {
        SceModule sceModule;
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("sceKernelUnloadModule uid=0x%X", uid));
        }
        if ((sceModule = Managers.modules.getModuleByUID(uid)) == null) {
            log.warn((Object)String.format("sceKernelUnloadModule unknown module UID 0x%X", uid));
            return -1;
        }
        if (sceModule.isModuleStarted() && !sceModule.isModuleStopped()) {
            log.warn((Object)String.format("sceKernelUnloadModule module 0x%X is still running!", uid));
            return -2147352264;
        }
        HLEModuleManager.getInstance().UnloadFlash0Module(sceModule);
        return sceModule.modid;
    }

    @HLEFunction(nid=-696915016, version=150, checkInsideInterrupt=true)
    public int sceKernelSelfStopUnloadModule(int argSize, @CanBeNull TPointer argp, @CanBeNull TPointer32 statusAddr, @CanBeNull TPointer optionAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelSelfStopUnloadModule argSize=%d, argp=%s, statusAddr=%s, optionAddr=%s", argSize, argp, statusAddr, optionAddr));
        }
        SceModule sceModule = Managers.modules.getModuleByUID(this.getSelfModuleId());
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        SceKernelThreadInfo thread = null;
        statusAddr.setValue(0);
        if (Memory.isAddressGood(sceModule.module_stop_func)) {
            thread = threadMan.hleKernelCreateThread("SceModmgrStop", sceModule.module_stop_func, sceModule.module_stop_thread_priority, sceModule.module_stop_thread_stacksize, sceModule.module_stop_thread_attr, optionAddr.getAddress());
            thread.moduleid = sceModule.modid;
            thread.exitStatusAddr = statusAddr;
        }
        sceModule.stop();
        sceModule.unload();
        threadMan.hleKernelExitDeleteThread();
        if (thread != null) {
            threadMan.hleKernelStartThread(thread, argSize, argp.getAddress(), sceModule.gp_value);
        }
        return 0;
    }

    @HLEFunction(nid=-1892812992, version=150, checkInsideInterrupt=true)
    public int sceKernelStopUnloadSelfModuleWithStatus(int exitCode, int argSize, @CanBeNull TPointer argp, @CanBeNull TPointer32 statusAddr, @CanBeNull TPointer optionAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelStopUnloadSelfModuleWithStatus exitCode=0x%X, argSize=%d, argp=%s, statusAddr=%s, optionAddr=%s", exitCode, argSize, argp, statusAddr, optionAddr));
        }
        SceModule sceModule = Managers.modules.getModuleByUID(this.getSelfModuleId());
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        SceKernelThreadInfo thread = null;
        statusAddr.setValue(0);
        if (Memory.isAddressGood(sceModule.module_stop_func)) {
            statusAddr.setValue(0);
            thread = threadMan.hleKernelCreateThread("SceModmgrStop", sceModule.module_stop_func, sceModule.module_stop_thread_priority, sceModule.module_stop_thread_stacksize, sceModule.module_stop_thread_attr, optionAddr.getAddress());
            thread.moduleid = sceModule.modid;
            thread.exitStatusAddr = statusAddr;
            threadMan.getCurrentThread().exitStatus = exitCode;
        }
        sceModule.stop();
        sceModule.unload();
        threadMan.hleKernelExitDeleteThread();
        if (thread != null) {
            threadMan.hleKernelStartThread(thread, argSize, argp.getAddress(), sceModule.gp_value);
        }
        return 0;
    }

    @HLEFunction(nid=-870500711, version=150, checkInsideInterrupt=true)
    public int sceKernelStopUnloadSelfModule(int argSize, @CanBeNull TPointer argp, @CanBeNull TPointer32 statusAddr, @CanBeNull TPointer optionAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelStopUnloadSelfModule argSize=%d, argp=%s, statusAddr=%s, optionAddr=%s", argSize, argp, statusAddr, optionAddr));
        }
        SceModule sceModule = Managers.modules.getModuleByUID(this.getSelfModuleId());
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        SceKernelThreadInfo thread = null;
        statusAddr.setValue(0);
        if (Memory.isAddressGood(sceModule.module_stop_func)) {
            thread = threadMan.hleKernelCreateThread("SceModmgrStop", sceModule.module_stop_func, sceModule.module_stop_thread_priority, sceModule.module_stop_thread_stacksize, sceModule.module_stop_thread_attr, optionAddr.getAddress());
            thread.moduleid = sceModule.modid;
            thread.exitStatusAddr = statusAddr;
        }
        sceModule.stop();
        sceModule.unload();
        threadMan.hleKernelExitDeleteThread();
        if (thread != null) {
            threadMan.hleKernelStartThread(thread, argSize, argp.getAddress(), sceModule.gp_value);
        }
        return 0;
    }

    @HLEFunction(nid=1682150882, version=150, checkInsideInterrupt=true)
    public int sceKernelGetModuleIdList(TPointer32 resultBuffer, int resultBufferSize, TPointer32 idCountAddr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelGetModuleIdList readBuf=%s, readBufSize=%d, idCountAddr=%s", resultBuffer, resultBufferSize, idCountAddr));
        }
        int idCount = 0;
        int resultBufferOffset = 0;
        for (SceModule module : Managers.modules.values()) {
            if (module.isFlashModule || !module.isLoaded) continue;
            if (resultBufferOffset < resultBufferSize) {
                resultBuffer.setValue(resultBufferOffset, module.modid);
                resultBufferOffset += 4;
            }
            ++idCount;
        }
        idCountAddr.setValue(idCount);
        return 0;
    }

    @HLEFunction(nid=1955380953, version=150, checkInsideInterrupt=true)
    public int sceKernelQueryModuleInfo(int uid, TPointer infoAddr) {
        SceModule sceModule;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelQueryModuleInfo uid=0x%X, infoAddr=%s", uid, infoAddr));
        }
        if ((sceModule = Managers.modules.getModuleByUID(uid)) == null) {
            log.warn((Object)("sceKernelQueryModuleInfo unknown module UID 0x" + Integer.toHexString(uid)));
            return -1;
        }
        SceKernelModuleInfo moduleInfo = new SceKernelModuleInfo();
        moduleInfo.copy(sceModule);
        moduleInfo.write(infoAddr);
        return 0;
    }

    @HLEFunction(nid=-257793131, version=150, checkInsideInterrupt=true)
    public int sceKernelGetModuleId() {
        int moduleId = this.getSelfModuleId();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelGetModuleId returning 0x%X", moduleId));
        }
        return moduleId;
    }

    @HLEFunction(nid=-659082969, version=150, checkInsideInterrupt=true)
    public int sceKernelGetModuleIdByAddress(TPointer addr) {
        SceModule module;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelGetModuleIdByAddress addr=%s", addr));
        }
        if ((module = Managers.modules.getModuleByAddress(addr.getAddress())) == null) {
            log.warn((Object)String.format("sceKernelGetModuleIdByAddress addr=%s module not found", addr));
            return -1;
        }
        return module.modid;
    }

    static enum bannedModulesList {
        audiocodec,
        sceAudiocodec_Driver,
        videocodec,
        sceVideocodec_Driver,
        mpegbase,
        sceMpegbase_Driver,
        pspnet_adhoc_download,
        pspnet_ap_dialog_dummy,
        sceNetApDialogDummy_Library,
        libparse_uri,
        libparse_http;

    }
}

