/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.util.HashMap;
import jpcsp.HLE.Modules;
import jpcsp.HLE.modules.HLEModuleFunction;
import jpcsp.settings.ISettingsListener;
import jpcsp.settings.Settings;

public abstract class HLEModule {
    public HashMap<String, HLEModuleFunction> installedHLEModuleFunctions = new HashMap();

    public abstract String getName();

    public HLEModuleFunction getHleFunctionByName(String functionName) throws RuntimeException {
        if (!this.installedHLEModuleFunctions.containsKey(functionName)) {
            Modules.log.error((Object)String.format("Can't find hle function '%s' on module '%s'", functionName, this.getName()));
            return null;
        }
        return this.installedHLEModuleFunctions.get(functionName);
    }

    public void start() {
    }

    public void stop() {
        Settings.getInstance().removeSettingsListener(this.getName());
    }

    protected void setSettingsListener(String option, ISettingsListener settingsListener) {
        Settings.getInstance().registerSettingsListener(this.getName(), option, settingsListener);
    }

    protected static String getCallingFunctionName(int index) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        return stack[index + 1].getMethodName();
    }
}

