/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types.interrupts;

import java.util.LinkedList;
import java.util.List;
import jpcsp.Emulator;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.interrupts.AbstractInterruptHandler;
import jpcsp.scheduler.Scheduler;

public class VBlankInterruptHandler
extends AbstractInterruptHandler {
    private List<IAction> vblankActions = new LinkedList<IAction>();
    private List<IAction> vblankActionsOnce = new LinkedList<IAction>();
    private long nextVblankSchedule = 16667L;

    @Override
    protected void executeInterrupt() {
        Scheduler scheduler = Emulator.getScheduler();
        scheduler.addAction(this.nextVblankSchedule, this);
        this.nextVblankSchedule += 16667L;
        long now = Scheduler.getNow();
        while (this.nextVblankSchedule < now) {
            this.nextVblankSchedule += 16667L;
        }
        for (IAction action : this.vblankActions) {
            if (action == null) continue;
            action.execute();
        }
        for (IAction action : this.vblankActionsOnce) {
            if (action == null) continue;
            action.execute();
        }
        this.vblankActionsOnce.clear();
        IntrManager.getInstance().triggerInterrupt(30, null, null);
    }

    public void addVBlankAction(IAction action) {
        this.vblankActions.add(action);
    }

    public boolean removeVBlankAction(IAction action) {
        return this.vblankActions.remove(action);
    }

    public void addVBlankActionOnce(IAction action) {
        this.vblankActionsOnce.add(action);
    }

    public boolean removeVBlankActionOnce(IAction action) {
        return this.vblankActionsOnce.remove(action);
    }
}

