/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.HLE.kernel.types.pspUtilityDialogCommon;

public class SceUtilityMsgDialogParams
extends pspAbstractMemoryMappedStructure {
    public pspUtilityDialogCommon base = new pspUtilityDialogCommon();
    public int result;
    public int mode;
    public static final int PSP_UTILITY_MSGDIALOG_MODE_ERROR = 0;
    public static final int PSP_UTILITY_MSGDIALOG_MODE_TEXT = 1;
    public int errorValue;
    public String message;
    public int options;
    public static final int PSP_UTILITY_MSGDIALOG_OPTION_ERROR = 0;
    public static final int PSP_UTILITY_MSGDIALOG_OPTION_NORMAL = 1;
    public static final int PSP_UTILITY_MSGDIALOG_OPTION_ALLOW_SOUND = 0;
    public static final int PSP_UTILITY_MSGDIALOG_OPTION_MUTE_SOUND = 2;
    public static final int PSP_UTILITY_MSGDIALOG_OPTION_BUTTON_TYPE_NONE = 0;
    public static final int PSP_UTILITY_MSGDIALOG_OPTION_BUTTON_TYPE_YESNO = 16;
    public static final int PSP_UTILITY_MSGDIALOG_OPTION_BUTTON_TYPE_OK = 32;
    public static final int PSP_UTILITY_MSGDIALOG_OPTION_ENABLE_CANCEL = 0;
    public static final int PSP_UTILITY_MSGDIALOG_OPTION_DISABLE_CANCEL = 128;
    public static final int PSP_UTILITY_MSGDIALOG_OPTION_YESNO_DEFAULT_MASK = 256;
    public static final int PSP_UTILITY_MSGDIALOG_OPTION_YESNO_DEFAULT_NONE = 0;
    public static final int PSP_UTILITY_MSGDIALOG_OPTION_YESNO_DEFAULT_YES = 0;
    public static final int PSP_UTILITY_MSGDIALOG_OPTION_YESNO_DEFAULT_NO = 256;
    public static final int PSP_UTILITY_MSGDIALOG_OPTION_YESNO_DEFAULT_OK = 0;
    public int buttonPressed;
    public static final int PSP_UTILITY_BUTTON_PRESSED_INVALID = 0;
    public static final int PSP_UTILITY_BUTTON_PRESSED_YES = 1;
    public static final int PSP_UTILITY_BUTTON_PRESSED_OK = 1;
    public static final int PSP_UTILITY_BUTTON_PRESSED_NO = 2;
    public static final int PSP_UTILITY_BUTTON_PRESSED_ESC = 3;

    @Override
    protected void read() {
        this.base = new pspUtilityDialogCommon();
        this.read(this.base);
        this.setMaxSize(this.base.totalSizeof());
        this.result = this.read32();
        this.mode = this.read32();
        this.errorValue = this.read32();
        this.message = this.readStringNZ(512);
        this.options = this.read32();
        this.buttonPressed = this.read32();
    }

    @Override
    protected void write() {
        this.write(this.base);
        this.setMaxSize(this.base.totalSizeof());
        this.write32(this.result);
        this.write32(this.mode);
        this.write32(this.errorValue);
        this.writeStringNZ(512, this.message);
        this.write32(this.options);
        this.write32(this.buttonPressed);
    }

    @Override
    public int sizeof() {
        return this.base.totalSizeof();
    }

    public boolean isOptionYesNoDefaultYes() {
        if ((this.options & 0x10) == 16) {
            return (this.options & 0x100) == 0;
        }
        return false;
    }

    public boolean isOptionYesNoDefaultNo() {
        if ((this.options & 0x10) == 16) {
            return (this.options & 0x100) == 256;
        }
        return false;
    }

    public boolean isOptionYesNo() {
        return this.isOptionYesNoDefaultYes() || this.isOptionYesNoDefaultNo();
    }

    public boolean isOptionOk() {
        return (this.options & 0x20) == 32;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("result " + String.format("0x%08X", this.result) + "\n");
        sb.append("mode " + (this.mode == 0 ? "PSP_UTILITY_MSGDIALOG_MODE_ERROR" : (this.mode == 1 ? "PSP_UTILITY_MSGDIALOG_MODE_TEXT" : String.format("0x%08X", this.mode))) + "\n");
        sb.append("errorValue " + String.format("0x%08X", this.errorValue) + "\n");
        sb.append("message '" + this.message + "'\n");
        sb.append("options " + String.format("0x%08X", this.options) + "\n");
        if (this.isOptionYesNoDefaultYes()) {
            sb.append("options PSP_UTILITY_MSGDIALOG_OPTION_YESNO_DEFAULT_YES\n");
        }
        if (this.isOptionYesNoDefaultNo()) {
            sb.append("options PSP_UTILITY_MSGDIALOG_OPTION_YESNO_DEFAULT_NO\n");
        }
        sb.append("buttonPressed " + String.format("0x%08X", this.buttonPressed));
        return sb.toString();
    }
}

