/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.types.MemoryChunk;
import jpcsp.util.Utilities;

public class MemoryChunkList {
    private MemoryChunk low;
    private MemoryChunk high;

    public MemoryChunkList(MemoryChunk initialMemoryChunk) {
        this.low = initialMemoryChunk;
        this.high = initialMemoryChunk;
    }

    public void remove(MemoryChunk memoryChunk) {
        if (memoryChunk.previous != null) {
            memoryChunk.previous.next = memoryChunk.next;
        }
        if (memoryChunk.next != null) {
            memoryChunk.next.previous = memoryChunk.previous;
        }
        if (this.low == memoryChunk) {
            this.low = memoryChunk.next;
        }
        if (this.high == memoryChunk) {
            this.high = memoryChunk.previous;
        }
    }

    public int allocLow(int size, int addrAlignment) {
        MemoryChunk memoryChunk = this.low;
        while (memoryChunk != null) {
            if (memoryChunk.isAvailable(size, addrAlignment)) {
                return this.allocLow(memoryChunk, size, addrAlignment);
            }
            memoryChunk = memoryChunk.next;
        }
        return 0;
    }

    public int allocHigh(int size, int addrAlignment) {
        MemoryChunk memoryChunk = this.high;
        while (memoryChunk != null) {
            if (memoryChunk.isAvailable(size, addrAlignment)) {
                return this.allocHigh(memoryChunk, size, addrAlignment);
            }
            memoryChunk = memoryChunk.previous;
        }
        return 0;
    }

    public int alloc(int addr, int size) {
        MemoryChunk memoryChunk = this.low;
        while (memoryChunk != null) {
            if (memoryChunk.addr <= addr && addr < memoryChunk.addr + memoryChunk.size) {
                return this.alloc(memoryChunk, addr, size);
            }
            memoryChunk = memoryChunk.next;
        }
        return 0;
    }

    private int allocLow(MemoryChunk memoryChunk, int size, int addrAlignment) {
        int addr = Utilities.alignUp(memoryChunk.addr, addrAlignment);
        return this.alloc(memoryChunk, addr, size);
    }

    private int allocHigh(MemoryChunk memoryChunk, int size, int addrAlignment) {
        int addr = Utilities.alignDown(memoryChunk.addr + memoryChunk.size, addrAlignment) - size;
        return this.alloc(memoryChunk, addr, size);
    }

    private int alloc(MemoryChunk memoryChunk, int addr, int size) {
        if (addr < memoryChunk.addr || memoryChunk.addr + memoryChunk.size < addr + size) {
            return 0;
        }
        if (memoryChunk.size == size) {
            this.remove(memoryChunk);
        } else if (memoryChunk.addr == addr) {
            memoryChunk.size -= size;
            memoryChunk.addr += size;
        } else if (memoryChunk.addr + memoryChunk.size == addr + size) {
            memoryChunk.size -= size;
        } else {
            int lowSize = addr - memoryChunk.addr;
            int highSize = memoryChunk.size - lowSize - size;
            MemoryChunk highMemoryChunk = new MemoryChunk(addr + size, highSize);
            memoryChunk.size = lowSize;
            this.addAfter(highMemoryChunk, memoryChunk);
        }
        return addr;
    }

    private void addAfter(MemoryChunk memoryChunk, MemoryChunk reference) {
        memoryChunk.previous = reference;
        memoryChunk.next = reference.next;
        reference.next = memoryChunk;
        if (memoryChunk.next != null) {
            memoryChunk.next.previous = memoryChunk;
        }
        if (this.high == reference) {
            this.high = memoryChunk;
        }
    }

    private void addBefore(MemoryChunk memoryChunk, MemoryChunk reference) {
        memoryChunk.previous = reference.previous;
        memoryChunk.next = reference;
        reference.previous = memoryChunk;
        if (memoryChunk.previous != null) {
            memoryChunk.previous.next = memoryChunk;
        }
        if (this.low == reference) {
            this.low = memoryChunk;
        }
    }

    public void add(MemoryChunk memoryChunk) {
        MemoryChunk scanChunk = this.low;
        while (scanChunk != null) {
            if (scanChunk.addr + scanChunk.size == memoryChunk.addr) {
                scanChunk.size += memoryChunk.size;
                MemoryChunk nextChunk = scanChunk.next;
                if (nextChunk != null && scanChunk.addr + scanChunk.size == nextChunk.addr) {
                    scanChunk.size += nextChunk.size;
                    this.remove(nextChunk);
                }
                return;
            }
            if (memoryChunk.addr + memoryChunk.size == scanChunk.addr) {
                scanChunk.addr = memoryChunk.addr;
                scanChunk.size += memoryChunk.size;
                MemoryChunk previousChunk = scanChunk.previous;
                if (previousChunk != null && previousChunk.addr + previousChunk.size == scanChunk.addr) {
                    previousChunk.size += scanChunk.size;
                    this.remove(scanChunk);
                }
                return;
            }
            if (scanChunk.addr > memoryChunk.addr) {
                this.addBefore(memoryChunk, scanChunk);
                return;
            }
            scanChunk = scanChunk.next;
        }
        if (this.high == null && this.low == null) {
            this.high = memoryChunk;
            this.low = memoryChunk;
        } else {
            this.addAfter(memoryChunk, this.high);
        }
    }

    public MemoryChunk getLowMemoryChunk() {
        return this.low;
    }

    public MemoryChunk getHighMemoryChunk() {
        return this.high;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        MemoryChunk memoryChunk = this.low;
        while (memoryChunk != null) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(memoryChunk.toString());
            memoryChunk = memoryChunk.next;
        }
        return result.toString();
    }
}

