/*
 * Decompiled with CFR 0.152.
 */
package jpcsp;

public class Clock {
    private long baseNanos;
    private long pauseNanos;
    private long baseTimeMillis;
    private boolean isPaused;

    public Clock() {
        this.reset();
    }

    public synchronized void pause() {
        if (!this.isPaused) {
            this.pauseNanos = System.nanoTime();
            this.isPaused = true;
        }
    }

    public synchronized void resume() {
        if (this.isPaused) {
            this.baseNanos += System.nanoTime() - this.pauseNanos;
            this.isPaused = false;
        }
    }

    public synchronized void reset() {
        this.baseNanos = System.nanoTime();
        this.baseTimeMillis = System.currentTimeMillis();
        this.pauseNanos = this.baseNanos;
        this.isPaused = true;
    }

    public long nanoTime() {
        long now = this.isPaused ? this.pauseNanos : System.nanoTime();
        return now - this.baseNanos;
    }

    public long milliTime() {
        return this.nanoTime() / 1000000L;
    }

    public long microTime() {
        return this.nanoTime() / 1000L;
    }

    public long currentTimeMillis() {
        return this.baseTimeMillis + this.milliTime();
    }

    public TimeNanos currentTimeNanos() {
        long nanoTime = this.nanoTime();
        long currentTimeMillis = this.baseTimeMillis + nanoTime / 1000000L;
        TimeNanos timeNano = new TimeNanos();
        timeNano.nanos = (int)(nanoTime % 1000L);
        timeNano.micros = (int)(nanoTime / 1000L % 1000L);
        timeNano.millis = (int)(currentTimeMillis % 1000L);
        timeNano.seconds = (int)(currentTimeMillis / 1000L);
        return timeNano;
    }

    public static class TimeNanos {
        public int seconds;
        public int millis;
        public int micros;
        public int nanos;
    }
}

