/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler.nativeCode;

import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Allegrex.compiler.nativeCode.AbstractNativeCodeSequence;
import jpcsp.Allegrex.compiler.nativeCode.INativeCodeSequence;

public class MemcpySequence
extends AbstractNativeCodeSequence
implements INativeCodeSequence {
    public static void call(int dstAddrReg, int srcAddrReg, int lengthReg) {
        int[] gpr = MemcpySequence.getGpr();
        int dstAddr = gpr[dstAddrReg];
        int srcAddr = gpr[srcAddrReg];
        int length = gpr[lengthReg];
        MemcpySequence.getMemory().memcpy(dstAddr, srcAddr, length);
        gpr[dstAddrReg] = dstAddr + length;
        gpr[srcAddrReg] = srcAddr + length;
        gpr[lengthReg] = 0;
    }

    public static void call(int dstAddrReg, int srcAddrReg, int lengthReg, int dstOffset, int srcOffset) {
        int[] gpr = MemcpySequence.getGpr();
        int dstAddr = gpr[dstAddrReg];
        int srcAddr = gpr[srcAddrReg];
        int length = gpr[lengthReg];
        MemcpySequence.getMemory().memcpy(dstAddr + dstOffset, srcAddr + srcOffset, length);
        gpr[dstAddrReg] = dstAddr + length;
        gpr[srcAddrReg] = srcAddr + length;
        gpr[lengthReg] = 0;
    }

    public static void call(int dstAddrReg, int srcAddrReg, int targetAddrReg, int targetReg) {
        int[] gpr = MemcpySequence.getGpr();
        int dstAddr = gpr[dstAddrReg];
        int srcAddr = gpr[srcAddrReg];
        int targetAddr = gpr[targetAddrReg];
        int length = targetAddr - gpr[targetReg];
        MemcpySequence.getMemory().memcpy(dstAddr, srcAddr, length);
        gpr[dstAddrReg] = dstAddr + length;
        gpr[srcAddrReg] = srcAddr + length;
    }

    public static void call(int dstAddrReg, int srcAddrReg, int targetAddrReg, int targetReg, int dstOffset, int srcOffset, int valueReg, int valueBytes) {
        int value;
        int[] gpr = MemcpySequence.getGpr();
        int dstAddr = gpr[dstAddrReg];
        int srcAddr = gpr[srcAddrReg];
        int targetAddr = gpr[targetAddrReg];
        int length = targetAddr - gpr[targetReg];
        MemcpySequence.getMemory().memcpy(dstAddr + dstOffset, srcAddr + srcOffset, length);
        gpr[dstAddrReg] = dstAddr + length;
        gpr[srcAddrReg] = srcAddr + length;
        int valueAddr = srcAddr + length - valueBytes;
        switch (valueBytes) {
            case 1: {
                value = MemcpySequence.getMemory().read8(valueAddr);
                break;
            }
            case 2: {
                value = MemcpySequence.getMemory().read16(valueAddr);
                break;
            }
            case 4: {
                value = MemcpySequence.getMemory().read32(valueAddr);
                break;
            }
            default: {
                value = 0;
                Compiler.log.error((Object)("MemcpySequence.call(): Unimplemented valueBytes=" + valueBytes));
            }
        }
        gpr[valueReg] = value;
    }

    public static void callWithStep(int dstAddrReg, int srcAddrReg, int lengthReg, int step, int lengthOffset) {
        int[] gpr = MemcpySequence.getGpr();
        int dstAddr = gpr[dstAddrReg];
        int srcAddr = gpr[srcAddrReg];
        int length = (gpr[lengthReg] + lengthOffset) * step;
        MemcpySequence.getMemory().memcpy(dstAddr, srcAddr, length);
        gpr[dstAddrReg] = dstAddr + length;
        gpr[srcAddrReg] = srcAddr + length;
        gpr[lengthReg] = 0;
    }

    public static void callWithCountStep(int dstAddrReg, int srcAddrReg, int lengthReg, int count, int step) {
        int[] gpr = MemcpySequence.getGpr();
        int dstAddr = gpr[dstAddrReg];
        int srcAddr = gpr[srcAddrReg];
        int length = (count - gpr[lengthReg]) * step;
        MemcpySequence.getMemory().memcpy(dstAddr, srcAddr, length);
        gpr[dstAddrReg] = dstAddr + length;
        gpr[srcAddrReg] = srcAddr + length;
        gpr[lengthReg] = count;
    }

    public static void callFixedLength(int dstAddrReg, int srcAddrReg, int dstOffset, int srcOffset, int length) {
        int dstAddr = MemcpySequence.getRegisterValue(dstAddrReg) + dstOffset;
        int srcAddr = MemcpySequence.getRegisterValue(srcAddrReg) + srcOffset;
        MemcpySequence.getMemory().memcpy(dstAddr, srcAddr, length);
    }

    public static void callFixedLength(int dstAddrReg, int srcAddrReg, int dstOffset, int srcOffset, int length, int updatedSrcAddrReg) {
        int dstAddr = MemcpySequence.getRegisterValue(dstAddrReg) + dstOffset;
        int srcAddr = MemcpySequence.getRegisterValue(srcAddrReg) + srcOffset;
        MemcpySequence.getMemory().memcpy(dstAddr, srcAddr, length);
        MemcpySequence.setRegisterValue(updatedSrcAddrReg, srcAddr);
    }

    public static void callIndirectLength(int dstAddrReg, int srcAddrReg, int lengthAddrReg, int lengthAddrOffset) {
        int[] gpr = MemcpySequence.getGpr();
        int dstAddr = gpr[dstAddrReg];
        int srcAddr = gpr[srcAddrReg];
        int length = MemcpySequence.getMemory().read32(MemcpySequence.getRegisterValue(lengthAddrReg) + lengthAddrOffset);
        MemcpySequence.getMemory().memcpy(dstAddr, srcAddr, length);
        gpr[dstAddrReg] = dstAddr + length;
        gpr[srcAddrReg] = srcAddr + length;
    }
}

