/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.xuggler.Helper;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.Utils;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoPictureTest
extends TestCase {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Before
    public void setUp() {
        this.log.debug("Executing test case: {}", (Object)this.getName());
    }

    @Test
    public void testFrameCreationFromBuffer() {
        int width = 100;
        int height = 100;
        IPixelFormat.Type format = IPixelFormat.Type.BGR24;
        IBuffer buffer = IBuffer.make(null, (int)(width * height * 3));
        byte[] bytes = new byte[1];
        for (int i = 0; i < buffer.getBufferSize(); ++i) {
            bytes[0] = (byte)i;
            buffer.put(bytes, 0, i, 1);
        }
        IVideoPicture picture = IVideoPicture.make((IBuffer)buffer, (IPixelFormat.Type)format, (int)width, (int)height);
        VideoPictureTest.assertNotNull((Object)picture);
        VideoPictureTest.assertEquals((int)buffer.getBufferSize(), (int)picture.getSize());
        for (int i = 0; i < picture.getSize(); ++i) {
            picture.get(i, bytes, 0, 1);
            VideoPictureTest.assertEquals((byte)((byte)i), (byte)bytes[0]);
        }
    }

    @Test
    public void testFrameCreation() {
        IVideoPicture frame = null;
        frame = IVideoPicture.make((IPixelFormat.Type)IPixelFormat.Type.RGB24, (int)320, (int)240);
        VideoPictureTest.assertTrue((String)"could not get frame", (frame != null ? 1 : 0) != 0);
        VideoPictureTest.assertTrue((String)"should default to keyframe", (boolean)frame.isKeyFrame());
        VideoPictureTest.assertTrue((String)"should not be complete", (!frame.isComplete() ? 1 : 0) != 0);
        VideoPictureTest.assertEquals((String)"wrong width", (int)frame.getWidth(), (int)320);
        VideoPictureTest.assertEquals((String)"wrong height", (int)frame.getHeight(), (int)240);
        VideoPictureTest.assertEquals((String)"wrong format", (Object)frame.getPixelType(), (Object)IPixelFormat.Type.RGB24);
        frame.delete();
        frame = null;
    }

    @Test
    public void testReadingFrames() {
        Helper h = new Helper();
        int expectedFrames = 2236;
        int expectedKeyFrames = 270;
        h.setupReadingObject(h.sampleFile);
        int retval = -1;
        int videoStream = -1;
        int totalFrames = 0;
        int totalKeyFrames = 0;
        for (int i = 0; i < h.mContainer.getNumStreams(); ++i) {
            if (h.mCoders[i].getCodecType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
            videoStream = i;
            retval = h.mCoders[i].open();
            VideoPictureTest.assertTrue((String)"Could not open decoder", (retval >= 0 ? 1 : 0) != 0);
            VideoPictureTest.assertTrue((String)"Frame should not be complete", (!h.mFrames[i].isComplete() ? 1 : 0) != 0);
            break;
        }
        VideoPictureTest.assertTrue((String)"Could not find video stream", (videoStream >= 0 ? 1 : 0) != 0);
        while (h.mContainer.readNextPacket(h.mPacket) == 0) {
            if (h.mPacket.getStreamIndex() == videoStream) {
                for (int offset = 0; offset < h.mPacket.getSize(); offset += retval) {
                    retval = h.mCoders[videoStream].decodeVideo(h.mFrames[videoStream], h.mPacket, offset);
                    VideoPictureTest.assertTrue((String)"could not decode any video", (retval > 0 ? 1 : 0) != 0);
                    if (!h.mFrames[videoStream].isComplete()) continue;
                    ++totalFrames;
                    if (!h.mFrames[videoStream].isKeyFrame()) continue;
                    ++totalKeyFrames;
                }
                continue;
            }
            this.log.debug("skipping audio packet");
        }
        this.log.debug("Total frames: {}", (Object)totalFrames);
        this.log.debug("Total key frames: {}", (Object)totalKeyFrames);
        VideoPictureTest.assertTrue((String)"didn't get any frames", (totalFrames > 0 ? 1 : 0) != 0);
        VideoPictureTest.assertTrue((String)"didn't get any key frames", (totalKeyFrames > 0 ? 1 : 0) != 0);
        VideoPictureTest.assertTrue((String)"didn't get any non key frames", (totalKeyFrames < totalFrames ? 1 : 0) != 0);
        VideoPictureTest.assertTrue((String)"unexpected # of frames", (totalFrames == expectedFrames ? 1 : 0) != 0);
        VideoPictureTest.assertTrue((String)"unexpected # of key frames", (totalKeyFrames == expectedKeyFrames ? 1 : 0) != 0);
        h.cleanupHelper();
    }

    @Test
    public void testGetPictureType() {
        IVideoPicture pict = Utils.getBlankFrame((int)10, (int)10, (int)0);
        IVideoPicture.PictType defaultType = IVideoPicture.PictType.DEFAULT_TYPE;
        IVideoPicture.PictType setType = IVideoPicture.PictType.S_TYPE;
        VideoPictureTest.assertEquals((Object)defaultType, (Object)pict.getPictureType());
        pict.setPictureType(setType);
        VideoPictureTest.assertEquals((Object)setType, (Object)pict.getPictureType());
    }

    @Test
    public void testReadingFramesIntoIBuffers() {
        IBuffer buffer = IBuffer.make(null, (int)223872);
        Helper h = new Helper();
        int expectedFrames = 2236;
        int expectedKeyFrames = 270;
        h.setupReadingObject(h.sampleFile);
        int retval = -1;
        int videoStream = -1;
        int totalFrames = 0;
        int totalKeyFrames = 0;
        for (int i = 0; i < h.mContainer.getNumStreams(); ++i) {
            if (h.mCoders[i].getCodecType() != ICodec.Type.CODEC_TYPE_VIDEO) continue;
            videoStream = i;
            retval = h.mCoders[i].open();
            VideoPictureTest.assertTrue((String)"Could not open decoder", (retval >= 0 ? 1 : 0) != 0);
            VideoPictureTest.assertTrue((String)"Frame should not be complete", (!h.mFrames[i].isComplete() ? 1 : 0) != 0);
            break;
        }
        VideoPictureTest.assertTrue((String)"Could not find video stream", (videoStream >= 0 ? 1 : 0) != 0);
        IVideoPicture picture = IVideoPicture.make((IBuffer)buffer, (IPixelFormat.Type)h.mCoders[videoStream].getPixelType(), (int)h.mCoders[videoStream].getWidth(), (int)h.mCoders[videoStream].getHeight());
        VideoPictureTest.assertNotNull((Object)picture);
        while (h.mContainer.readNextPacket(h.mPacket) == 0) {
            if (h.mPacket.getStreamIndex() == videoStream) {
                for (int offset = 0; offset < h.mPacket.getSize(); offset += retval) {
                    retval = h.mCoders[videoStream].decodeVideo(picture, h.mPacket, offset);
                    VideoPictureTest.assertTrue((String)"could not decode any video", (retval > 0 ? 1 : 0) != 0);
                    if (!picture.isComplete()) continue;
                    ++totalFrames;
                    if (!picture.isKeyFrame()) continue;
                    ++totalKeyFrames;
                }
                continue;
            }
            this.log.debug("skipping audio packet");
        }
        this.log.debug("Total frames: {}", (Object)totalFrames);
        this.log.debug("Total key frames: {}", (Object)totalKeyFrames);
        VideoPictureTest.assertTrue((String)"didn't get any frames", (totalFrames > 0 ? 1 : 0) != 0);
        VideoPictureTest.assertTrue((String)"didn't get any key frames", (totalKeyFrames > 0 ? 1 : 0) != 0);
        VideoPictureTest.assertTrue((String)"didn't get any non key frames", (totalKeyFrames < totalFrames ? 1 : 0) != 0);
        VideoPictureTest.assertTrue((String)"unexpected # of frames", (totalFrames == expectedFrames ? 1 : 0) != 0);
        VideoPictureTest.assertTrue((String)"unexpected # of key frames", (totalKeyFrames == expectedKeyFrames ? 1 : 0) != 0);
        h.cleanupHelper();
    }

    @Test
    public void testGetDataLineSize() {
        int WIDTH = 420;
        int HEIGHT = 360;
        IPixelFormat.Type TYPE = IPixelFormat.Type.YUV420P;
        IVideoPicture pic = IVideoPicture.make((IPixelFormat.Type)TYPE, (int)420, (int)360);
        pic.setComplete(true, TYPE, 420, 360, 0L);
        VideoPictureTest.assertEquals((int)420, (int)pic.getDataLineSize(0));
        VideoPictureTest.assertEquals((int)210, (int)pic.getDataLineSize(1));
        VideoPictureTest.assertEquals((int)210, (int)pic.getDataLineSize(2));
        VideoPictureTest.assertEquals((int)0, (int)pic.getDataLineSize(3));
        VideoPictureTest.assertEquals((int)-1, (int)pic.getDataLineSize(-1));
        VideoPictureTest.assertEquals((int)-1, (int)pic.getDataLineSize(4));
    }

    @Test
    public void testGetDataLineSizeFromIBuffer() {
        int WIDTH = 420;
        int HEIGHT = 360;
        IPixelFormat.Type TYPE = IPixelFormat.Type.YUV420P;
        IBuffer buf = IBuffer.make(null, (int)226800);
        IVideoPicture pic = IVideoPicture.make((IBuffer)buf, (IPixelFormat.Type)TYPE, (int)420, (int)360);
        pic.setComplete(true, TYPE, 420, 360, 0L);
        VideoPictureTest.assertEquals((int)420, (int)pic.getDataLineSize(0));
        VideoPictureTest.assertEquals((int)210, (int)pic.getDataLineSize(1));
        VideoPictureTest.assertEquals((int)210, (int)pic.getDataLineSize(2));
        VideoPictureTest.assertEquals((int)0, (int)pic.getDataLineSize(3));
        VideoPictureTest.assertEquals((int)-1, (int)pic.getDataLineSize(-1));
        VideoPictureTest.assertEquals((int)-1, (int)pic.getDataLineSize(4));
    }
}

