/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.test_utils.NameAwareTestClassRunner;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.TestAudioSamplesGenerator;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=NameAwareTestClassRunner.class)
public class CreateAudioFileExhaustiveTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String mTestName = null;
    private IContainer mContainer = null;
    private IStream mStream = null;
    private IStreamCoder mCoder = null;
    private IPacket mPacket = null;
    private IAudioSamples mSamples = null;
    private TestAudioSamplesGenerator mAudioGenerator = null;
    private int mSampleRate = 0;
    private int mNumChannels = 0;

    @Before
    public void setUp() {
        this.mTestName = NameAwareTestClassRunner.getTestMethodName();
        this.log.debug("-----START----- {}", (Object)this.mTestName);
        this.mAudioGenerator = new TestAudioSamplesGenerator();
    }

    @After
    public void tearDown() {
        this.log.debug("----- END ----- {}", (Object)this.mTestName);
    }

    @Test
    public void testCreateMono44100Audio() {
        this.prepareFile("file:" + this.getClass().getName() + "_" + this.mTestName + ".flv", 1, 44100);
        this.writeFile(15);
        this.closeFile();
    }

    @Test
    public void testCreateStereo44100Audio() {
        this.prepareFile("file:" + this.getClass().getName() + "_" + this.mTestName + ".flv", 2, 44100);
        this.writeFile(15);
        this.closeFile();
    }

    @Test
    public void testCreateMono22050Audio() {
        this.prepareFile("file:" + this.getClass().getName() + "_" + this.mTestName + ".flv", 1, 22050);
        this.writeFile(15);
        this.closeFile();
    }

    @Test
    public void testCreateStereo22050Audio() {
        this.prepareFile("file:" + this.getClass().getName() + "_" + this.mTestName + ".flv", 2, 22050);
        this.writeFile(15);
        this.closeFile();
    }

    private void closeFile() {
        int retval = -1;
        retval = this.mContainer.writeTrailer();
        Assert.assertTrue((String)"couldn't write the trailer", (retval >= 0 ? 1 : 0) != 0);
        retval = this.mCoder.close();
        Assert.assertTrue((String)"couldn't close coder", (retval >= 0 ? 1 : 0) != 0);
        retval = this.mContainer.close();
        Assert.assertTrue((String)"couldn't close the container", (retval >= 0 ? 1 : 0) != 0);
    }

    private void writeFile(int secondsToGenerate) {
        int retval = -1;
        for (double remainingSecs = (double)secondsToGenerate; remainingSecs > 0.0; remainingSecs -= (double)this.mSamples.getNumSamples() / (double)this.mSampleRate) {
            this.mAudioGenerator.fillNextSamples(this.mSamples, this.mSamples.getMaxSamples());
            this.log.debug("Generated {} samples with {} secs remaining", (Object)this.mSamples.getNumSamples(), (Object)remainingSecs);
            int numSamplesConsumed = 0;
            while ((long)numSamplesConsumed < this.mSamples.getNumSamples()) {
                retval = this.mCoder.encodeAudio(this.mPacket, this.mSamples, (long)numSamplesConsumed);
                if (retval < 0) {
                    throw new RuntimeException("Could not encode audio");
                }
                this.log.debug("consumed {} of {} samples", (Object)(numSamplesConsumed += retval), (Object)this.mSamples.getNumSamples());
                if (!this.mPacket.isComplete()) continue;
                this.log.debug("Wrote packet");
                retval = this.mContainer.writePacket(this.mPacket);
                if (retval >= 0) continue;
                throw new RuntimeException("could not write packet");
            }
        }
    }

    private void prepareFile(String url, int numChannels, int sampleRate) {
        int retval = -1;
        this.mSampleRate = sampleRate;
        this.mNumChannels = numChannels;
        this.mAudioGenerator.prepare(this.mNumChannels, this.mSampleRate);
        this.mSamples = IAudioSamples.make((long)1024L, (long)this.mNumChannels);
        Assert.assertTrue((String)"couldn't get samples", (this.mSamples != null ? 1 : 0) != 0);
        this.mPacket = IPacket.make();
        Assert.assertTrue((String)"couldn't get a packet", (this.mPacket != null ? 1 : 0) != 0);
        this.mContainer = IContainer.make();
        retval = this.mContainer.open(url, IContainer.Type.WRITE, null);
        Assert.assertTrue((String)"couldn't open file", (retval >= 0 ? 1 : 0) != 0);
        this.mStream = this.mContainer.addNewStream(0);
        Assert.assertTrue((String)"couldn't add a stream", (this.mStream != null ? 1 : 0) != 0);
        this.mCoder = this.mStream.getStreamCoder();
        Assert.assertTrue((String)"couldn't get a stream coder", (this.mCoder != null ? 1 : 0) != 0);
        ICodec codec = ICodec.guessEncodingCodec(null, null, (String)url, null, (ICodec.Type)ICodec.Type.CODEC_TYPE_AUDIO);
        Assert.assertTrue((String)"could not guess a codec", (codec != null ? 1 : 0) != 0);
        this.mCoder.setCodec(codec);
        this.log.debug("Got codec: {}", (Object)this.mCoder.getCodec().getName());
        this.mCoder.setChannels(this.mNumChannels);
        this.log.debug("Setting channels: {}", (Object)this.mCoder.getChannels());
        this.mCoder.setSampleRate(this.mSampleRate);
        this.log.debug("Setting sample rate: {}", (Object)this.mCoder.getSampleRate());
        this.mCoder.setBitRate(64000);
        this.log.debug("Setting bit rate: {}", (Object)this.mCoder.getBitRate());
        this.mCoder.setGlobalQuality(0);
        this.log.debug("Setting global quality: {}", (Object)this.mCoder.getGlobalQuality());
        retval = this.mCoder.open();
        Assert.assertTrue((String)"couldn't open coder", (retval >= 0 ? 1 : 0) != 0);
        retval = this.mContainer.writeHeader();
        Assert.assertTrue((String)"couldn't write header", (retval >= 0 ? 1 : 0) != 0);
    }
}

