/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.xuggler.Converter;
import junit.framework.TestCase;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterTest
extends TestCase {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Converter converter = null;

    @Before
    public void setUp() {
        this.log.debug("Executing test case: {}", (Object)this.getName());
    }

    @Test
    public void testDefineOptions() {
        this.converter = new Converter();
        Options options = this.converter.defineOptions();
        ConverterTest.assertTrue((String)"no options", (options != null ? 1 : 0) != 0);
    }

    @Test
    public void testParseOptions() throws ParseException {
        String[] args = new String[]{"--containerformat", "mov", "--acodec", "libmp3lame", "--asamplerate", "22050", "--achannels", "2", "--abitrate", "64000", "--aquality", "2", "--vcodec", "mpeg4", "--vscalefactor", "2.5", "--vbitrate", "300000", "--vquality", "2", "fixtures/testfile.flv", "out.flv"};
        this.converter = new Converter();
        Options options = this.converter.defineOptions();
        CommandLine cmdLine = this.converter.parseOptions(options, args);
        ConverterTest.assertTrue((String)"all commandline options successful", (cmdLine != null ? 1 : 0) != 0);
    }

    @Test
    public void testInvalidOptions() throws ParseException {
        String[] args = new String[]{"--garbageoption", "fixtures/testfile.flv", "out.flv"};
        this.converter = new Converter();
        Options options = this.converter.defineOptions();
        try {
            this.converter.parseOptions(options, args);
            ConverterTest.fail((String)"all commandline options successful");
        }
        catch (UnrecognizedOptionException exception) {
        }
        catch (Error e) {
            throw e;
        }
    }

    @Test
    public void testNoInputFile() throws ParseException {
        String[] args = new String[]{"--vcodec", "mpeg4"};
        this.converter = new Converter();
        Options options = this.converter.defineOptions();
        try {
            this.converter.parseOptions(options, args);
            ConverterTest.fail((String)"all commandline options successful");
        }
        catch (ParseException exception) {
        }
        catch (Error e) {
            throw e;
        }
    }

    @Test
    public void testNoOutputFile() throws ParseException {
        String[] args = new String[]{"--vcodec", "mpeg4", "fixtures/testfile.flv"};
        this.converter = new Converter();
        Options options = this.converter.defineOptions();
        try {
            this.converter.parseOptions(options, args);
            ConverterTest.fail((String)"all commandline options successful");
        }
        catch (ParseException exception) {
        }
        catch (Error e) {
            throw e;
        }
    }

    @Test
    public void testConversion() throws ParseException {
        String[] args = new String[]{"--containerformat", "mov", "--acodec", "libmp3lame", "--asamplerate", "22050", "--achannels", "2", "--abitrate", "64000", "--aquality", "0", "--vcodec", "mpeg4", "--vscalefactor", "2.0", "--vbitrate", "300000", "--vbitratetolerance", "12000000", "--vquality", "0", "fixtures/testfile_videoonly_20sec.flv", ((Object)((Object)this)).getClass().getName() + "_" + this.getName() + ".mov"};
        this.converter = new Converter();
        Options options = this.converter.defineOptions();
        CommandLine cmdLine = this.converter.parseOptions(options, args);
        ConverterTest.assertTrue((String)"all commandline options successful", (cmdLine != null ? 1 : 0) != 0);
        this.converter.run(cmdLine);
    }

    @Test
    public void testPresets() throws ParseException {
        String[] args = new String[]{"--containerformat", "mp4p", "--cpreset", "fixtures/" + ((Object)((Object)this)).getClass().getName() + ".cpresets.txt", "--acodec", "libmp3lame", "--asamplerate", "22050", "--achannels", "2", "--abitrate", "64000", "--aquality", "0", "--vcodec", "libx264", "--vpreset", "fixtures/" + ((Object)((Object)this)).getClass().getName() + ".vpresets.txt", "--vscalefactor", "2.0", "--vbitrate", "300000", "--vbitratetolerance", "12000000", "--vquality", "0", "fixtures/testfile_videoonly_20sec.flv", ((Object)((Object)this)).getClass().getName() + "_" + this.getName() + ".mp4"};
        this.converter = new Converter();
        Options options = this.converter.defineOptions();
        CommandLine cmdLine = this.converter.parseOptions(options, args);
        ConverterTest.assertTrue((String)"all commandline options successful", (cmdLine != null ? 1 : 0) != 0);
        this.converter.run(cmdLine);
    }
}

