/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.xuggler.ICodec;
import java.util.Collection;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecTest
extends TestCase {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ICodec mCodec = null;

    @Before
    public void setUp() {
        if (this.mCodec != null) {
            this.mCodec.delete();
        }
        this.mCodec = null;
    }

    @Test
    public void testFindDecodingCodec() {
        String name = null;
        ICodec.ID id = ICodec.ID.CODEC_ID_NONE;
        ICodec.Type type = ICodec.Type.CODEC_TYPE_UNKNOWN;
        this.mCodec = ICodec.findDecodingCodec((ICodec.ID)ICodec.ID.CODEC_ID_NELLYMOSER);
        CodecTest.assertTrue((String)"no codec?", (this.mCodec != null ? 1 : 0) != 0);
        id = this.mCodec.getID();
        type = this.mCodec.getType();
        name = this.mCodec.getName();
        this.log.debug("Codec name is: {}", (Object)name);
        this.log.debug("Codec   id is: {}", (Object)id);
        this.log.debug("Codec type is: {}", (Object)type);
        this.mCodec.delete();
        this.mCodec = ICodec.findDecodingCodecByName((String)name);
        CodecTest.assertTrue((String)"no codec?", (this.mCodec != null ? 1 : 0) != 0);
        CodecTest.assertTrue((String)"different codec?", (id == this.mCodec.getID() ? 1 : 0) != 0);
        CodecTest.assertTrue((String)"different codec?", (type == this.mCodec.getType() ? 1 : 0) != 0);
        this.mCodec = ICodec.findDecodingCodecByName((String)"notbloodylikely");
        CodecTest.assertTrue((String)"that codec exists?", (this.mCodec == null ? 1 : 0) != 0);
        this.mCodec = ICodec.findDecodingCodec((ICodec.ID)ICodec.ID.CODEC_ID_NONE);
        CodecTest.assertTrue((String)"that codec exists?", (this.mCodec == null ? 1 : 0) != 0);
    }

    @Test
    public void testFindEncodingCodec() {
        String name = null;
        ICodec.ID id = ICodec.ID.CODEC_ID_NONE;
        ICodec.Type type = ICodec.Type.CODEC_TYPE_UNKNOWN;
        this.mCodec = ICodec.findEncodingCodec((ICodec.ID)ICodec.ID.CODEC_ID_MP3);
        CodecTest.assertTrue((String)"no codec?", (this.mCodec != null ? 1 : 0) != 0);
        id = this.mCodec.getID();
        type = this.mCodec.getType();
        name = this.mCodec.getName();
        this.log.debug("Codec name is: {}", (Object)name);
        this.log.debug("Codec   id is: {}", (Object)id);
        this.log.debug("Codec type is: {}", (Object)type);
        this.mCodec.delete();
        this.mCodec = ICodec.findEncodingCodecByName((String)name);
        CodecTest.assertTrue((String)"no codec?", (this.mCodec != null ? 1 : 0) != 0);
        CodecTest.assertTrue((String)"different codec?", (id == this.mCodec.getID() ? 1 : 0) != 0);
        CodecTest.assertTrue((String)"different codec?", (type == this.mCodec.getType() ? 1 : 0) != 0);
        this.mCodec = ICodec.findEncodingCodecByName((String)"notbloodylikely");
        CodecTest.assertTrue((String)"that codec exists?", (this.mCodec == null ? 1 : 0) != 0);
        this.mCodec = ICodec.findEncodingCodec((ICodec.ID)ICodec.ID.CODEC_ID_NONE);
        CodecTest.assertTrue((String)"that codec exists?", (this.mCodec == null ? 1 : 0) != 0);
    }

    @Test
    public void testGetLongName() {
        this.mCodec = ICodec.findEncodingCodec((ICodec.ID)ICodec.ID.CODEC_ID_MP3);
        CodecTest.assertNotNull((Object)this.mCodec);
        String longname = this.mCodec.getLongName();
        CodecTest.assertNotNull((String)"no long name", (Object)longname);
        CodecTest.assertTrue((String)"no description", (longname.length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCodecIdsAreEnums() {
        ICodec.ID[] ids;
        block3: for (ICodec.ID id : ids = new ICodec.ID[]{ICodec.ID.CODEC_ID_4XM, ICodec.ID.CODEC_ID_ADPCM_4XM, ICodec.ID.CODEC_ID_DXA}) {
            switch (id) {
                case CODEC_ID_4XM: 
                case CODEC_ID_ADPCM_4XM: 
                case CODEC_ID_DXA: {
                    continue block3;
                }
                default: {
                    CodecTest.fail((String)"and should never get here");
                }
            }
        }
    }

    @Test
    public void testGetInstalledCodecs() {
        Collection installed = ICodec.getInstalledCodecs();
        CodecTest.assertTrue((installed.size() > 0 ? 1 : 0) != 0);
        for (ICodec codec : installed) {
            CodecTest.assertNotNull((Object)codec);
            CodecTest.assertTrue((codec.getName().length() > 0 ? 1 : 0) != 0);
        }
    }
}

