/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.Helper;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioSamplesTest
extends TestCase {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @Before
    public void setUp() {
        this.log.debug("Executing test case: {}", (Object)this.getName());
    }

    @Test
    public void testReadingSamples() {
        Helper h = new Helper();
        h.setupReadingObject(h.sampleFile);
        int retval = -1;
        int audioStream = -1;
        int totalSamples = 0;
        for (int i = 0; i < h.mContainer.getNumStreams(); ++i) {
            if (h.mCoders[i].getCodecType() != ICodec.Type.CODEC_TYPE_AUDIO) continue;
            audioStream = i;
            retval = h.mCoders[i].open();
            AudioSamplesTest.assertTrue((String)"Could not open decoder", (retval >= 0 ? 1 : 0) != 0);
            AudioSamplesTest.assertTrue((String)"unexpected samples inbuffer", (h.mSamples[i].getNumSamples() == 0L ? 1 : 0) != 0);
            break;
        }
        AudioSamplesTest.assertTrue((String)"Could not find audio stream", (audioStream >= 0 ? 1 : 0) != 0);
        while (h.mContainer.readNextPacket(h.mPacket) == 0) {
            if (h.mPacket.getStreamIndex() == audioStream) {
                for (int offset = 0; offset < h.mPacket.getSize(); offset += retval) {
                    retval = h.mCoders[audioStream].decodeAudio(h.mSamples[audioStream], h.mPacket, offset);
                    AudioSamplesTest.assertTrue((String)"could not decode any audio", (retval > 0 ? 1 : 0) != 0);
                    AudioSamplesTest.assertTrue((String)"did not write any samples", (h.mSamples[audioStream].getNumSamples() > 0L ? 1 : 0) != 0);
                    this.log.debug("Decoded {} samples", (Object)h.mSamples[audioStream].getNumSamples());
                    totalSamples = (int)((long)totalSamples + h.mSamples[audioStream].getNumSamples());
                }
                continue;
            }
            this.log.debug("skipping video packet");
        }
        h.mCoders[audioStream].close();
        this.log.debug("Total audio samples: {}", (Object)totalSamples);
        AudioSamplesTest.assertTrue((String)"didn't get any audio", (totalSamples > 0 ? 1 : 0) != 0);
        AudioSamplesTest.assertTrue((String)"unexpected # of samples", (totalSamples == 3291264 ? 1 : 0) != 0);
    }

    @Test
    public void testReadingSamplesIntoIBuffer() {
        IBuffer buffer = IBuffer.make(null, (int)384000);
        Helper h = new Helper();
        h.setupReadingObject(h.sampleFile);
        int retval = -1;
        int audioStream = -1;
        int totalSamples = 0;
        for (int i = 0; i < h.mContainer.getNumStreams(); ++i) {
            if (h.mCoders[i].getCodecType() != ICodec.Type.CODEC_TYPE_AUDIO) continue;
            audioStream = i;
            retval = h.mCoders[i].open();
            AudioSamplesTest.assertTrue((String)"Could not open decoder", (retval >= 0 ? 1 : 0) != 0);
            AudioSamplesTest.assertTrue((String)"unexpected samples inbuffer", (h.mSamples[i].getNumSamples() == 0L ? 1 : 0) != 0);
            break;
        }
        AudioSamplesTest.assertTrue((String)"Could not find audio stream", (audioStream >= 0 ? 1 : 0) != 0);
        IAudioSamples samples = IAudioSamples.make((IBuffer)buffer, (int)h.mCoders[audioStream].getChannels(), (IAudioSamples.Format)h.mCoders[audioStream].getSampleFormat());
        AudioSamplesTest.assertNotNull((Object)samples);
        while (h.mContainer.readNextPacket(h.mPacket) == 0) {
            if (h.mPacket.getStreamIndex() == audioStream) {
                for (int offset = 0; offset < h.mPacket.getSize(); offset += retval) {
                    retval = h.mCoders[audioStream].decodeAudio(samples, h.mPacket, offset);
                    AudioSamplesTest.assertTrue((String)"could not decode any audio", (retval > 0 ? 1 : 0) != 0);
                    AudioSamplesTest.assertTrue((String)"did not write any samples", (samples.getNumSamples() > 0L ? 1 : 0) != 0);
                    this.log.debug("Decoded {} samples", (Object)samples.getNumSamples());
                    totalSamples = (int)((long)totalSamples + samples.getNumSamples());
                }
                continue;
            }
            this.log.debug("skipping video packet");
        }
        h.mCoders[audioStream].close();
        this.log.debug("Total audio samples: {}", (Object)totalSamples);
        AudioSamplesTest.assertTrue((String)"didn't get any audio", (totalSamples > 0 ? 1 : 0) != 0);
        AudioSamplesTest.assertTrue((String)"unexpected # of samples", (totalSamples == 3291264 ? 1 : 0) != 0);
    }

    @Test
    public void testGetNextPts() {
        int sampleRate = 440;
        int channels = 1;
        IAudioSamples samples = IAudioSamples.make((long)sampleRate, (long)1L);
        AudioSamplesTest.assertNotNull((Object)samples);
        samples.setComplete(true, (long)sampleRate, sampleRate, channels, IAudioSamples.Format.FMT_S16, 0L);
        AudioSamplesTest.assertTrue((boolean)samples.isComplete());
        AudioSamplesTest.assertEquals((long)0L, (long)samples.getPts());
        AudioSamplesTest.assertEquals((long)Global.DEFAULT_PTS_PER_SECOND, (long)samples.getNextPts());
    }

    @Test
    public void testSetPts() {
        int sampleRate = 440;
        int channels = 1;
        IAudioSamples samples = IAudioSamples.make((long)sampleRate, (long)1L);
        AudioSamplesTest.assertNotNull((Object)samples);
        samples.setComplete(true, (long)sampleRate, sampleRate, channels, IAudioSamples.Format.FMT_S16, 0L);
        AudioSamplesTest.assertTrue((boolean)samples.isComplete());
        AudioSamplesTest.assertEquals((long)0L, (long)samples.getPts());
        AudioSamplesTest.assertEquals((long)Global.DEFAULT_PTS_PER_SECOND, (long)samples.getNextPts());
        samples.setPts(Global.DEFAULT_PTS_PER_SECOND);
        AudioSamplesTest.assertEquals((long)Global.DEFAULT_PTS_PER_SECOND, (long)samples.getPts());
        AudioSamplesTest.assertEquals((long)(2L * Global.DEFAULT_PTS_PER_SECOND), (long)samples.getNextPts());
    }

    @Test
    public void testGetBufferType() {
        int sampleRate = 440;
        int channels = 1;
        IAudioSamples samples = IAudioSamples.make((long)sampleRate, (long)1L);
        AudioSamplesTest.assertNotNull((Object)samples);
        samples.setComplete(true, (long)sampleRate, sampleRate, channels, IAudioSamples.Format.FMT_S16, 0L);
        AudioSamplesTest.assertTrue((boolean)samples.isComplete());
        IBuffer buffer = samples.getData();
        AudioSamplesTest.assertEquals((Object)IBuffer.Type.IBUFFER_SINT16, (Object)buffer.getType());
        samples.setComplete(true, (long)sampleRate, sampleRate, channels, IAudioSamples.Format.FMT_S32, 0L);
        AudioSamplesTest.assertTrue((boolean)samples.isComplete());
        buffer = samples.getData();
        AudioSamplesTest.assertEquals((Object)IBuffer.Type.IBUFFER_SINT32, (Object)buffer.getType());
    }
}

