/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.ferry;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.JNIMemoryManager;
import com.xuggle.test_utils.NameAwareTestClassRunner;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=NameAwareTestClassRunner.class)
public class BufferTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String mTestName = null;

    @Before
    public void setUp() {
        this.mTestName = NameAwareTestClassRunner.getTestMethodName();
        this.log.debug("-----START----- {}", (Object)this.mTestName);
    }

    @After
    public void tearDown() {
        this.log.debug("----- END ----- {}", (Object)this.mTestName);
    }

    @Test
    public void testCreation() {
        IBuffer buf = IBuffer.make(null, (int)1024);
        Assert.assertNotNull((Object)buf);
        Assert.assertTrue((buf.getBufferSize() >= 1024 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateFromBytes() {
        byte[] buffer = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        IBuffer buf = IBuffer.make(null, (byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertNotNull((Object)buf);
        Assert.assertEquals((int)buf.getBufferSize(), (int)buffer.length);
        byte[] outBuffer = buf.getByteArray(0, buffer.length);
        Assert.assertNotNull((Object)outBuffer);
        Assert.assertEquals((int)outBuffer.length, (int)buffer.length);
        Assert.assertNotSame((Object)buf, (Object)outBuffer);
        for (int i = 0; i < buffer.length; ++i) {
            Assert.assertEquals((byte)buffer[i], (byte)outBuffer[i]);
        }
    }

    @Test
    public void testCanDirectlyModifyNativeBytes() {
        byte[] buffer = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        IBuffer buf = IBuffer.make(null, (byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertNotNull((Object)buf);
        Assert.assertEquals((int)buf.getBufferSize(), (int)buffer.length);
        ByteBuffer nativeBytes = buf.getByteBuffer(0, buffer.length);
        Assert.assertNotNull((Object)nativeBytes);
        for (int i = 0; i < buffer.length; ++i) {
            nativeBytes.put(i, (byte)(9 - buffer[i]));
        }
        nativeBytes = null;
        byte[] outBuffer = buf.getByteArray(0, buffer.length);
        Assert.assertNotNull((Object)outBuffer);
        Assert.assertEquals((int)outBuffer.length, (int)buffer.length);
        Assert.assertNotSame((Object)buf, (Object)outBuffer);
        for (int i = 0; i < buffer.length; ++i) {
            Assert.assertEquals((int)(9 - buffer[i]), (int)outBuffer[i]);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreationFailsWithoutDirectByteBuffer() {
        ByteBuffer directByteBuffer = ByteBuffer.allocate(10);
        IBuffer.make(null, (ByteBuffer)directByteBuffer, (int)0, (int)10);
    }

    @Test
    public void testCreationFromJavaDirectByteBuffer() {
        int numBytes = 10;
        ByteBuffer directByteBuffer = ByteBuffer.allocateDirect(numBytes);
        for (int i = 0; i < numBytes; ++i) {
            directByteBuffer.put(i, (byte)i);
        }
        IBuffer ibuf = IBuffer.make(null, (ByteBuffer)directByteBuffer, (int)0, (int)numBytes);
        Assert.assertNotNull((Object)ibuf);
        ByteBuffer outputDirectByteBuffer = ibuf.getByteBuffer(0, numBytes);
        Assert.assertNotNull((Object)numBytes);
        Assert.assertEquals((int)numBytes, (int)outputDirectByteBuffer.capacity());
        for (int i = 0; i < numBytes; ++i) {
            Assert.assertEquals((int)i, (int)outputDirectByteBuffer.get(i));
        }
    }

    @Test
    public void testCreationFromJavaDirectByteBufferAndModify() {
        int i;
        int numBytes = 10;
        ByteBuffer directByteBuffer = ByteBuffer.allocateDirect(numBytes);
        for (int i2 = 0; i2 < numBytes; ++i2) {
            directByteBuffer.put(i2, (byte)i2);
        }
        IBuffer ibuf = IBuffer.make(null, (ByteBuffer)directByteBuffer, (int)0, (int)numBytes);
        Assert.assertNotNull((Object)ibuf);
        ByteBuffer outputDirectByteBuffer = ibuf.getByteBuffer(0, numBytes);
        Assert.assertNotNull((Object)numBytes);
        Assert.assertEquals((int)numBytes, (int)outputDirectByteBuffer.capacity());
        for (i = 0; i < numBytes; ++i) {
            Assert.assertEquals((int)i, (int)outputDirectByteBuffer.get(i));
        }
        for (i = 0; i < numBytes; ++i) {
            directByteBuffer.put(i, (byte)(numBytes - i - 1));
        }
        for (i = 0; i < numBytes; ++i) {
            Assert.assertEquals((int)(numBytes - i - 1), (int)outputDirectByteBuffer.get(i));
        }
    }

    @Test
    public void testNoLeakingMemoryOnDirectAccess() {
        IBuffer buf = IBuffer.make(null, (int)0x100000);
        Assert.assertNotNull((Object)buf);
        for (int i = 0; i < 100000; ++i) {
            ByteBuffer nativeBytes = buf.getByteBuffer(0, buf.getBufferSize());
            Assert.assertEquals((int)nativeBytes.limit(), (int)buf.getBufferSize());
            Object var3_3 = null;
        }
    }

    @Test(timeout=5000L)
    public void testDirectByteBufferCanBeAccessedAfterIBufferDisappears() {
        IBuffer buf = IBuffer.make(null, (int)0x100000);
        Assert.assertNotNull((Object)buf);
        Assert.assertEquals((long)1L, (long)buf.getCurrentRefCount());
        ByteBuffer jbuf = buf.getByteBuffer(0, buf.getBufferSize());
        Assert.assertNotNull((Object)buf);
        buf.delete();
        buf = null;
        jbuf.put(0, (byte)-1);
    }

    @Test
    public void testByteOrderIsCorrect() {
        IBuffer buf = IBuffer.make(null, (int)0x100000);
        Assert.assertNotNull((Object)buf);
        Assert.assertEquals((long)1L, (long)buf.getCurrentRefCount());
        ByteBuffer jbuf = buf.getByteBuffer(0, buf.getBufferSize());
        Assert.assertNotNull((Object)buf);
        jbuf.put(0, (byte)-1);
        jbuf.put(1, (byte)0);
        jbuf.put(2, (byte)-1);
        jbuf.put(3, (byte)0);
        int bigOrderVal = -16711936;
        int littleOrderVal = 0xFF00FF;
        int expectedVal = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? bigOrderVal : littleOrderVal;
        IntBuffer ibuf = jbuf.asIntBuffer();
        Assert.assertNotNull((Object)ibuf);
        int val = ibuf.get(0);
        Assert.assertEquals((int)expectedVal, (int)val);
        jbuf.order(ByteOrder.BIG_ENDIAN);
        ibuf = jbuf.asIntBuffer();
        Assert.assertNotNull((Object)ibuf);
        val = ibuf.get(0);
        Assert.assertEquals((int)bigOrderVal, (int)val);
        jbuf.order(ByteOrder.LITTLE_ENDIAN);
        ibuf = jbuf.asIntBuffer();
        Assert.assertNotNull((Object)ibuf);
        val = ibuf.get(0);
        Assert.assertEquals((int)littleOrderVal, (int)val);
    }

    @Test
    public void testGetInvalidArgs() {
        IBuffer buf = IBuffer.make(null, (int)1);
        byte[] in = new byte[]{56, 44};
        byte[] out = new byte[]{83, 124};
        try {
            buf.put(in, 0, 0, 2);
            Assert.fail((String)"should fail on 2 bytes");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            buf.get(0, out, 0, 2);
            Assert.fail((String)"should fail on 2 bytes");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            buf.put(in, -1, 0, 1);
            Assert.fail((String)"should fail on 2 bytes");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            buf.get(-1, out, 0, 1);
            Assert.fail((String)"should fail on 2 bytes");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            buf.put(in, 0, -1, 1);
            Assert.fail((String)"should fail on 2 bytes");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            buf.get(0, out, -1, 1);
            Assert.fail((String)"should fail on 2 bytes");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            buf.put(in, 0, 1, 1);
            Assert.fail((String)"should fail on 2 bytes");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            buf.get(0, out, 3, 1);
            Assert.fail((String)"should fail on 2 bytes");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            buf.put(in, 3, 0, 1);
            Assert.fail((String)"should fail on 2 bytes");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            buf.get(1, out, 0, 1);
            Assert.fail((String)"should fail on 2 bytes");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        buf.put(in, 0, 0, 1);
        buf.get(0, out, 0, 1);
        Assert.assertEquals((byte)in[0], (byte)out[0]);
        Assert.assertNotSame((Object)in[1], (Object)out[1]);
        buf.delete();
    }

    @Test
    public void testByteGetPut() {
        JNIMemoryManager.getMgr().flush();
        byte[] in = new byte[]{56, 44, 24, 127};
        byte[] out = new byte[in.length];
        IBuffer buf = IBuffer.make(null, (int)1024);
        buf.put(in, 0, 0, in.length);
        buf.get(0, out, 0, in.length);
        for (int i = 0; i < in.length; ++i) {
            Assert.assertEquals((String)("mismatched bytes at " + i), (byte)in[i], (byte)out[i]);
        }
        buf.delete();
        Assert.assertEquals((String)"more objects around than expected", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }

    @Test
    public void testShortGetPut() {
        JNIMemoryManager.getMgr().flush();
        short[] in = new short[]{56, 44, 24, 127};
        short[] out = new short[in.length];
        IBuffer buf = IBuffer.make(null, (int)1024);
        buf.put(in, 0, 0, in.length);
        buf.get(0, out, 0, in.length);
        for (int i = 0; i < in.length; ++i) {
            Assert.assertEquals((String)("mismatched bytes at " + i), (short)in[i], (short)out[i]);
        }
        buf.delete();
        Assert.assertEquals((String)"more objects around than expected", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }

    @Test
    public void testIntGetPut() {
        JNIMemoryManager.getMgr().flush();
        int[] in = new int[]{56, 44, 24, 127};
        int[] out = new int[in.length];
        IBuffer buf = IBuffer.make(null, (int)1024);
        buf.put(in, 0, 0, in.length);
        buf.get(0, out, 0, in.length);
        for (int i = 0; i < in.length; ++i) {
            Assert.assertEquals((String)("mismatched bytes at " + i), (int)in[i], (int)out[i]);
        }
        buf.delete();
        Assert.assertEquals((String)"more objects around than expected", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }

    @Test
    public void testCharGetPut() {
        JNIMemoryManager.getMgr().flush();
        char[] in = new char[]{'8', ',', '\u0018', '\u007f'};
        char[] out = new char[in.length];
        IBuffer buf = IBuffer.make(null, (int)1024);
        buf.put(in, 0, 0, in.length);
        buf.get(0, out, 0, in.length);
        for (int i = 0; i < in.length; ++i) {
            Assert.assertEquals((String)("mismatched bytes at " + i), (char)in[i], (char)out[i]);
        }
        buf.delete();
        Assert.assertEquals((String)"more objects around than expected", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }

    @Test
    public void testLongGetPut() {
        JNIMemoryManager.getMgr().flush();
        long[] in = new long[]{56L, 44L, 24L, 127L};
        long[] out = new long[in.length];
        IBuffer buf = IBuffer.make(null, (int)1024);
        buf.put(in, 0, 0, in.length);
        buf.get(0, out, 0, in.length);
        for (int i = 0; i < in.length; ++i) {
            Assert.assertEquals((String)("mismatched bytes at " + i), (long)in[i], (long)out[i]);
        }
        buf.delete();
        Assert.assertEquals((String)"more objects around than expected", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }

    @Test
    public void testDoubleGetPut() {
        JNIMemoryManager.getMgr().flush();
        double[] in = new double[]{56.0, 44.0, 24.0, 127.0};
        double[] out = new double[in.length];
        IBuffer buf = IBuffer.make(null, (int)1024);
        buf.put(in, 0, 0, in.length);
        buf.get(0, out, 0, in.length);
        for (int i = 0; i < in.length; ++i) {
            Assert.assertEquals((String)("mismatched bytes at " + i), (Object)in[i], (Object)out[i]);
        }
        buf.delete();
        Assert.assertEquals((String)"more objects around than expected", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }

    @Test
    public void testFloatGetPut() {
        JNIMemoryManager.getMgr().flush();
        float[] in = new float[]{56.0f, 44.0f, 24.0f, 127.0f};
        float[] out = new float[in.length];
        IBuffer buf = IBuffer.make(null, (int)1024);
        buf.put(in, 0, 0, in.length);
        buf.get(0, out, 0, in.length);
        for (int i = 0; i < in.length; ++i) {
            Assert.assertEquals((String)("mismatched bytes at " + i), (Object)Float.valueOf(in[i]), (Object)Float.valueOf(out[i]));
        }
        buf.delete();
        Assert.assertEquals((String)"more objects around than expected", (long)0L, (long)JNIMemoryManager.getMgr().getNumPinnedObjects());
    }
}

