/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.test_utils.NameAwareTestClassRunner;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IVideoResampler;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=NameAwareTestClassRunner.class)
public class VideoResamplerTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String mTestName = null;

    @Before
    public void setUp() {
        this.mTestName = NameAwareTestClassRunner.getTestMethodName();
        this.log.debug("-----START----- {}", (Object)this.mTestName);
    }

    @After
    public void tearDown() {
        this.log.debug("----- END ----- {}", (Object)this.mTestName);
    }

    @Test
    public void testGetAndSetProperties() {
        if (!IVideoResampler.isSupported((IVideoResampler.Feature)IVideoResampler.Feature.FEATURE_COLORSPACECONVERSION)) {
            return;
        }
        IVideoResampler resampler = IVideoResampler.make((int)10, (int)10, (IPixelFormat.Type)IPixelFormat.Type.BGR24, (int)20, (int)20, (IPixelFormat.Type)IPixelFormat.Type.YUV420P);
        Assert.assertTrue((String)"should have some properties", (resampler.getNumProperties() > 0 ? 1 : 0) != 0);
        long sws_flags = resampler.getPropertyAsLong("sws_flags");
        Assert.assertTrue((String)"should be non zero to start with", (sws_flags > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"should succeed", (resampler.setProperty("sws_flags", "+bicubic") >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"should be changed now", (sws_flags != resampler.getPropertyAsLong("sws_flags") ? 1 : 0) != 0);
        Assert.assertNull((String)"should fail", (Object)resampler.getPropertyAsString("xuggle_notanoption"));
        Assert.assertTrue((String)"should fail", (resampler.setProperty("xuggle_notanoption", 15L) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"should fail", (resampler.setProperty("sws_flags", "+notaflag") < 0 ? 1 : 0) != 0);
    }
}

