/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import java.util.Collection;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCoderTest
extends TestCase {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String sampleFile = "fixtures/testfile.flv";
    private IStream mStream = null;
    private IContainer mContainer = null;
    private IStreamCoder mCoder = null;

    @Before
    public void setUp() {
        this.log.debug("Executing test case: {}", (Object)this.getName());
        if (this.mContainer != null) {
            this.mContainer.delete();
        }
        this.mContainer = null;
        if (this.mStream != null) {
            this.mStream.delete();
        }
        this.mStream = null;
        if (this.mCoder != null) {
            this.mCoder.delete();
        }
        this.mCoder = null;
    }

    @Test
    public void testGetDirection() {
        this.mCoder = this.getStreamCoder("fixtures/testfile.flv", 1);
        IStreamCoder.Direction direction = this.mCoder.getDirection();
        StreamCoderTest.assertTrue((direction == IStreamCoder.Direction.DECODING ? 1 : 0) != 0);
    }

    @Test
    public void testGetCodec() {
        ICodec codec = null;
        ICodec.Type type = null;
        ICodec.ID id = null;
        this.mCoder = this.getStreamCoder("fixtures/testfile.flv", 0);
        codec = this.mCoder.getCodec();
        StreamCoderTest.assertTrue((codec != null ? 1 : 0) != 0);
        type = this.mCoder.getCodecType();
        StreamCoderTest.assertTrue((type == codec.getType() ? 1 : 0) != 0);
        StreamCoderTest.assertTrue((type == ICodec.Type.CODEC_TYPE_VIDEO ? 1 : 0) != 0);
        id = this.mCoder.getCodecID();
        StreamCoderTest.assertTrue((id == codec.getID() ? 1 : 0) != 0);
        this.log.debug("Video type: {}", (Object)id);
        StreamCoderTest.assertTrue((id == ICodec.ID.CODEC_ID_FLV1 ? 1 : 0) != 0);
        this.mCoder = this.getStreamCoder("fixtures/testfile.flv", 1);
        codec = this.mCoder.getCodec();
        StreamCoderTest.assertTrue((codec != null ? 1 : 0) != 0);
        type = this.mCoder.getCodecType();
        StreamCoderTest.assertTrue((type == codec.getType() ? 1 : 0) != 0);
        StreamCoderTest.assertTrue((type == ICodec.Type.CODEC_TYPE_AUDIO ? 1 : 0) != 0);
        id = this.mCoder.getCodecID();
        StreamCoderTest.assertTrue((id == codec.getID() ? 1 : 0) != 0);
        StreamCoderTest.assertTrue((id == ICodec.ID.CODEC_ID_MP3 ? 1 : 0) != 0);
    }

    @Test
    public void testVideoGetters() {
        int bitRate = -1;
        int height = -1;
        int width = -1;
        IRational timebase = null;
        int gops = -1;
        IPixelFormat.Type pixFmt = IPixelFormat.Type.NONE;
        int sampleRate = -1;
        int channels = -1;
        this.mCoder = this.getStreamCoder("fixtures/testfile.flv", 0);
        bitRate = this.mCoder.getBitRate();
        height = this.mCoder.getHeight();
        width = this.mCoder.getWidth();
        timebase = this.mCoder.getTimeBase();
        gops = this.mCoder.getNumPicturesInGroupOfPictures();
        pixFmt = this.mCoder.getPixelType();
        sampleRate = this.mCoder.getSampleRate();
        channels = this.mCoder.getChannels();
        this.log.debug("Bitrate: {}", (Object)bitRate);
        this.log.debug("Height: {}", (Object)height);
        this.log.debug("Width: {}", (Object)width);
        this.log.debug("Timebase: {}/{}", (Object)timebase.getNumerator(), (Object)timebase.getDenominator());
        this.log.debug("Num Group of Pictures: {}", (Object)gops);
        this.log.debug("Pixel Format: {}", (Object)pixFmt);
        this.log.debug("Sample Rate: {}", (Object)sampleRate);
        this.log.debug("Channels: {}", (Object)channels);
        StreamCoderTest.assertEquals((int)0, (int)bitRate);
        StreamCoderTest.assertEquals((int)176, (int)height);
        StreamCoderTest.assertEquals((int)424, (int)width);
        StreamCoderTest.assertEquals((int)1, (int)timebase.getNumerator());
        StreamCoderTest.assertEquals((int)1000, (int)timebase.getDenominator());
        StreamCoderTest.assertEquals((int)12, (int)gops);
        StreamCoderTest.assertEquals((Object)IPixelFormat.Type.YUV420P, (Object)pixFmt);
        StreamCoderTest.assertEquals((int)0, (int)sampleRate);
        StreamCoderTest.assertEquals((int)0, (int)channels);
    }

    @Test
    public void testAudioGetters() {
        int bitRate = -1;
        int height = -1;
        int width = -1;
        IRational timebase = null;
        int gops = -1;
        IPixelFormat.Type pixFmt = IPixelFormat.Type.NONE;
        int sampleRate = -1;
        int channels = -1;
        IContainer container = IContainer.make();
        container.open("fixtures/testfile.mp3", IContainer.Type.READ, null);
        IStream stream = container.getStream(0L);
        this.mCoder = stream.getStreamCoder();
        bitRate = this.mCoder.getBitRate();
        height = this.mCoder.getHeight();
        width = this.mCoder.getWidth();
        timebase = this.mCoder.getTimeBase();
        gops = this.mCoder.getNumPicturesInGroupOfPictures();
        pixFmt = this.mCoder.getPixelType();
        sampleRate = this.mCoder.getSampleRate();
        channels = this.mCoder.getChannels();
        this.log.debug("Bitrate: {}", (Object)bitRate);
        this.log.debug("Height: {}", (Object)height);
        this.log.debug("Width: {}", (Object)width);
        this.log.debug("Timebase: {}", (Object)timebase);
        this.log.debug("Num Group of Pictures: {}", (Object)gops);
        this.log.debug("Pixel Format: {}", (Object)pixFmt);
        this.log.debug("Sample Rate: {}", (Object)sampleRate);
        this.log.debug("Channels: {}", (Object)channels);
        StreamCoderTest.assertEquals((float)128000.0f, (float)bitRate, (float)1000.0f);
        StreamCoderTest.assertEquals((int)0, (int)height);
        StreamCoderTest.assertEquals((int)0, (int)width);
        StreamCoderTest.assertEquals((int)1, (int)timebase.getNumerator());
        StreamCoderTest.assertEquals((int)14112000, (int)timebase.getDenominator());
        StreamCoderTest.assertEquals((int)12, (int)gops);
        StreamCoderTest.assertEquals((Object)IPixelFormat.Type.NONE, (Object)pixFmt);
        StreamCoderTest.assertEquals((int)44100, (int)sampleRate);
        StreamCoderTest.assertEquals((int)2, (int)channels);
        stream.delete();
        container.close();
        container.delete();
    }

    @Test
    public void testOpenAndCloseCodec() {
        int retval = -1;
        this.mCoder = this.getStreamCoder("fixtures/testfile.flv", 1);
        retval = this.mCoder.open();
        StreamCoderTest.assertTrue((String)"Could not open codec", (retval >= 0 ? 1 : 0) != 0);
        retval = this.mCoder.close();
        StreamCoderTest.assertTrue((String)"Could not close codec", (retval >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetCodecTypeBugFix2508480() {
        IContainer container = IContainer.make();
        StreamCoderTest.assertTrue((String)"should be able to open", (container.open("fixtures/subtitled_video.mkv", IContainer.Type.READ, null) >= 0 ? 1 : 0) != 0);
        StreamCoderTest.assertEquals((String)"unexpected codec type", (Object)ICodec.Type.CODEC_TYPE_VIDEO, (Object)container.getStream(0L).getStreamCoder().getCodecType());
        StreamCoderTest.assertEquals((String)"unexpected codec type", (Object)ICodec.Type.CODEC_TYPE_AUDIO, (Object)container.getStream(1L).getStreamCoder().getCodecType());
        StreamCoderTest.assertEquals((String)"unexpected codec type", (Object)ICodec.Type.CODEC_TYPE_SUBTITLE, (Object)container.getStream(2L).getStreamCoder().getCodecType());
    }

    @Test
    public void testGetCodecTag() {
        IContainer container = IContainer.make();
        StreamCoderTest.assertTrue((String)"should be able to open", (container.open("fixtures/subtitled_video.mkv", IContainer.Type.READ, null) >= 0 ? 1 : 0) != 0);
        IStreamCoder coder = container.getStream(0L).getStreamCoder();
        StreamCoderTest.assertEquals((String)"should be 0 by default", (int)0, (int)coder.getCodecTag());
        coder.setCodecTag(-559038737);
        StreamCoderTest.assertEquals((String)"should be set now", (int)-559038737, (int)coder.getCodecTag());
    }

    @Test
    public void testGetCodecTagArray() {
        IContainer container = IContainer.make();
        StreamCoderTest.assertTrue((String)"should be able to open", (container.open("fixtures/subtitled_video.mkv", IContainer.Type.READ, null) >= 0 ? 1 : 0) != 0);
        IStreamCoder coder = container.getStream(0L).getStreamCoder();
        char[] tag = coder.getCodecTagArray();
        StreamCoderTest.assertNotNull((String)"should exist", (Object)tag);
        StreamCoderTest.assertEquals((String)"should always be 4", (int)4, (int)tag.length);
        for (int i = 0; i < tag.length; ++i) {
            StreamCoderTest.assertEquals((String)"should be 0 by default", (char)'\u0000', (char)tag[i]);
        }
        coder.setCodecTag(-559038737);
        StreamCoderTest.assertEquals((String)"should be set now", (int)-559038737, (int)coder.getCodecTag());
        tag = coder.getCodecTagArray();
        StreamCoderTest.assertNotNull((String)"should exist", (Object)tag);
        StreamCoderTest.assertEquals((String)"should always be 4", (int)4, (int)tag.length);
        StreamCoderTest.assertEquals((String)"test value", (int)222, (int)tag[3]);
        StreamCoderTest.assertEquals((String)"test value", (int)173, (int)tag[2]);
        StreamCoderTest.assertEquals((String)"test value", (int)190, (int)tag[1]);
        StreamCoderTest.assertEquals((String)"test value", (int)239, (int)tag[0]);
    }

    public void testSetCodecTagArray() {
        IContainer container = IContainer.make();
        StreamCoderTest.assertTrue((String)"should be able to open", (container.open("fixtures/subtitled_video.mkv", IContainer.Type.READ, null) >= 0 ? 1 : 0) != 0);
        IStreamCoder coder = container.getStream(0L).getStreamCoder();
        char[] tag = new char[4];
        tag[3] = 222;
        tag[2] = 173;
        tag[1] = 190;
        tag[0] = 239;
        coder.setCodecTag(tag);
        StreamCoderTest.assertEquals((String)"should be set now", (int)-559038737, (int)coder.getCodecTag());
    }

    @Test
    public void testGetDefaultAudioFrameSize() {
        IStreamCoder coder = this.getStreamCoder("fixtures/testfile.flv", 0);
        StreamCoderTest.assertNotNull((Object)coder);
        StreamCoderTest.assertEquals((int)coder.getDefaultAudioFrameSize(), (int)576);
        coder.setDefaultAudioFrameSize(3);
        StreamCoderTest.assertEquals((int)coder.getDefaultAudioFrameSize(), (int)3);
        StreamCoderTest.assertTrue((coder.getAudioFrameSize() != coder.getDefaultAudioFrameSize() ? 1 : 0) != 0);
        coder = IStreamCoder.make((IStreamCoder.Direction)IStreamCoder.Direction.ENCODING);
        coder.setCodec(ICodec.ID.CODEC_ID_PCM_S16LE);
        coder.setSampleRate(22050);
        coder.setChannels(1);
        StreamCoderTest.assertTrue((coder.open() >= 0 ? 1 : 0) != 0);
        StreamCoderTest.assertEquals((int)coder.getAudioFrameSize(), (int)coder.getDefaultAudioFrameSize());
        coder.setDefaultAudioFrameSize(3);
        StreamCoderTest.assertEquals((int)coder.getAudioFrameSize(), (int)coder.getDefaultAudioFrameSize());
    }

    private IStreamCoder getStreamCoder(String url, int index) {
        IStreamCoder retval = null;
        int errorVal = 0;
        this.mContainer = IContainer.make();
        StreamCoderTest.assertTrue((this.mContainer != null ? 1 : 0) != 0);
        errorVal = this.mContainer.open(url, IContainer.Type.READ, null);
        StreamCoderTest.assertTrue((errorVal >= 0 ? 1 : 0) != 0);
        this.mStream = this.mContainer.getStream((long)index);
        StreamCoderTest.assertTrue((this.mStream != null ? 1 : 0) != 0);
        StreamCoderTest.assertTrue((this.mStream.getIndex() == index ? 1 : 0) != 0);
        retval = this.mStream.getStreamCoder();
        StreamCoderTest.assertTrue((retval != null ? 1 : 0) != 0);
        return retval;
    }

    @Test
    public void testGetPropertyNames() {
        IStreamCoder coder = IStreamCoder.make((IStreamCoder.Direction)IStreamCoder.Direction.ENCODING);
        Collection properties = coder.getPropertyNames();
        StreamCoderTest.assertTrue((properties.size() > 0 ? 1 : 0) != 0);
        for (String name : properties) {
            String value = coder.getPropertyAsString(name);
            this.log.debug("{}={}", (Object)name, (Object)value);
        }
    }

    @Test
    public void testGetAutomaticallyStampOutputStream() {
        IStreamCoder coder = IStreamCoder.make((IStreamCoder.Direction)IStreamCoder.Direction.ENCODING);
        StreamCoderTest.assertTrue((boolean)coder.getAutomaticallyStampPacketsForStream());
    }

    @Test
    public void testOpenGetAndSetExtraData() {
        byte[] expected = new byte[]{1, 77, 64, 20, -1, -31, 0, 20, 39, 77, 64, 20, -87, 24, 60, 54, -9, -128, 53, 6, 1, 6, -74, -62, -75, -17, 124, 4, 1, 0, 4, 40, -34, 9, -120};
        int retval = -1;
        this.mCoder = this.getStreamCoder("fixtures/testfile_h264_mp4a_tmcd.mov", 0);
        StreamCoderTest.assertEquals((Object)ICodec.Type.CODEC_TYPE_VIDEO, (Object)this.mCoder.getCodecType());
        retval = this.mCoder.open();
        StreamCoderTest.assertTrue((String)"Could not open codec", (retval >= 0 ? 1 : 0) != 0);
        int extraDataSize = this.mCoder.getExtraDataSize();
        StreamCoderTest.assertEquals((int)expected.length, (int)extraDataSize);
        IBuffer buffer = this.mCoder.getExtraData();
        StreamCoderTest.assertNotNull((Object)buffer);
        StreamCoderTest.assertEquals((int)extraDataSize, (int)buffer.getBufferSize());
        retval = this.mCoder.close();
        StreamCoderTest.assertTrue((String)"Could not close codec", (retval >= 0 ? 1 : 0) != 0);
        byte[] actual = new byte[expected.length];
        buffer.get(0, actual, 0, actual.length);
        for (int i = 0; i < expected.length; ++i) {
            StreamCoderTest.assertEquals((String)("differ at: " + i), (byte)expected[i], (byte)actual[i]);
        }
    }
}

