/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.JNIMemoryManager;
import com.xuggle.mediatool.IMediaListener;
import com.xuggle.mediatool.IMediaReader;
import com.xuggle.mediatool.IMediaViewer;
import com.xuggle.mediatool.ToolFactory;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class MultiThreadedReadingExhaustiveTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final int mThreads;

    @Parameterized.Parameters
    public static Collection<Object[]> getModels() {
        LinkedList<Object[]> retval = new LinkedList<Object[]>();
        boolean TEST_ALL = true;
        for (JNIMemoryManager.MemoryModel model : JNIMemoryManager.MemoryModel.values()) {
            for (int i = 0; i < 5; ++i) {
                retval.add(new Object[]{model, 4 * (i + 1)});
            }
        }
        return retval;
    }

    public MultiThreadedReadingExhaustiveTest(JNIMemoryManager.MemoryModel model, int numThreads) {
        this.log.debug("Testing model: {}; Threads: {}", (Object)model, (Object)numThreads);
        this.mThreads = numThreads;
        JNIMemoryManager.setMemoryModel((JNIMemoryManager.MemoryModel)model);
    }

    @Test(timeout=1800000L)
    public void testMultiThreadedTest() throws InterruptedException {
        int i;
        if (System.getProperty("os.name", "Linux").startsWith("Windows")) {
            return;
        }
        final boolean ADD_VIEWER = System.getProperty(MultiThreadedReadingExhaustiveTest.class.getName() + ".ShowVideo") != null;
        final CyclicBarrier barrier = new CyclicBarrier(this.mThreads);
        Thread[] threads = new Thread[this.mThreads];
        final int[] numPackets = new int[this.mThreads];
        final AtomicInteger uncaughtExceptions = new AtomicInteger();
        for (i = 0; i < threads.length; ++i) {
            final int index = i;
            threads[index] = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    MultiThreadedReadingExhaustiveTest.this.log.debug("Thread {} ready to go", (Object)index);
                    try {
                        barrier.await();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    catch (BrokenBarrierException e) {
                        e.printStackTrace();
                        return;
                    }
                    IMediaReader reader = ToolFactory.makeReader((String)"fixtures/testfile_videoonly_20sec.flv");
                    try {
                        try {
                            reader.setBufferedImageTypeToGenerate(5);
                            MultiThreadedReadingExhaustiveTest.this.log.debug("Created reader: {}", (Object)reader);
                            if (ADD_VIEWER) {
                                IMediaViewer viewer = ToolFactory.makeViewer();
                                reader.addListener((IMediaListener)viewer);
                            }
                            while (reader.readPacket() == null) {
                                MultiThreadedReadingExhaustiveTest.this.log.trace("read packet: {}", (Object)numPackets[index]);
                                int n = index;
                                numPackets[n] = numPackets[n] + 1;
                            }
                            Object var4_6 = null;
                        }
                        catch (OutOfMemoryError e) {
                            numPackets[index] = -1;
                            Object var4_7 = null;
                            reader.close();
                            MultiThreadedReadingExhaustiveTest.this.log.debug("Thread exited; memory exception: {};", (Object)(numPackets[index] == -1 ? "yes" : "no"));
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        reader.close();
                        MultiThreadedReadingExhaustiveTest.this.log.debug("Thread exited; memory exception: {};", (Object)(numPackets[index] == -1 ? "yes" : "no"));
                        throw throwable;
                    }
                    reader.close();
                    MultiThreadedReadingExhaustiveTest.this.log.debug("Thread exited; memory exception: {};", (Object)(numPackets[index] == -1 ? "yes" : "no"));
                }
            }, "TestThread_" + index);
            threads[i].setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                public void uncaughtException(Thread t, Throwable e) {
                    if (!(e instanceof OutOfMemoryError)) {
                        MultiThreadedReadingExhaustiveTest.this.log.debug("Uncaught exception leaked out of thread: {}; {}", (Object)e, (Object)t);
                        e.printStackTrace();
                        uncaughtExceptions.incrementAndGet();
                    } else {
                        numPackets[index] = -1;
                    }
                }
            });
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        int numSuccess = 0;
        for (int i2 = 0; i2 < threads.length; ++i2) {
            threads[i2].join();
            if (numPackets[i2] == -1) continue;
            Assert.assertEquals((long)1062L, (long)numPackets[i2]);
            ++numSuccess;
        }
        Assert.assertEquals((long)0L, (long)uncaughtExceptions.get());
        this.log.debug("Test completed successfully: {} of {} threads ran without memory errors", (Object)numSuccess, (Object)this.mThreads);
    }
}

