/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IIndexEntry;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class IndexEntryTest {
    @Test
    public void testReadIndex() {
        IContainer container = IContainer.make();
        int retval = container.open("fixtures/testfile_h264_mp4a_tmcd.mov", IContainer.Type.READ, null);
        Assert.assertTrue((retval >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)container.getNumStreams());
        IStream stream = container.getStream(0L);
        IStreamCoder coder = stream.getStreamCoder();
        Assert.assertEquals((Object)ICodec.ID.CODEC_ID_H264, (Object)coder.getCodecID());
        Assert.assertEquals((long)2665L, (long)stream.getNumIndexEntries());
        List entries = stream.getIndexEntries();
        Assert.assertEquals((long)stream.getNumIndexEntries(), (long)entries.size());
        IIndexEntry lastEntry = (IIndexEntry)entries.get(entries.size() - 1);
        Assert.assertEquals((long)11673146L, (long)lastEntry.getPosition());
        Assert.assertEquals((long)332875L, (long)lastEntry.getTimeStamp());
        Assert.assertEquals((String)"Should not be a key frame", (long)0L, (long)lastEntry.getFlags());
        Assert.assertEquals((long)50L, (long)lastEntry.getSize());
        Assert.assertEquals((long)96L, (long)lastEntry.getMinDistance());
    }
}

