/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IContainerFormat;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import org.junit.Assert;

public class Helper {
    public final String sampleFile = "fixtures/testfile.flv";
    public IContainer mContainer = null;
    public IContainerFormat mContainerFormat = null;
    public IPacket mPacket = null;
    public IStream[] mStreams = null;
    public ICodec[] mCodecs = null;
    public IStreamCoder[] mCoders = null;
    public IAudioSamples[] mSamples = null;
    public IVideoPicture[] mFrames = null;

    public void setupReadingObject(String url) {
        int retval = -1;
        this.mPacket = IPacket.make();
        Assert.assertTrue((String)"Could not get a new packet", (this.mPacket != null ? 1 : 0) != 0);
        this.mContainer = IContainer.make();
        Assert.assertTrue((String)"Could not get a new container", (this.mContainer != null ? 1 : 0) != 0);
        retval = this.mContainer.open(url, IContainer.Type.READ, null);
        Assert.assertTrue((String)("Could not open url: " + url), (retval >= 0 ? 1 : 0) != 0);
        int numStreams = this.mContainer.getNumStreams();
        Assert.assertTrue((String)("Could not find any streams in url: " + url), (numStreams > 0 ? 1 : 0) != 0);
        this.mStreams = new IStream[numStreams];
        this.mCodecs = new ICodec[numStreams];
        this.mCoders = new IStreamCoder[numStreams];
        this.mSamples = new IAudioSamples[numStreams];
        this.mFrames = new IVideoPicture[numStreams];
        for (int i = 0; i < numStreams; ++i) {
            this.mStreams[i] = this.mContainer.getStream((long)i);
            Assert.assertTrue((String)("Could not find stream #" + i + " in url: " + url), (this.mStreams[i] != null ? 1 : 0) != 0);
            this.mCoders[i] = this.mStreams[i].getStreamCoder();
            Assert.assertTrue((String)("Could not find coder for stream #" + i + " in url: " + url), (this.mCoders[i] != null ? 1 : 0) != 0);
            this.mCodecs[i] = this.mCoders[i].getCodec();
            Assert.assertTrue((String)("Could not find codec for stream #" + i + " in url: " + url), (this.mCodecs[i] != null ? 1 : 0) != 0);
            if (this.mCoders[i].getCodecType() == ICodec.Type.CODEC_TYPE_VIDEO) {
                this.mFrames[i] = IVideoPicture.make((IPixelFormat.Type)this.mCoders[i].getPixelType(), (int)this.mCoders[i].getWidth(), (int)this.mCoders[i].getHeight());
                Assert.assertTrue((String)"could not allocate memory for frame", (this.mFrames[i] != null ? 1 : 0) != 0);
                this.mSamples[i] = null;
                continue;
            }
            if (this.mCoders[i].getCodecType() == ICodec.Type.CODEC_TYPE_AUDIO) {
                this.mSamples[i] = IAudioSamples.make((long)1024L, (long)1L);
                Assert.assertTrue((String)"Could not get audio samples buffer", (this.mSamples[i] != null ? 1 : 0) != 0);
                Assert.assertTrue((String)"Could not allocate memory for samples", (this.mSamples[i].getMaxBufferSize() >= 1024L ? 1 : 0) != 0);
                this.mFrames[i] = null;
                continue;
            }
            this.mFrames[i] = null;
            this.mSamples[i] = null;
        }
    }

    public void cleanupHelper() {
        int i = 0;
        if (this.mContainer != null) {
            this.mContainer.delete();
            this.mContainer = null;
        }
        if (this.mContainerFormat != null) {
            this.mContainerFormat.delete();
            this.mContainerFormat = null;
        }
        if (this.mPacket != null) {
            this.mPacket.delete();
            this.mPacket = null;
        }
        if (this.mStreams != null) {
            for (i = 0; i < this.mStreams.length; ++i) {
                if (this.mStreams[i] == null) continue;
                this.mStreams[i].delete();
                this.mStreams[i] = null;
            }
            this.mStreams = null;
        }
        if (this.mCodecs != null) {
            for (i = 0; i < this.mCodecs.length; ++i) {
                if (this.mCodecs[i] == null) continue;
                this.mCodecs[i].delete();
                this.mCodecs[i] = null;
            }
            this.mCodecs = null;
        }
        if (this.mCoders != null) {
            for (i = 0; i < this.mCoders.length; ++i) {
                if (this.mCoders[i] == null) continue;
                this.mCoders[i].delete();
                this.mCoders[i] = null;
            }
            this.mCoders = null;
        }
        if (this.mSamples != null) {
            for (i = 0; i < this.mSamples.length; ++i) {
                if (this.mSamples[i] == null) continue;
                this.mSamples[i].delete();
                this.mSamples[i] = null;
            }
            this.mSamples = null;
        }
        if (this.mFrames != null) {
            for (i = 0; i < this.mFrames.length; ++i) {
                if (this.mFrames[i] == null) continue;
                this.mFrames[i].delete();
                this.mFrames[i] = null;
            }
            this.mFrames = null;
        }
        System.gc();
    }
}

