/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.ferry;

import com.xuggle.ferry.Mutex;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutexTest {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Mutex mMutex = null;
    private boolean mTestFail = false;

    @Before
    public void setUp() {
        if (this.mMutex != null) {
            this.mMutex.delete();
        }
        this.mMutex = Mutex.make();
        Assert.assertTrue((String)"didn't get a mutex", (this.mMutex != null ? 1 : 0) != 0);
        this.mTestFail = false;
    }

    @Test
    public void testUncompetitiveLockAndUnlock() {
        long before = -1L;
        long after = -1L;
        before = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            this.mMutex.lock();
            this.mMutex.unlock();
        }
        after = System.currentTimeMillis();
        Assert.assertTrue((String)"not really fast", (after - before < 100L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testCompetitiveLockAndUnlock() {
        long before = -1L;
        long after = -1L;
        Thread competitor = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                MutexTest.this.log.debug("Competitor is running");
                MutexTest.this.mMutex.lock();
                MutexTest.this.log.debug("Got the lock");
                Mutex mutex = MutexTest.this.mMutex;
                synchronized (mutex) {
                    MutexTest.this.mMutex.notifyAll();
                    MutexTest.this.log.debug("Notified other thread");
                }
                try {
                    MutexTest.this.log.debug("Going to sleep");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    MutexTest.this.log.error("interrupted while sleeping");
                    MutexTest.this.mTestFail = true;
                }
                MutexTest.this.mMutex.unlock();
                MutexTest.this.log.debug("And exiting the thread");
            }
        }, "Competitor");
        before = System.currentTimeMillis();
        Mutex mutex = this.mMutex;
        synchronized (mutex) {
            try {
                this.log.debug("Starting the competitor");
                competitor.start();
                this.log.debug("Waiting for the competitor to get the lock");
                this.mMutex.wait();
            }
            catch (InterruptedException ex) {
                Assert.fail((String)"was interrupted");
            }
        }
        this.log.debug("Trying the lock... should wait...");
        this.mMutex.lock();
        this.log.debug("Got the lock.");
        after = System.currentTimeMillis();
        Assert.assertTrue((String)"too fast", (after - before > 500L ? 1 : 0) != 0);
        try {
            competitor.join();
        }
        catch (InterruptedException ex) {
            Assert.fail((String)"was interrupted");
        }
        this.log.debug("releasing the lock");
        this.mMutex.unlock();
        Assert.assertTrue((String)"we appear to have failed in the other thread", (!this.mTestFail ? 1 : 0) != 0);
    }
}

