/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.ferry;

import com.xuggle.ferry.Logger;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;

public class LoggerTest
extends TestCase {
    private Logger mLog = null;

    @Before
    public void setUp() {
        this.mLog = null;
    }

    @Test
    public void testLogger() {
        boolean retval = false;
        this.mLog = Logger.getLogger((String)(((Object)((Object)this)).getClass().getName() + ".native"));
        retval = this.mLog.log("Java", 0, Logger.Level.LEVEL_ERROR, "This is an error msg");
        LoggerTest.assertTrue((boolean)retval);
        retval = this.mLog.log("Java", 0, Logger.Level.LEVEL_WARN, "This is a warn msg");
        LoggerTest.assertTrue((boolean)retval);
        retval = this.mLog.log("Java", 0, Logger.Level.LEVEL_INFO, "This is an info msg");
        LoggerTest.assertTrue((boolean)retval);
        retval = this.mLog.log("Java", 0, Logger.Level.LEVEL_DEBUG, "This is a debug msg");
        LoggerTest.assertTrue((boolean)retval);
        retval = this.mLog.log("Java", 0, Logger.Level.LEVEL_TRACE, "This is a trace msg");
        LoggerTest.assertTrue((String)"shouldn't log trace messages by default", (!retval ? 1 : 0) != 0);
        LoggerTest.assertTrue((String)"all tests seemed to pass without crashes", (boolean)true);
    }

    @Test
    public void testManyThreadsLogging() {
        int numThreads = 100;
        int numMsgs = 100;
        Thread[] threads = null;
        int i = 0;
        this.mLog = Logger.getLogger((String)(((Object)((Object)this)).getClass().getName() + ".native"));
        threads = new Thread[100];
        LoggerTest.assertTrue((String)"couldn't allocate the threads", (threads != null ? 1 : 0) != 0);
        for (i = 0; i < 100; ++i) {
            threads[i] = new Thread(new Runnable(){

                public void run() {
                    int j = 0;
                    for (j = 0; j < 100; ++j) {
                        LoggerTest.this.mLog.error("Competitor", 0, "Look at me; I'm a logging message: " + j);
                    }
                }
            }, "logging thread " + i);
            threads[i].start();
        }
        for (i = 0; i < 100; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException ex) {
                LoggerTest.fail((String)"got interrupted");
            }
        }
        LoggerTest.assertTrue((String)"well, didn't crash which is what we're hoping to avoid", (boolean)true);
    }
}

