/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.ferry;

import com.xuggle.ferry.AtomicInteger;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicIntegerTest
extends TestCase {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private AtomicInteger ai;
    private int val;

    @Before
    public void setUp() {
        this.log.debug("Executing test case: {}", (Object)this.getName());
        this.ai = null;
        this.val = 0;
    }

    @Test
    public void testCreation() {
        this.ai = new AtomicInteger();
        this.val = this.ai.get();
        AtomicIntegerTest.assertTrue((String)"not initialized correctly", (this.val == 0 ? 1 : 0) != 0);
        this.ai = new AtomicInteger(5);
        this.val = this.ai.get();
        AtomicIntegerTest.assertTrue((String)"not intialized correctly", (this.val == 5 ? 1 : 0) != 0);
    }

    @Test
    @Ignore
    public void testIsAtomic() {
        this.ai = new AtomicInteger();
        AtomicIntegerTest.assertTrue((String)"is not using JVM for atomic locks", (boolean)this.ai.isAtomic());
    }

    @Test
    public void testSet() {
        this.ai = new AtomicInteger(8);
        this.val = this.ai.get();
        AtomicIntegerTest.assertTrue((this.val == 8 ? 1 : 0) != 0);
        this.ai.set(15);
        this.val = this.ai.get();
        AtomicIntegerTest.assertTrue((this.val == 15 ? 1 : 0) != 0);
    }

    @Test
    public void testGetAndDoSomethingMethods() {
        this.ai = new AtomicInteger();
        this.val = this.ai.getAndAdd(5);
        AtomicIntegerTest.assertTrue((this.val == 0 ? 1 : 0) != 0);
        AtomicIntegerTest.assertTrue((this.ai.get() == 5 ? 1 : 0) != 0);
        this.val = this.ai.getAndIncrement();
        AtomicIntegerTest.assertTrue((this.val == 5 ? 1 : 0) != 0);
        AtomicIntegerTest.assertTrue((this.ai.get() == 6 ? 1 : 0) != 0);
        this.val = this.ai.getAndDecrement();
        AtomicIntegerTest.assertTrue((this.val == 6 ? 1 : 0) != 0);
        AtomicIntegerTest.assertTrue((this.ai.get() == 5 ? 1 : 0) != 0);
        this.val = this.ai.getAndSet(11);
        AtomicIntegerTest.assertTrue((this.val == 5 ? 1 : 0) != 0);
        AtomicIntegerTest.assertTrue((this.ai.get() == 11 ? 1 : 0) != 0);
    }

    @Test
    public void testDoSomethingAndGetMethods() {
        this.ai = new AtomicInteger();
        this.val = this.ai.addAndGet(5);
        AtomicIntegerTest.assertTrue((this.val == 5 ? 1 : 0) != 0);
        AtomicIntegerTest.assertTrue((this.ai.get() == 5 ? 1 : 0) != 0);
        this.val = this.ai.incrementAndGet();
        AtomicIntegerTest.assertTrue((this.val == 6 ? 1 : 0) != 0);
        AtomicIntegerTest.assertTrue((this.ai.get() == 6 ? 1 : 0) != 0);
        this.val = this.ai.decrementAndGet();
        AtomicIntegerTest.assertTrue((this.val == 5 ? 1 : 0) != 0);
        AtomicIntegerTest.assertTrue((this.ai.get() == 5 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareAndSet() {
        this.ai = new AtomicInteger(10);
        this.val = this.ai.get();
        AtomicIntegerTest.assertTrue((this.val == 10 ? 1 : 0) != 0);
        boolean result = false;
        result = this.ai.compareAndSet(5, 8);
        this.val = this.ai.get();
        AtomicIntegerTest.assertTrue((!result ? 1 : 0) != 0);
        AtomicIntegerTest.assertTrue((this.val == 10 ? 1 : 0) != 0);
        result = this.ai.compareAndSet(10, 8);
        this.val = this.ai.get();
        AtomicIntegerTest.assertTrue((result ? 1 : 0) != 0);
        AtomicIntegerTest.assertTrue((this.val == 8 ? 1 : 0) != 0);
    }

    @Test
    public void testMultiThreadCompetition() {
        Thread[] threads = new Thread[10];
        int i = 0;
        this.ai = new AtomicInteger(0);
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(new Runnable(){

                public void run() {
                    for (int j = 0; j < 10000; ++j) {
                        AtomicIntegerTest.this.ai.incrementAndGet();
                    }
                }
            });
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException ex) {
                this.log.debug("Got an interruption");
                AtomicIntegerTest.fail((String)"got an interruption");
            }
        }
        this.log.debug("AI final value = {}", (Object)this.ai.get());
        AtomicIntegerTest.assertTrue((String)"value not as expected", (this.ai.get() == 100000 ? 1 : 0) != 0);
    }
}

